/**********************\
*                      *
*  Read/write streams  *
*                      *
\**********************/

/*
 * Known bugs:
 *
 * - Saving too many embded objects will cause incorrect indentation
 * - Long strings will be cut at load
 */

#include <stdio.h>
#include "streams.h"

/*
 * TCADSaveStream
 */

TCADSaveStream::TCADSaveStream(char *FileName,char *Success)
{
  Depth = 0;
  Spaces[0] = 0;
  Fl = fopen(FileName,"w");
  *Success = (Fl != 0);
}

TCADSaveStream::~TCADSaveStream()
{
  if (Fl != 0) fclose(Fl);
}

void TCADSaveStream::SaveInt(char *Name,int Data)
{
  if (Fl == 0) return;

  fprintf(Fl,"%s%s=%d\n",Spaces,Name,Data);
}

void TCADSaveStream::SaveString(char *Name,char *Data)
{
  const unsigned int BUFSIZE=254;
  char Buffer[BUFSIZE+2];
  int Off;

  if (Fl == 0) return;

  fprintf(Fl,"%s%s=",Spaces,Name);

  // Convert
  Off = 0;
  while(*Data) {
    if ((*Data == '^') || (*Data < 32)) {
      Buffer[Off++] = '^';
      Buffer[Off++] = *Data + 64;
    }
    else Buffer[Off++] = *Data;

    if (Off >= BUFSIZE) {
      // Flush
      Buffer[Off] = 0;
      fputs(Buffer,Fl);
      Off = 0;
    }

    Data++;
  }
  Buffer[Off] = 0;
  fputs(Buffer,Fl);
  fputc(10,Fl);
}

void TCADSaveStream::SaveObjectName(char *Name)
{
  if (Fl == 0) return;

  fprintf(Fl,"%s%s {\n",Spaces,Name);
  if (Depth < MAXDEPTH) {
    Spaces[Depth++] = ' ';
    Spaces[Depth++] = ' ';
    Spaces[Depth] = 0;
  }
}

void TCADSaveStream::SaveEndObject()
{
  if (Fl == 0) return;

  Depth -= 2;
  if (Depth < 0) Depth = 0;
  Spaces[Depth] = 0;

  fprintf(Fl,"%s}\n",Spaces);
}



/*
 * TCADLoadStream
 */

TCADLoadStream::TCADLoadStream(char *FileName,char *Success)
{
  ID[0] = 0;
  WasLF = 1;
  Fl = fopen(FileName,"r");
  *Success = (Fl != 0);
}

TCADLoadStream::~TCADLoadStream()
{
  if (Fl != 0) fclose(Fl);
}

char *TCADLoadStream::ReadID()
{
  int a;
  int IDOff = 0;

  WasLF = 0;
  if (Fl == 0) return(ID);

  for(;;) {
    do {
      a = fgetc(Fl);
    } while(a == 13); // Ignore CRs
    
    if (a < 0) {
      WasLF = 1;
      Buffer[0] = 0;
      return(ID);
    }

    if ((a == 10) || (a == '=')) {
      WasLF = (a == 10);
      ID[IDOff] = 0;
      return(ID);
    }

    if ((a != ' ') && (a != '{') && (a != '}'))  // Ignore these characters
     if (IDOff < MAXIDLEN) ID[IDOff++] = a;
  }
}

void TCADLoadStream::ReadROL()
{
  char a;
  int BufOff;
  
  BufOff = 0;
  for(;;) {
    do {
      a = fgetc(Fl);
    } while(a == 13);
    
    if ((a == -1) || (a == 10)) break;

    if (BufOff < BUFSIZE) Buffer[BufOff++] = a;
  }
  
  Buffer[BufOff] = 0;
}

char *TCADLoadStream::LoadString()
{
  char *SrcPtr,*DstPtr;

  if (Fl == 0) return(ID);

  if (WasLF) {
    Buffer[0] = 0;
    return(Buffer);
  }

  ReadROL();  // Read rest of line to buffer

  // Convert text
  SrcPtr = Buffer;
  DstPtr = Buffer;
  while(*SrcPtr) {
    if (*SrcPtr == '^') {
      SrcPtr++;
      if (*SrcPtr == 0) {
        *DstPtr++ = '^';
	break;
      }
      else *DstPtr++ = *SrcPtr++ - 64;
    }
    else *DstPtr++ = *SrcPtr++;
  }
  *DstPtr = 0;

  return(Buffer);
}

int TCADLoadStream::LoadInt()
{
  int Result;

  if (Fl == 0) return(0);

  if (WasLF) return(0);

  ReadROL();  // Read rest of line to buffer

  Result = 0;
  sscanf(Buffer,"%d",&Result);
  return(Result);
}
      
void TCADLoadStream::Skip()
{
  if (ID[0] == 0) return;  // Don't skip EOF

  if (WasLF) {
    int Depth=1;
    
    // Skip object
    while(Depth > 0) {
      ReadID();
      if (ID[0] == 0) Depth--;  // End of object
      else if (WasLF) Depth++;  // Another object
      else LoadString();        // Skip value
    }
  }
  else LoadString(); // Skip value
}
