/**********************\
*                      *
*  Read/write streams  *
*                      *
\**********************/

#ifndef GTKFIG_STREAMS_H
#define GTKFIG_STREAMS_H

#include <stdio.h>

/*
 * Stream for saving
 */
class TCADSaveStream {
protected:
  static const unsigned int MAXDEPTH=100;
  FILE *Fl;
  int Depth;
  char Spaces[MAXDEPTH+3];
public:
  TCADSaveStream(char *FileName,char *Success);
  ~TCADSaveStream();

  void SaveInt(char *Name,int Data);
  void SaveString(char *Name,char *Data);
  void SaveObjectName(char *Name);
  void SaveEndObject();
};

/*
 * Stream for loading
 */
class TCADLoadStream {
protected:
  static const unsigned int BUFSIZE=4096;
  static const unsigned int MAXIDLEN=64;
  FILE *Fl;
  char ID[MAXIDLEN+3];
  char Buffer[BUFSIZE+3];

  char WasLF;

  void ReadROL();  // Reads rest of line
public:
  TCADLoadStream(char *FileName,char *Success);
  ~TCADLoadStream();

  char *ReadID();
  char *LoadString();
  int LoadInt();

  // If ID was value, skips value, if ID was object, skips whole object
  void Skip();
};

#endif

