/********\
*        *
*  Text  *
*        *
\********/

#ifndef GTKFIG_TEXT_H
#define GTKFIG_TEXT_H

#include "textobject.h"

/*
 * Text
 */

class TCADText : public TCADTextObject {
protected:
  gchar *Text;
  int Lines;
  int TextLength;  // Includes \0 at the end

  virtual void GetOffsets(int& TOff,int& BOff,int& LOff,int& ROff);

  // Exports text to FIG format
  virtual void ExportFigText(FILE *Fl);
public:
  TCADText(TCADSheet *Sheet);
  ~TCADText();
  virtual void Save(TCADSaveStream *Fl);
  virtual void SaveProperties(TCADSaveStream *Fl);
  virtual char LoadProperty(TCADLoadStream *Fl,char *ID);
  virtual void Export(FILE *Fl,TExportFormat Format);

  virtual gchar *GetText();
  virtual void SetText(gchar *Text);

  virtual void Draw(GdkRegion *Region);

  virtual void Select(GdkRectangle *RefreshRect);
};


#endif
