/**************\
*              *
*  TextObject  *
*              *
\**************/

#ifndef GTKFIG_TEXTOBJECT_H
#define GTKFIG_TEXTOBJECT_H

#include "sheet.h"
#include "textproperties.h"
#include "rectangleobject.h"

/*
 *  Generic class for objects which have text
 */
class TCADTextObject : public TCADRectangleObject,public TCADTextPropertiesI {
public:
  TCADTextObject(TCADSheet *Sheet) : TCADRectangleObject(Sheet) { };

  virtual gboolean HasText() { return TRUE; }

  // Gets text. Please note that returned string is
  // malloc()-ed, so you must free it with free()!
  virtual gchar *GetText() = 0;

  // Text will be duplicated, so you eventually need to free it.
  virtual void SetText(gchar *Text) = 0;

  void RefreshText(TVAlign VA,THAlign HA) { TextVAlign = VA; TextHAlign = HA; Sheet->DrawRect(&EncapRect); }
};

#endif

