/*******************\
*                   *
*  Text properties  *
*                   *
\*******************/

#include <string.h>
#include <gtk/gtk.h>
#include "textproperties.h"
#include "textobject.h"
#include "object.h"

TCADObject *Selected;
GtkWidget *Dialog;
GtkWidget *RBBR;
GtkWidget *RBB;
GtkWidget *RBBL;
GtkWidget *RBR;
GtkWidget *RBC;
GtkWidget *RBL;
GtkWidget *RBTR;
GtkWidget *RBT;
GtkWidget *RBTL;

TVAlign TextVAlign;
THAlign TextHAlign;

TCADTextPropertiesI::TCADTextPropertiesI()
{
  TextHAlign = AL_HCENTER;
  TextVAlign = AL_VCENTER;

  TextFont = gdk_font_load("-adobe-times-medium-r-normal--12-120-75-75-p-64-iso8859-1");
}

TCADTextPropertiesI::~TCADTextPropertiesI()
{
}

static void on_BCancel_clicked (GtkButton *button, gpointer user_data)
{
  button = button;
  user_data = user_data;

  // Make window non-modal
  gtk_grab_remove(Dialog);

  // Close window
  gtk_widget_destroy(Dialog);
}

static void GetSettings()
{
  if (GTK_TOGGLE_BUTTON(RBBR)->active) {
    TextVAlign = AL_BOTTOM;
    TextHAlign = AL_RIGHT;
  }
  else if (GTK_TOGGLE_BUTTON(RBB)->active) {
    TextVAlign = AL_BOTTOM;
    TextHAlign = AL_HCENTER;
  }
  else if (GTK_TOGGLE_BUTTON(RBBL)->active) {
    TextVAlign = AL_BOTTOM;
    TextHAlign = AL_LEFT;
  }
  else if (GTK_TOGGLE_BUTTON(RBR)->active) {
    TextVAlign = AL_VCENTER;
    TextHAlign = AL_RIGHT;
  }
  else if (GTK_TOGGLE_BUTTON(RBC)->active) {
    TextVAlign = AL_VCENTER;
    TextHAlign = AL_HCENTER;
  }
  else if (GTK_TOGGLE_BUTTON(RBL)->active) {
    TextVAlign = AL_VCENTER;
    TextHAlign = AL_LEFT;
  }
  else if (GTK_TOGGLE_BUTTON(RBTR)->active) {
    TextVAlign = AL_TOP;
    TextHAlign = AL_RIGHT;
  }
  else if (GTK_TOGGLE_BUTTON(RBT)->active) {
    TextVAlign = AL_TOP;
    TextHAlign = AL_HCENTER;
  }
  else if (GTK_TOGGLE_BUTTON(RBTL)->active) {
    TextVAlign = AL_TOP;
    TextHAlign = AL_LEFT;
  }
}

static void on_BOK_clicked (GtkButton *button, gpointer user_data)
{
  // Get settings
  GetSettings();

  // Close window
  on_BCancel_clicked(button,user_data);

  // Refresh line arrows
  while(Selected != 0) {
    if (Selected->HasText()) ((TCADTextObject *)Selected)->RefreshText(TextVAlign,TextHAlign);
    Selected = Selected->NextSelected;
  }
}


static GtkWidget*
CreateDialog()
{
  GtkWidget *DTextProperties;
  GtkWidget *dialog_vbox1;
  GtkWidget *vbox1;
  GtkWidget *FAlign;
  GtkWidget *table2;
  GSList *table2_group = NULL;
  GtkWidget *dialog_action_area1;
  GtkWidget *hbox1;
  GtkWidget *BOK;
  GtkWidget *BApply;
  GtkWidget *BCancel;

  DTextProperties = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (DTextProperties), "DTextProperties", DTextProperties);
  gtk_window_set_title (GTK_WINDOW (DTextProperties), "Text properties");
  gtk_window_set_policy (GTK_WINDOW (DTextProperties), TRUE, TRUE, FALSE);

  dialog_vbox1 = GTK_DIALOG (DTextProperties)->vbox;
  gtk_object_set_data (GTK_OBJECT (DTextProperties), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (DTextProperties), "vbox1", vbox1);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

  FAlign = gtk_frame_new ("Alignment");
  gtk_object_set_data (GTK_OBJECT (DTextProperties), "FAlign", FAlign);
  gtk_widget_show (FAlign);
  gtk_box_pack_start (GTK_BOX (vbox1), FAlign, TRUE, TRUE, 0);

  table2 = gtk_table_new (3, 3, TRUE);
  gtk_object_set_data (GTK_OBJECT (DTextProperties), "table2", table2);
  gtk_widget_show (table2);
  gtk_container_add (GTK_CONTAINER (FAlign), table2);

  RBBR = gtk_radio_button_new_with_label (table2_group, "Bottom right");
  table2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBBR));
  gtk_object_set_data (GTK_OBJECT (DTextProperties), "RBBR", RBBR);
  gtk_widget_show (RBBR);
  gtk_table_attach (GTK_TABLE (table2), RBBR, 2, 3, 2, 3,
                    (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (RBBR), FALSE);

  RBB = gtk_radio_button_new_with_label (table2_group, "Bottom");
  table2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBB));
  gtk_object_set_data (GTK_OBJECT (DTextProperties), "RBB", RBB);
  gtk_widget_show (RBB);
  gtk_table_attach (GTK_TABLE (table2), RBB, 1, 2, 2, 3,
                    (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (RBB), FALSE);

  RBBL = gtk_radio_button_new_with_label (table2_group, "Bottom left");
  table2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBBL));
  gtk_object_set_data (GTK_OBJECT (DTextProperties), "RBBL", RBBL);
  gtk_widget_show (RBBL);
  gtk_table_attach (GTK_TABLE (table2), RBBL, 0, 1, 2, 3,
                    (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (RBBL), FALSE);

  RBR = gtk_radio_button_new_with_label (table2_group, "Right");
  table2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBR));
  gtk_object_set_data (GTK_OBJECT (DTextProperties), "RBR", RBR);
  gtk_widget_show (RBR);
  gtk_table_attach (GTK_TABLE (table2), RBR, 2, 3, 1, 2,
                    (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (RBR), FALSE);

  RBC = gtk_radio_button_new_with_label (table2_group, "Center");
  table2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBC));
  gtk_object_set_data (GTK_OBJECT (DTextProperties), "RBC", RBC);
  gtk_widget_show (RBC);
  gtk_table_attach (GTK_TABLE (table2), RBC, 1, 2, 1, 2,
                    (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (RBC), FALSE);

  RBL = gtk_radio_button_new_with_label (table2_group, "Left");
  table2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBL));
  gtk_object_set_data (GTK_OBJECT (DTextProperties), "RBL", RBL);
  gtk_widget_show (RBL);
  gtk_table_attach (GTK_TABLE (table2), RBL, 0, 1, 1, 2,
                    (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (RBL), FALSE);

  RBTR = gtk_radio_button_new_with_label (table2_group, "Top right");
  table2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBTR));
  gtk_object_set_data (GTK_OBJECT (DTextProperties), "RBTR", RBTR);
  gtk_widget_show (RBTR);
  gtk_table_attach (GTK_TABLE (table2), RBTR, 2, 3, 0, 1,
                    (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (RBTR), FALSE);
  RBT = gtk_radio_button_new_with_label (table2_group, "Top");
  table2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBT));
  gtk_object_set_data (GTK_OBJECT (DTextProperties), "RBT", RBT);
  gtk_widget_show (RBT);
  gtk_table_attach (GTK_TABLE (table2), RBT, 1, 2, 0, 1,
                    (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (RBT), FALSE);

  RBTL = gtk_radio_button_new_with_label (table2_group, "Top left");
  table2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (RBTL));
  gtk_object_set_data (GTK_OBJECT (DTextProperties), "RBTL", RBTL);
  gtk_widget_show (RBTL);
  gtk_table_attach (GTK_TABLE (table2), RBTL, 0, 1, 0, 1,
                    (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (RBTL), FALSE);

  dialog_action_area1 = GTK_DIALOG (DTextProperties)->action_area;
  gtk_object_set_data (GTK_OBJECT (DTextProperties), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  hbox1 = gtk_hbox_new (TRUE, 5);
  gtk_object_set_data (GTK_OBJECT (DTextProperties), "hbox1", hbox1);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (dialog_action_area1), hbox1, TRUE, TRUE, 0);

  BOK = gtk_button_new_with_label ("OK");
  gtk_object_set_data (GTK_OBJECT (DTextProperties), "BOK", BOK);
  gtk_widget_show (BOK);
  gtk_box_pack_start (GTK_BOX (hbox1), BOK, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (BOK), "clicked",
                      GTK_SIGNAL_FUNC (on_BOK_clicked),NULL);
						

  BApply = gtk_button_new_with_label ("Apply");
  gtk_object_set_data (GTK_OBJECT (DTextProperties), "BApply", BApply);
  BCancel = gtk_button_new_with_label ("Cancel");
  gtk_object_set_data (GTK_OBJECT (DTextProperties), "BCancel", BCancel);
  gtk_widget_show (BCancel);
  gtk_box_pack_start (GTK_BOX (hbox1), BCancel, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (BCancel), "clicked",
                      GTK_SIGNAL_FUNC (on_BCancel_clicked),NULL);

  return DTextProperties;
}


void TCADTextPropertiesI::ShowTextProperties(TCADObject *Obj)
{
  GtkWidget *DefB = NULL;

  Selected = Obj;

  Dialog = CreateDialog();

  // Set button which is on
  switch(TextHAlign) {
    case AL_LEFT:
      switch(TextVAlign) {
        case AL_TOP:
	  DefB = RBTL;
	  break;
        case AL_VCENTER:
	  DefB = RBL;
	  break;
        case AL_BOTTOM:
	  DefB = RBBL;
	  break;
      }
      break;
    case AL_HCENTER:
      switch(TextVAlign) {
        case AL_TOP:
	  DefB = RBT;
	  break;
        case AL_VCENTER:
	  DefB = RBC;
	  break;
        case AL_BOTTOM:
	  DefB = RBB;
	  break;
      }
      break;
    case AL_RIGHT:
      switch(TextVAlign) {
        case AL_TOP:
	  DefB = RBTR;
	  break;
        case AL_VCENTER:
	  DefB = RBR;
	  break;
        case AL_BOTTOM:
	  DefB = RBBR;
	  break;
      }
      break;
  }
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (DefB), TRUE);

  gtk_widget_show(Dialog);
  gtk_grab_add(Dialog);
}

void TCADTextPropertiesI::SaveTextProperties(TCADSaveStream *Fl)
{
  Fl->SaveInt("TextHAlign",TextHAlign);
  Fl->SaveInt("TextVAlign",TextVAlign);
}

char TCADTextPropertiesI::LoadProperty(TCADLoadStream *Fl,char *ID)
{
  if (strcasecmp("TextHAlign",ID) == 0) TextHAlign = (THAlign)Fl->LoadInt();
  else if (strcasecmp("TextVAlign",ID) == 0) TextVAlign = (TVAlign)Fl->LoadInt();
  else return(0);

  return(1);
}

