/*******************\
*                   *
*  Text properties  *
*                   *
\*******************/

#ifndef GTKFIG_TEXT_PROPERTIES_H
#define GTKFIG_TEXT_PROPERTIES_H

#include <gdk/gdk.h>
#include "streams.h"
#include "object.h"

/*
 * Alignment types
 */

typedef enum { AL_LEFT, AL_HCENTER, AL_RIGHT /*,  AL_HFULL */ } THAlign;
typedef enum { AL_TOP,  AL_VCENTER, AL_BOTTOM /*, AL_VFULL */ } TVAlign;

/*
 * Defines interface of text properties
 */
class TCADTextPropertiesI {
protected:
  GdkFont *TextFont;
  GdkColor *TextColor;
  THAlign TextHAlign;
  TVAlign TextVAlign;
  void SaveTextProperties(TCADSaveStream *Fl);
  char LoadProperty(TCADLoadStream *Fl,char *ID);
public:
  TCADTextPropertiesI();
  ~TCADTextPropertiesI();

  void ShowTextProperties(TCADObject *Obj);
};

#endif

