/*************************************************\
*                                                 *
*  Defines signals received from toolbar buttons  *
*                                                 *
\*************************************************/

#include <gtk/gtkbutton.h>
#include <gtk/gtktogglebutton.h>
#include "main.h"

static int PressState;

void on_BB_released(GtkButton *button, gpointer user_data)
{
  user_data = user_data;

  // Make button back down
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button),1);
}

gboolean
on_BB_button_press_event(GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
  widget = widget;
  user_data = user_data;
  PressState = event->state;  // Store state
}


void on_BBPointer_pressed(GtkButton *button, gpointer user_data)
{
  user_data = user_data; button=button;

  System->BBPointerPressed();
}

void on_BBLine_pressed(GtkButton *button, gpointer user_data)
{
  user_data = user_data; button=button;

  System->BBLinePressed(PressState & GDK_SHIFT_MASK);
}

void on_BBRightAngleLine_pressed(GtkButton *button, gpointer user_data)
{
  user_data = user_data; button=button;

  System->BBAngleLinePressed(PressState & GDK_SHIFT_MASK);
}

void on_BBFrame_pressed(GtkButton *button, gpointer user_data)
{
  user_data = user_data; button=button;

  System->BBFramePressed(PressState & GDK_SHIFT_MASK);
}

void on_BBText_pressed(GtkButton *button, gpointer user_data)
{
  user_data = user_data; button=button;

  System->BBTextPressed(PressState & GDK_SHIFT_MASK);
}

void on_BBFramedText_pressed(GtkButton *button, gpointer user_data)
{
  user_data = user_data; button=button;

  System->BBFramedTextPressed(PressState & GDK_SHIFT_MASK);
}


