/*************************\
*                         *
*  Arrow drawing routine  *
*                         *
\*************************/

#include <math.h>
#include "drawarrow.h"

void DrawArrow(GdkDrawable *Drawable,GdkGC *GC,GdkPoint *Point,GdkPoint *SecondPoint,TArrowStyle Type,int Size)
{
  int DX,DY;
  double D;
  int V1X,V1Y,V2X,V2Y;
  int X,Y;
  GdkPoint P[4];  // Array of points
  GdkGCValues GCValues;

  if (Type == AR_NONE) return;  // Nothing to draw

  DX = SecondPoint->x - Point->x;
  DY = SecondPoint->y - Point->y;
  X = Point->x;
  Y = Point->y;
/*
  if (DX < 0) DX--;
  else DX++;
  if (DY < 0) DY--;
  else DY++;
*/
  if (DY == 0) {
    if (DX <= 0) V1X = -Size;
    else V1X = Size;
    V1Y = 0;
  }
  else if (DX == 0) {
    V1X = 0;
    if (DY <= 0) V1Y = -Size;
    else V1Y = Size;
  }
  else {
    D = sqrt(DX*DX+DY*DY);
    V1X = (int)(DX*Size/D);
    V1Y = (int)(DY*Size/D);
  }

  V2X = V1Y/2;
  V2Y = -V1X/2;

  switch(Type) {
    case AR_NONE:
      break;
    case AR_SIMPLE:
      gdk_draw_line(Drawable,GC,X,Y,X+V1X+V2X,Y+V1Y+V2Y);
      gdk_draw_line(Drawable,GC,X,Y,X+V1X-V2X,Y+V1Y-V2Y);
      break;
    case AR_BLACK:
    case AR_WHITE:
      P[0].x = X;
      P[0].y = Y;
      P[1].x = X+V1X+V2X;
      P[1].y = Y+V1Y+V2Y;
      P[2].x = X+V1X-V2X;
      P[2].y = Y+V1Y-V2Y;
      P[3].x = X;
      P[3].y = Y;
      if (Type == AR_WHITE) {
        gdk_gc_get_values(GC,&GCValues);
        gdk_gc_set_foreground(GC,&GCValues.background);
        gdk_draw_polygon(Drawable,GC,1,P,4);
        gdk_gc_set_foreground(GC,&GCValues.foreground);
        gdk_draw_polygon(Drawable,GC,0,P,4);
      }
      else {
        gdk_draw_polygon(Drawable,GC,1,P,4);
      }
      break;
    
  }
}


