/************************\
*                        *
*  Implements TCADFrame  *
*                        *
\************************/

#include "frame.h"
#include "sheet.h"

void
TCADFrame::Save(TCADSaveStream *Fl)
{
  Fl->SaveObjectName("TCADFrame");
  SaveProperties(Fl);
  Fl->SaveEndObject();  
}

void
TCADFrame::SaveProperties(TCADSaveStream *Fl)
{
  SaveLineProperties(Fl);
  TCADObject::SaveProperties(Fl);
}

char
TCADFrame::LoadProperty(TCADLoadStream *Fl,char *ID)
{
  if (TCADLinePropertiesI::LoadProperty(Fl,ID)) return(TRUE);
  else return(TCADObject::LoadProperty(Fl,ID));
}

void
TCADFrame::Draw(GdkRegion *Region)
{
  if (Region)
   if (gdk_region_rect_in(Region, &EncapRect) == GDK_OVERLAP_RECTANGLE_OUT) return;

  gdk_draw_rectangle(Sheet->GetDrawable(),Sheet->GC,0,EncapRect.x,EncapRect.y,EncapRect.width-1,EncapRect.height-1);
}

void
TCADFrame::Select(GdkRectangle *RefreshRect)
{
  TCADObject::Select(RefreshRect);
  UpdateHandlePos();
}

void
TCADFrame::Export(FILE *Fl,TExportFormat Format)
{

  switch(Format) {
    case EF_LATEX:
      int x,y;
      x = EncapRect.x;
      y = Sheet->EncapRect.height-EncapRect.y-EncapRect.height;
      fprintf(Fl,"\\put(%d,%d){\\framebox(%d,%d){}}\n",x,y,EncapRect.width,EncapRect.height);
      break;
    case EF_FIG:
      ExportFigFrame(Fl);
      break;
  }
}
