/********************\
*                    *
*  Group of objects  *
*                    *
\********************/

#ifndef GTKFIG_GROUP_H
#define GTKFIG_GROUP_H

#include "rectangleobject.h"

/*
 * Box style
 */
typedef enum { BS_VERTICAL, BS_HORIZONTAL, BS_FIXED } TBoxStyle;

/*
 * Base class for all group objects (sheet, text box, ...)
 */
class TCADGroup : public TCADRectangleObject {
protected:
  TCADObject *FirstChild,*LastChild;
  TBoxStyle BoxStyle;

  virtual void ComputeEncapRect();
  virtual void AffectEncapRect(TCADObject *Child);
public:
  TCADGroup(TCADSheet *Sheet);
  ~TCADGroup();
  virtual void Save(TCADSaveStream *Fl);
  virtual void SaveProperties(TCADSaveStream *Fl);
  virtual char LoadProperty(TCADLoadStream *Fl,char *ID);
  virtual void Export(FILE *Fl,TExportFormat Format);

  void Draw(GdkRegion *Region);

  virtual TCADObject *ButtonPressed(int x,int y);

  void AppendChild(TCADObject *Child);
  void PrependChild(TCADObject *Child);
  void DeleteChild(TCADObject *Child);  // This function doesn't deallocate the child!

  virtual TCADObject *ObjectByUniq(unsigned long Uniq);
  virtual gboolean IsGroup() { return TRUE; }

  // Group defines own attachment
  virtual gboolean CanAttach(int& x,int& y,TAttach *Attach);
};

#endif

