/****************\
*                *
*  Generic line  *
*                *
\****************/

#ifndef GTKFIG_LINE_H
#define GTKFIG_LINE_H

#include "sheet.h"
#include "lineproperties.h"
#include "drawarrow.h"

#define DIR_UP 1
#define DIR_DOWN 2
#define DIR_LEFT 4
#define DIR_RIGHT 8

class TCADLine : public TCADObject, TCADLinePropertiesI {
protected:
  const unsigned int MAXNUMHANDLES = 10;

  GdkPoint First,Last;
  TCADHandle Handle[MAXNUMHANDLES];

  void UpdateHandlePos();

  int DXO,DYO;  // Dragging offsets

  TArrowStyle FirstArrow,LastArrow;
  int FirstArrowSize,LastArrowSize;

  // Refresh rectangle
  GdkRectangle RefRect;

  TAttach TmpAttach;  // When we are dragging handle

  // Tests if point x,y is near abscissa First->Last
  gboolean PointNearLine(GdkPoint& First,GdkPoint& Last,int x,int y);

  // Exports line data
  virtual void ExportFigLine(FILE *Fl,int NumPoints);
  virtual void ArrowToFig(TArrowStyle Arrow,int& Type,int& Style);

public:
  TCADLine(TCADSheet *Sheet,int x=0,int y=0);
  ~TCADLine();

  // Attachments
  TAttach FAttach,LAttach;

  virtual void Save(TCADSaveStream *Fl);
  virtual void SaveProperties(TCADSaveStream *Fl);
  virtual char LoadProperty(TCADLoadStream *Fl,char *ID);
  virtual void PostLoad();

  virtual TCADObject *ButtonPressed(int x,int y);

  virtual void Select(GdkRectangle *RefreshRect);

  // Recomputes encap rectangle
  virtual void RecomputeEncapRect() = 0;

  // Recomputes refresh rectangle. It can assume that EncapRect is already
  // recomputed.
  virtual void RecomputeRefRect();

  // Handle was dragged
  virtual char HandleDragged(int x,int y,GdkRectangle *RefreshRect);

  // Handle was clicked
  virtual void HandleButtonPressed(int HandleNo,int x,int y);

  // Handle was dropped
  virtual char HandleButtonReleased(GdkRectangle *RefreshRect);

  // Shows arrow properties dialog
  virtual void ShowArrowProperties();

  // Redraws line and sets arrows
  virtual void RefreshArrows(TArrowStyle FA,TArrowStyle LA,int FS,int LS);

  // Is line
  virtual gboolean IsLine() { return TRUE; }

  // We must have our own resizing
  virtual void MoveResize(int dx,int dy,int dw,int dh,GdkRectangle *RefreshRect);

  // Should update parts of line after moving of its endpoints
  virtual void UpdateLine(gboolean SaveState) = 0;

  // Called to set attachment of dragged handle
  virtual void SetHandleAttachment(gboolean Attached,TAttach *Attach);
};

#endif

