/***********************************\
*                                   *
*  TCADMain implementation + main() *
*                                   *
\***********************************/

#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <gtk/gtkmain.h>
#include <gtk/gtkbutton.h>
#include <gtk/gtksignal.h>
#include <gtk/gtkpixmap.h>
#include <gtk/gtkhbox.h>

#include "main.h"
#include "gladesrc.h"

#include "pixmaps.h"

TCADMain *System;

int main(int argc,char **argv)
{
  int i;

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  // Create main class
  System = new TCADMain();

  // Load file(s)
  for(i=1;i<argc;i++) {
    System->LoadFile(argv[i]);
  }

  gtk_main ();
  return(0);
}

/******************************************************************************/

void on_fsb_clicked (GtkButton *button, gpointer user_data)
{
  button = button;
  if ((int)user_data == 0) System->FileSelectionOK();
  else System->FileSelectionCancel();
}


/******************************************************************************/

static void AssignPixmap(GdkWindow *window,GtkWidget *Widget,char **PixmapData)
{
  GtkWidget *PixmapWidget;
  GtkWidget *Child;
  GtkStyle *Style;
  GdkPixmap *Pixmap;
  GdkBitmap *Mask;

  Style = gtk_widget_get_style(Widget);
  Pixmap = gdk_pixmap_create_from_xpm_d(window, &Mask, &Style->bg[GTK_STATE_NORMAL],
   PixmapData);
  PixmapWidget = gtk_pixmap_new(Pixmap, Mask);
  gtk_misc_set_padding(GTK_MISC(PixmapWidget), 4, 4);
  Child = (GtkWidget *)gtk_container_children(GTK_CONTAINER(Widget))->data;
  gtk_container_remove(GTK_CONTAINER (Widget),Child);
//  gtk_widget_destroy(Child);
  gtk_container_add (GTK_CONTAINER (Widget), PixmapWidget);
  gtk_widget_show(PixmapWidget);
}

TCADMain::TCADMain()
{
  GtkWidget *Button;
  GtkWidget *hbox1;
  int i;
  char Buf[256];

  FirstSheet = NULL;
  LastSheet = NULL;
  ActiveSheet = NULL;
  State = ST_PICK;
  LastUniq = 0;

  // Create file selection widget
  FileSelection = GTK_FILE_SELECTION(gtk_file_selection_new(NULL));

  Button = FileSelection->ok_button;
  gtk_signal_connect (GTK_OBJECT (Button), "clicked",
                      GTK_SIGNAL_FUNC (on_fsb_clicked),
                      (gpointer)0);

  Button = FileSelection->cancel_button;
  gtk_signal_connect (GTK_OBJECT (Button), "clicked",
                      GTK_SIGNAL_FUNC (on_fsb_clicked),
                      (gpointer)-1);

  // Create window
  MainWindow = create_MainWindow();

  // Set title
  sprintf(Buf,"%s %s",PACKAGE,VERSION);
  gtk_window_set_title (GTK_WINDOW (MainWindow), Buf);

  // Get buttons
  i = 0;
  Buttons[i++] = BBPointer = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(MainWindow),"BBPointer");
  Buttons[i++] = BBLine = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(MainWindow),"BBLine");
  Buttons[i++] = BBAngleLine = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(MainWindow),"BBRightAngleLine");
  Buttons[i++] = BBFrame = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(MainWindow),"BBFrame");
  Buttons[i++] = BBText = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(MainWindow),"BBText");
  Buttons[i++] = BBFramedText = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(MainWindow),"BBFramedText");

  MIShowGrid = (GtkCheckMenuItem *)gtk_object_get_data(GTK_OBJECT(MainWindow),"MIShowGrid");
  MIUseGrid = (GtkCheckMenuItem *)gtk_object_get_data(GTK_OBJECT(MainWindow),"MIUseGrid"); 
  gtk_check_menu_item_set_show_toggle(MIShowGrid,TRUE);
  gtk_check_menu_item_set_show_toggle(MIUseGrid,TRUE);

  MILAL_None = (GtkCheckMenuItem *)gtk_object_get_data(GTK_OBJECT(MainWindow),"MILAL_None");
  MILAL_Grid = (GtkCheckMenuItem *)gtk_object_get_data(GTK_OBJECT(MainWindow),"MILAL_Grid");
  MILAL_HalfGrid = (GtkCheckMenuItem *)gtk_object_get_data(GTK_OBJECT(MainWindow),"MILAL_HalfGrid");
  
  hbox1 = (GtkWidget *)gtk_object_get_data(GTK_OBJECT(MainWindow),"hbox1");

  // Hide line end alignment
  gtk_widget_hide((GtkWidget *)gtk_object_get_data(GTK_OBJECT(MainWindow),"MILineEndAlignment"));

  // Show window
  gtk_widget_show(MainWindow);

  AssignPixmap(hbox1->window,BBPointer,    (char **)Pointer_xpm);
  AssignPixmap(hbox1->window,BBLine,       (char **)SimpleLine_xpm);
  AssignPixmap(hbox1->window,BBAngleLine,  (char **)AngleLine_xpm);
  AssignPixmap(hbox1->window,BBFrame,      (char **)Frame_xpm);
  AssignPixmap(hbox1->window,BBText,       (char **)Text_xpm);
  AssignPixmap(hbox1->window,BBFramedText, (char **)TextFrame_xpm);
}

TCADMain::~TCADMain()
{
  TCADObject *Obj,*Next;

  // Destroy sheets
  Obj = FirstSheet;
  while(Obj) {
    Next = Obj->Next;
    delete Obj;
    Obj = Next;
  }
}

extern GtkAccelGroup *accel_group;

void TCADMain::AddSheet(TCADSheet *Sheet)
{
  Sheet->AddAccelGroup(accel_group);

  Sheet->Prev = LastSheet;
  Sheet->Next = NULL;

  if (LastSheet == NULL) FirstSheet = Sheet;
  else LastSheet->Next = Sheet;
  LastSheet = Sheet;

  ActiveSheet = Sheet;
}

void TCADMain::LoadFile(char *Name)
{
  char Success;
  TCADLoadStream *Fl;
  char *ID;
  TCADSheet *Sheet;

  Fl = new TCADLoadStream(Name,&Success);
  if (!Success) {
    g_print("Cannot open file!");
    delete Fl;
    return;
  }

  for(;;) {
    ID = Fl->ReadID();
    if (*ID == 0) break;

    if (strcasecmp(ID,"TCADSheet") == 0) {
      Sheet = new TCADSheet(FALSE);
      Sheet->FileName = strdup(Name);
      AddSheet(Sheet);
      Sheet->Load(Fl);
      Sheet->SetTitle();
      Sheet->Show();
    }
    else ID = Fl->LoadString();  // Get data
  }

  delete Fl;
}

void TCADMain::UnionRectangles(GdkRectangle *Rect1,GdkRectangle *Rect2)
{
  Rect1->width  = MAX(Rect1->x + Rect1->width ,Rect2->x + Rect2->width );
  Rect1->height = MAX(Rect1->y + Rect1->height,Rect2->y + Rect2->height);
  Rect1->x = MIN(Rect1->x,Rect2->x);
  Rect1->y = MIN(Rect1->y,Rect2->y);
  Rect1->width  -= Rect1->x;
  Rect1->height -= Rect1->y;
}

void TCADMain::SheetClosed(TCADSheet *Sheet)
{
  // Hide file selection dialog
  gtk_grab_remove(GTK_WIDGET(FileSelection));
  gtk_widget_hide(GTK_WIDGET(FileSelection));

  // Remove sheet from the list
  if (Sheet->Next == NULL) LastSheet = (TCADSheet *)Sheet->Prev;
  else Sheet->Next->Prev = Sheet->Prev;
  if (Sheet->Prev == NULL) FirstSheet = (TCADSheet *)Sheet->Next;
  else Sheet->Prev->Next = Sheet->Next;

  if (ActiveSheet == Sheet) {
    // Find new active sheet
    ActiveSheet = (TCADSheet *)Sheet->Next;
    if ((ActiveSheet == NULL) && (Sheet != FirstSheet)) ActiveSheet = FirstSheet;
  }

  // Destroy sheet
  delete Sheet;
}

void TCADMain::SheetActivated(TCADSheet *Sheet)
{
  ActiveSheet = Sheet;
  if (Sheet == NULL) return;

  // Set grid menuitems
  gtk_check_menu_item_set_state(MIUseGrid,ActiveSheet->GetUseGrid());
  gtk_check_menu_item_set_state(MIShowGrid,ActiveSheet->GetShowGrid());
}

gboolean TCADMain::Save(TCADSheet *Sheet)
{
  TCADSaveStream *Fl;
  char Success;

  if (Sheet->FileName == NULL) return(SaveAs(Sheet));

  Fl = new TCADSaveStream(Sheet->FileName,&Success);

  if (!Success) {
    fprintf(stderr,"Cannot save file: %s!\n",strerror(errno));
  }
  else {
    Sheet->Save(Fl);
  }

  delete Fl;

  return(TRUE);
}

gboolean TCADMain::SaveAs(TCADSheet *Sheet)
{
  SaveSheet = Sheet;
  FileOper = FO_SAVE;

  // Hide file selection dialog
  gtk_grab_remove(GTK_WIDGET(FileSelection));
  gtk_widget_hide(GTK_WIDGET(FileSelection));

  // Set title
  gtk_window_set_title(&FileSelection->window,"Save sheet");

  // Show it
  gtk_widget_show(GTK_WIDGET(FileSelection));
  gtk_grab_add(GTK_WIDGET(FileSelection));

  return(FALSE);  // For now
}

void TCADMain::FileSelectionOK()
{
  // Hide file selection dialog
  gtk_grab_remove(GTK_WIDGET(FileSelection));
  gtk_widget_hide(GTK_WIDGET(FileSelection));

  switch(FileOper) {
    case FO_SAVE:
      // Change sheet filename
      if (SaveSheet->FileName != NULL) free(SaveSheet->FileName);
      SaveSheet->FileName = strdup(gtk_file_selection_get_filename(FileSelection));
      Save(SaveSheet);
      SaveSheet->SetTitle();
      break;
    case FO_LOAD:
      LoadFile(gtk_file_selection_get_filename(FileSelection));
      break;
    case FO_EXPORT_LATEX:
      SaveSheet->Export(gtk_file_selection_get_filename(FileSelection),EF_LATEX);
      break;
    case FO_EXPORT_FIG:
      SaveSheet->Export(gtk_file_selection_get_filename(FileSelection),EF_FIG);
      break;
  }
}

void TCADMain::FileSelectionCancel()
{
  // Hide file selection dialog
  gtk_grab_remove(GTK_WIDGET(FileSelection));
  gtk_widget_hide(GTK_WIDGET(FileSelection));
}

TLineEndDragType
TCADMain::GetLineEndDragType()
{
  if (MILAL_None->active) return LED_NONE;
  else if (MILAL_Grid->active) return LED_GRID;
  else return LED_HALFGRID;
}

int
TCADMain::NextUniq()
{
  return(++LastUniq);
}
