/**************\
*              *
*  Main class  *
*              *
\**************/

#ifndef GTKFIG_MAIN_H
#define GTKFIG_MAIN_H

#include <gtk/gtkfilesel.h>
#include <gtk/gtkcheckmenuitem.h>
#include "sheet.h"

/*
 * Toolbox state
 */

typedef enum { ST_PICK, ST_LINE, ST_ANGLELINE, ST_FRAME, ST_TEXT, ST_FRAMED_TEXT } TState;

/*
 * Line end dragging type
 */

typedef enum { LED_NONE, LED_GRID, LED_HALFGRID } TLineEndDragType;

/*
 * Main class
 */
class TCADMain {
protected:
  typedef enum { FO_SAVE, FO_LOAD, FO_EXPORT_LATEX, FO_EXPORT_FIG } TFileOper;

  TCADSheet *FirstSheet,*LastSheet,*ActiveSheet;

  int LastUniq;

  GtkWidget *MainWindow;
  GtkFileSelection *FileSelection;

  TFileOper FileOper;    // Current operation
  TCADSheet *SaveSheet;  // Which sheet are we saving

  // Buttons
  static const int NUMBUTTONS=6;
  GtkWidget *Buttons[NUMBUTTONS];
  GtkWidget *BBPointer;
  GtkWidget *BBLine;
  GtkWidget *BBAngleLine;
  GtkWidget *BBFrame;
  GtkWidget *BBText;
  GtkWidget *BBFramedText;
  GtkCheckMenuItem *MIUseGrid,*MIShowGrid;
  GtkCheckMenuItem *MILAL_None,*MILAL_Grid,*MILAL_HalfGrid;

  // State
  TState State;

  // Current state is locked
  gboolean StateLocked;

  void AddSheet(TCADSheet *Sheet);

  // Will return sheet which actually has focus or active sheet
  // if no sheet has focus. Used by menus to determine which sheet
  // to save, close, etc.
  TCADSheet *GetActiveSheet();

  // Does save as
  gboolean SaveAs(TCADSheet *Sheet);

  // Does save
  gboolean Save(TCADSheet *Sheet);

  // Sets all buttons up except the one selected
  void ButtonsUp(GtkWidget *Except);

public:
  TCADMain();
  ~TCADMain();

  // Loads file to new sheet
  void LoadFile(char *Name);

  // Tells main class that sheet was activated
  void SheetActivated(TCADSheet *Sheet);

  // Tells main class that sheet was closed
  void SheetClosed(TCADSheet *Sheet);

  // Utility function. Enlarges Rect1 so that is to also contains Rect2.
  void UnionRectangles(GdkRectangle *Rect1,GdkRectangle *Rect2);

  TState GetState() { return State; }

  void ResetMode(gboolean Force);

  // Gets current line drag type
  TLineEndDragType GetLineEndDragType();

  // For numbering of sheets
  int NextUniq();

  /* Used by callback */
  void FileSelectionOK();
  void FileSelectionCancel();

  /* Functions to be called as a result of menu picks */
  void Menu_New();
  void Menu_Open();
  gboolean Menu_Save();
  gboolean Menu_SaveAs();
  gboolean Menu_SaveAll();
  void Menu_Exit();
  void Menu_NextWindow();
  void Menu_PrevWindow();
  void Menu_CloseWindow();
  void Menu_About();
  void Menu_Delete();
  void Menu_EditText();
  void Menu_Export_Latex();
  void Menu_Export_FIG();
  void Menu_ArrowProperties();
  void Menu_TextProperties();
  void Menu_ShowGridToggled();
  void Menu_UseGridToggled();
  void Menu_ShowGridOptions();
  void Menu_SelectAll();
  void Menu_Align();
  void Menu_RulerOptions();
//  void Menu_();

  /* Functions to be called as a result of button downs */
  void BBPointerPressed();
  void BBLinePressed(gboolean Locked);
  void BBAngleLinePressed(gboolean Locked);
  void BBFramePressed(gboolean Locked);
  void BBTextPressed(gboolean Locked);
  void BBFramedTextPressed(gboolean Locked);
//  void BBPressed();
};

extern TCADMain *System;

#endif

