/*****************************\
*                             *
*  Implements menu callbacks  *
*                             *
\*****************************/

#include <gtk/gtkmain.h>
#include "main.h"
#include "messagebox.h"
#include "aligndialog.h"
#include "rulerdialog.h"

TCADSheet *TCADMain::GetActiveSheet()
{
  TCADSheet *Sheet;

  // Find if any sheet has focus
  Sheet = FirstSheet;
  while(Sheet) {
    if (Sheet->HasFocus()) break;
    Sheet = (TCADSheet *)Sheet->Next;
  }

  if (Sheet == NULL) Sheet = ActiveSheet; // Use last active sheet

  return(Sheet);
}

void TCADMain::Menu_New()
{
  TCADSheet *NewSheet;

  // Add new sheet
  NewSheet = new TCADSheet(TRUE);
  AddSheet(NewSheet);
}

void TCADMain::Menu_Open()
{
  FileOper = FO_LOAD;

  // Hide file selection dialog
  gtk_widget_hide(GTK_WIDGET(FileSelection));

  // Set title
  gtk_window_set_title(&FileSelection->window,"Load sheet");

  // Show it
  gtk_widget_show(GTK_WIDGET(FileSelection));
}

gboolean TCADMain::Menu_Save()
{
  TCADSheet *Sheet;

  Sheet = GetActiveSheet();
  if (Sheet == NULL) return(FALSE);

  return Save(Sheet);
}

gboolean TCADMain::Menu_SaveAs()
{
  TCADSheet *Sheet;

  Sheet = GetActiveSheet();
  if (Sheet == NULL) return(FALSE);

  return(SaveAs(Sheet));
}

gboolean TCADMain::Menu_SaveAll()
{
  return(FALSE);
}

void TCADMain::Menu_Exit()
{
  TCADSheet *Next;

  // Close all sheets
  while(FirstSheet) {
    if (!FirstSheet->Close()) return;  // Canceled
    
    // Remove sheet  
    Next = (TCADSheet *)FirstSheet->Next;
    delete FirstSheet;
    FirstSheet = Next;
    if (FirstSheet != NULL) FirstSheet->Prev = NULL;
  }

  // Exit
  gtk_main_quit();
}

void TCADMain::Menu_NextWindow()
{
  if (ActiveSheet != NULL) {
    ActiveSheet = (TCADSheet *)ActiveSheet->Next;
    if (ActiveSheet == NULL) ActiveSheet = FirstSheet;
    ActiveSheet->BringToFront();
  }
}

void TCADMain::Menu_PrevWindow()
{
  if (ActiveSheet != NULL) {
    ActiveSheet = (TCADSheet *)ActiveSheet->Prev;
    if (ActiveSheet == NULL) ActiveSheet = LastSheet;
    ActiveSheet->BringToFront();
  }
}

void TCADMain::Menu_CloseWindow()
{
  TCADSheet *Sheet;

  Sheet = GetActiveSheet();

  if (Sheet == NULL) return;

  // Really close
  SheetClosed(Sheet);
}

void TCADMain::Menu_About()
{
  char Msg[1024];

  sprintf(Msg,"%s %s\n\nCopyright 1998\nMichal Kra\nlemming@k332.feld.cvut.cz\n\nDistributed under GPL",PACKAGE,VERSION);
  MessageBox(Msg,"About");
}

void TCADMain::Menu_Delete()
{
  TCADSheet *Sheet;

  Sheet = GetActiveSheet();

  if (Sheet == NULL) return;

  Sheet->DeleteSelected();
}

void TCADMain::Menu_EditText()
{
  TCADSheet *Sheet;

  Sheet = GetActiveSheet();

  if (Sheet == NULL) return;

  Sheet->EditText();
}

void TCADMain::Menu_Export_Latex()
{
  FileOper = FO_EXPORT_LATEX;

  SaveSheet = GetActiveSheet();
  if (SaveSheet == NULL) return;

  // Hide file selection dialog
  gtk_widget_hide(GTK_WIDGET(FileSelection));

  // Set title
  gtk_window_set_title(&FileSelection->window,"Export as LaTeX picture");

  // Show it
  gtk_widget_show(GTK_WIDGET(FileSelection));

  gtk_main();
}

void TCADMain::Menu_Export_FIG()
{
  FileOper = FO_EXPORT_FIG;

  SaveSheet = GetActiveSheet();
  if (SaveSheet == NULL) return;

  // Hide file selection dialog
  gtk_widget_hide(GTK_WIDGET(FileSelection));

  // Set title
  gtk_window_set_title(&FileSelection->window,"Export as XFIG picture");

  // Show it
  gtk_widget_show(GTK_WIDGET(FileSelection));

  gtk_main();
}

void TCADMain::Menu_ArrowProperties()
{
  TCADSheet *Sheet;

  Sheet = GetActiveSheet();
  if (Sheet == NULL) return;
  Sheet->ShowArrowProperties();
}

void TCADMain::Menu_TextProperties()
{
  TCADSheet *Sheet;

  Sheet = GetActiveSheet();
  if (Sheet == NULL) return;
  Sheet->ShowTextProperties();
}

void
TCADMain::Menu_UseGridToggled()
{
  if (ActiveSheet != NULL) ActiveSheet->SetUseGrid(MIUseGrid->active);
}

void
TCADMain::Menu_ShowGridToggled()
{
  if (ActiveSheet != NULL) ActiveSheet->SetShowGrid(MIShowGrid->active);
}

void
TCADMain::Menu_ShowGridOptions()
{
  TCADSheet *Sheet;

  Sheet = GetActiveSheet();
  if (Sheet == NULL) return;
  Sheet->ShowGridProperties();
}

void
TCADMain::Menu_SelectAll()
{
  TCADSheet *Sheet;

  Sheet = GetActiveSheet();
  if (Sheet == NULL) return;
  Sheet->SelectAll();
}

void
TCADMain::Menu_Align()
{
  TCADSheet *Sheet;

  Sheet = GetActiveSheet();
  if (Sheet == NULL) return;
  ShowAlignDialog(Sheet);
}

void
TCADMain::Menu_RulerOptions()
{
  TCADSheet *Sheet;

  Sheet = GetActiveSheet();
  if (Sheet == NULL) return;
  ShowRulerDialog(Sheet);
}
