/*********************\
*                     *
*  Shows message box  *
*                     *
\*********************/

#include <gtk/gtk.h>

static void on_button3_clicked (GtkButton *button, gpointer user_data)
{
  button = button;

  // Make window non-modal
  gtk_grab_remove(GTK_WIDGET(user_data));

  // Close window
  gtk_widget_destroy(GTK_WIDGET(user_data));
}


void MessageBox(char *Message,char *Title)
{
  GtkWidget *window1;
  GtkWidget *vbox1;
  GtkWidget *label1;
  GtkWidget *button3;

  if (Title == NULL) Title = "Information";
  if (Message == NULL) Message = 0;

  window1 = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_object_set_data (GTK_OBJECT (window1), "window1", window1);
  gtk_window_position (GTK_WINDOW (window1), GTK_WIN_POS_MOUSE);
  gtk_window_set_title (GTK_WINDOW (window1), Title);
  gtk_window_set_policy (GTK_WINDOW (window1), TRUE, TRUE, TRUE);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window1), "vbox1", vbox1);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (window1), vbox1);

  label1 = gtk_label_new (Message);
  gtk_object_set_data (GTK_OBJECT (window1), "label1", label1);
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (vbox1), label1, TRUE, FALSE, 0);
  gtk_misc_set_padding (GTK_MISC (label1), 20, 10);

  button3 = gtk_button_new_with_label ("OK");
  gtk_object_set_data (GTK_OBJECT (window1), "button3", button3);
  gtk_widget_show (button3);
  gtk_box_pack_end (GTK_BOX (vbox1), button3, FALSE, FALSE, 0);
  gtk_container_border_width (GTK_CONTAINER (button3), 10);

  gtk_signal_connect (GTK_OBJECT (button3), "clicked",
                      GTK_SIGNAL_FUNC (on_button3_clicked),
                      window1);

  gtk_widget_show(window1);
  gtk_grab_add(window1);
}
