/*************************\
*                         *
*  Implements TCADObject  *
*                         *
\*************************/

#include <string.h>
#include "sheet.h"
#include "main.h"
#include "line.h"

TCADObject::TCADObject(TCADSheet *Sheet)
{
  this->Sheet = Sheet;
  Selected = 0;

  EncapRect.x = 0;
  EncapRect.y = 0;
  EncapRect.width = 0;
  EncapRect.height = 0;
  Weight = 1;

  Attached = NULL;
}

TCADObject::~TCADObject()
{
  // Unattach all lines
  while(Attached) UnattachLine((TCADLine *)Attached->data);

  g_list_free(Attached);
}

void
TCADObject::Save(TCADSaveStream *Fl)
{
  Fl->SaveObjectName("TCADObject");
  SaveProperties(Fl);
  Fl->SaveEndObject();
}

void
TCADObject::SaveProperties(TCADSaveStream *Fl)
{
  Fl->SaveInt("X",EncapRect.x);
  Fl->SaveInt("Y",EncapRect.y);
  Fl->SaveInt("W",EncapRect.width);
  Fl->SaveInt("H",EncapRect.height);
  Fl->SaveInt("Weight",Weight);
  Fl->SaveInt("Uniq",Uniq);
}

void
TCADObject::PostLoad()
{
}

void
TCADObject::Load(TCADLoadStream *Fl)
{
  char *ID;

  for(;;) {
    ID = Fl->ReadID();
    if (*ID == 0) break;

    if (!LoadProperty(Fl,ID)) Fl->Skip(); // Read rest
  }

  PostLoad();
}

char
TCADObject::LoadProperty(TCADLoadStream *Fl,char *ID)
{
  if (strcasecmp(ID,"X") == 0) EncapRect.x = Fl->LoadInt();
  else if (strcasecmp(ID,"Y") == 0) EncapRect.y = Fl->LoadInt();
  else if (strcasecmp(ID,"W") == 0) EncapRect.width = Fl->LoadInt();
  else if (strcasecmp(ID,"H") == 0) EncapRect.height = Fl->LoadInt();
  else if (strcasecmp(ID,"Weight") == 0) Weight = Fl->LoadInt();
  else if (strcasecmp(ID,"Uniq") == 0) Uniq = Fl->LoadInt();
  else return(0);

  return(1);
}

void
TCADObject::Select(GdkRectangle *RefreshRect)
{
//  printf("Select(%lu)\n",Uniq);

  // Some common things. Might come handy to children.
  Selected = 1;
  RefreshRect->x = EncapRect.x-HANDLE_SIZE/2;
  RefreshRect->y = EncapRect.y-HANDLE_SIZE/2;
  RefreshRect->width = EncapRect.width+HANDLE_SIZE+1;
  RefreshRect->height = EncapRect.height+HANDLE_SIZE+1;
}

void
TCADObject::OtherSelected(GdkRectangle *RefreshRect)
{
//  printf("OtherSelected(%lu)\n",Uniq);

  // Some common things. Might come handy to children.
  RefreshRect->x = EncapRect.x-HANDLE_SIZE/2;
  RefreshRect->y = EncapRect.y-HANDLE_SIZE/2;
  RefreshRect->width = EncapRect.width+HANDLE_SIZE+1;
  RefreshRect->height = EncapRect.height+HANDLE_SIZE+1;
}

void
TCADObject::Unselect(GdkRectangle *RefreshRect)
{
//  printf("Unselect(%lu)\n",Uniq);

  // Some common things. Might come handy to children.
  Selected = 0;
  RefreshRect->x = EncapRect.x-HANDLE_SIZE/2;
  RefreshRect->y = EncapRect.y-HANDLE_SIZE/2;
  RefreshRect->width = EncapRect.width+HANDLE_SIZE+1;
  RefreshRect->height = EncapRect.height+HANDLE_SIZE+1;
}

void
TCADObject::UnattachLine(TCADLine *Line)
{
//  printf("Unattaching.\n");
  if ((Line->FAttach.Object == this) || (Line->LAttach.Object == this)) {
    Attached = g_list_remove(Attached,Line);
    if (Line->FAttach.Object == this) Line->FAttach.Object = NULL;
    if (Line->LAttach.Object == this) Line->LAttach.Object = NULL;
  }
}

void
TCADObject::AttachLine(TCADLine *Line)
{
//  printf("Attaching.\n");
  if (g_list_find(Attached,Line)) return;  // Already attached
  Attached = g_list_append(Attached,Line);
}

