/**************\
*              *
*  TCADObject  *
*              *
\**************/

#ifndef GTKFIG_OBJECT_H
#define GTKFIG_OBJECT_H

#include "handle.h"
#include "streams.h"
/*
 *  Attach line if nearer than SQRT(ATTACH_RANGE) pixels from attachment point
 */
#define ATTACH_RANGE HANDLE_SIZE*HANDLE_SIZE

class TCADObject;

#define DIR_UP 1
#define DIR_DOWN 2
#define DIR_LEFT 4
#define DIR_RIGHT 8

/*
 * Information on how is line attached
 */
typedef struct {
  TCADObject *Object;
  unsigned char Direction;	// Direction(s) in which we can attach
  gboolean DirectionForced;	// Direction is forced
  unsigned char Flags;		// Some flags
  unsigned long OUniq;		// Uniq of object - used only for loading!!!
  int XOff,YOff;
} TAttach;

/*
 * Export formats
 */
typedef enum { EF_LATEX, EF_FIG } TExportFormat;

class TCADSheet;
class TCADLine;

/*
 * Base class for all objects
 */
class TCADObject {
protected:
  TCADSheet *Sheet;
  int DraggingHandle;
  int HDownX,HDownY,DHandle;
public:
  TCADObject(TCADSheet *Sheet);
  virtual ~TCADObject();

  // Pointers to next/previous/parent object
  TCADObject *Next,*Prev,*Parent;

  // Pointers to next/previous object in list of selected objects
  TCADObject *NextSelected,*PrevSelected;

  // Rectangle which encapsulates whole object. Used to determine which object
  // was clicked, whether to draw object (when redrawing) etc.
  GdkRectangle EncapRect;

  // For grouping
  int Weight;

  // Uniq
  unsigned long Uniq;

  // Is object selected?
  char Selected;

  // Pointer to array of handles and number of them. The array itself is
  // declared in child classes;
  TCADHandle *Handles;
  int NumHandles;

  // Attached lines
  GList *Attached;

  // Returns whether line can be attached
  virtual gboolean CanAttach(int& x,int& y,TAttach *Attach) = 0;
  virtual void UnattachLine(TCADLine *Line);
  virtual void AttachLine(TCADLine *Line);

  virtual void Save(TCADSaveStream *Fl);
  virtual void SaveProperties(TCADSaveStream *Fl);
  virtual void Load(TCADLoadStream *Fl);
  virtual void PostLoad();  // Called after loading
  virtual void Export(FILE *Fl,TExportFormat Format) = 0;

  // Returns 1 when ID was recognized, 0 when not
  virtual char LoadProperty(TCADLoadStream *Fl,char *ID);

  // Draws object, if it lies in Region. When Region == NULL, will always draw.
  // NOTE: This metod DOES NOT draw handles - they are drawn separately.
  virtual void Draw(GdkRegion *Region) = 0;

  // If x,y is in the object, it should return itself, otherwise it returns
  // NULL. This is (of course) not true for groups (except use group).
  virtual TCADObject *ButtonPressed(int x,int y) = 0;

  // Tells object to select. If object is already selected it means it became
  // again first selected object. Fills rectangle which should be refreshed.
  virtual void Select(GdkRectangle *RefreshRect) = 0;

  // Tells object that other object was selected, but this also remains selected.
  // Fills in which rectangle should be redrawn.
  virtual void OtherSelected(GdkRectangle *RefreshRect);

  // Tells object to unselect. Object fills in rectangle which should be refreshed.
  virtual void Unselect(GdkRectangle *RefreshRect);

  // Moves/resizes object
  virtual void MoveResize(int dx,int dy,int dw,int dh,GdkRectangle *RefreshRect) = 0;

  // Handle was dragged
  virtual char HandleDragged(int x,int y,GdkRectangle *RefreshRect) = 0;

  // Handle was dragged
  virtual void HandleButtonPressed(int HandleNo,int x,int y) = 0;

  // Handle was dropped
  virtual char HandleButtonReleased(GdkRectangle *RefreshRect) = 0;

  // Returns whether object has editable text
  virtual gboolean HasText() { return FALSE; }

  // Returns whether object is line
  virtual gboolean IsLine() { return FALSE; }

  // Returns whether object is group
  virtual gboolean IsGroup() { return FALSE; }
};

#endif

