/************************************\
*                                    *
*  Base class for rectangle objects  *
*                                    *
\************************************/

#include "rectangleobject.h"
#include "sheet.h"
#include "main.h"
#include "line.h"

// Flags for TAttach flags fiels
#define AFLAG_RIGHT 1
#define AFLAG_BOTTOM 2

TCADRectangleObject::TCADRectangleObject(TCADSheet *Sheet) : TCADObject(Sheet)
{
  Handles = Handle;
  NumHandles = 8;
}

TCADObject *
TCADRectangleObject::ButtonPressed(int x,int y)
{
  if ((x >= EncapRect.x) && (x <= (EncapRect.x+EncapRect.width )) &&
      (y >= EncapRect.y) && (y <= (EncapRect.y+EncapRect.height))) return(this);
  else return(NULL);
}

void
TCADRectangleObject::Select(GdkRectangle *RefreshRect)
{
//  printf("Select(%lu)\n",Uniq);

  Selected = 1;
  RefreshRect->x = EncapRect.x-HANDLE_SIZE/2;
  RefreshRect->y = EncapRect.y-HANDLE_SIZE/2;
  RefreshRect->width = EncapRect.width+HANDLE_SIZE+1;
  RefreshRect->height = EncapRect.height+HANDLE_SIZE+1;
}

void
TCADRectangleObject::MoveResize(int dx,int dy,int dw,int dh,GdkRectangle *RefreshRect)
{
  int OldX,OldY;
  int X,Y,W,H;
  int X2,Y2;
  GList *AList;
  TCADLine *Line;
  GdkRectangle Rect;

#define MAY_MOVE(Attach,Num) \
if (Attach.Object == this) { \
  int hx,hy; \
  hx = OldX + Attach.XOff; \
  hy = OldY + Attach.YOff; \
  Line->HandleButtonPressed(Num,hx,hy); \
  if ((Attach.XOff >= EncapRect.width) || (Attach.Flags & AFLAG_RIGHT)) \
   Attach.XOff = EncapRect.width-1; \
  if ((Attach.YOff >= EncapRect.height) || (Attach.Flags & AFLAG_BOTTOM)) \
   Attach.YOff = EncapRect.height-1; \
  hx = EncapRect.x + Attach.XOff; \
  hy = EncapRect.y + Attach.YOff; \
  Line->HandleDragged(hx,hy,&Rect); \
  System->UnionRectangles(RefreshRect,&Rect); \
  Line->HandleButtonReleased(&Rect); \
  System->UnionRectangles(RefreshRect,&Rect); \
}
  *RefreshRect = EncapRect;

  OldX = EncapRect.x;
  OldY = EncapRect.y;
  X = EncapRect.x + dx;
  Y = EncapRect.y + dy;
  W = EncapRect.width + dw;
  H = EncapRect.height + dh;
  X2 = Sheet->EncapRect.width;
  Y2 = Sheet->EncapRect.height;

  if (W < 0) W = 0;
  if (H < 0) H = 0;

  /* Make object to not exceed boundaries */

  // Right/bottom boundary
  if ((X+W) >= X2) {  // X axis
    if (dx == 0) W -= ((X+W)-X2+1);	// Resize if we resized
    else X -= ((X+W)-X2+1);		// Move if moved
  }
  if ((Y+H) >= Y2) {  // Y axis
    if (dy == 0) H -= ((Y+H)-Y2+1);	// Resize if we resized
    else Y -= ((Y+H)-Y2+1);		// Move if moved
  }

  // Top/left boundary
  if (X < 0) X = 0;
  if (Y < 0) Y = 0;

  // Check again right/bottom, but now always resize
  if ((X+W) >= X2) W -= ((X+W)-X2+1);	// X axis
  if ((Y+H) >= Y2) H -= ((Y+H)-Y2+1);	// Y axis

  EncapRect.x = X;
  EncapRect.y = Y;
  EncapRect.width = W;
  EncapRect.height = H;

  UpdateHandlePos();

  // Update attached lines
  AList = Attached;
  while(AList) {
    Line = (TCADLine *)AList->data;
    MAY_MOVE(Line->FAttach,0);
//    printf("FAttach.Flags = %d\n",Line->FAttach.Flags);
    MAY_MOVE(Line->LAttach,1);
//    printf("LAttach.Flags = %d\n",Line->LAttach.Flags);
    AList = (GList *)g_list_next(AList);
  }

  System->UnionRectangles(RefreshRect,&EncapRect);
  RefreshRect->x -= HANDLE_SIZE/2;
  RefreshRect->y -= HANDLE_SIZE/2;
  RefreshRect->width += HANDLE_SIZE;
  RefreshRect->height += HANDLE_SIZE;
}

void
TCADRectangleObject::UpdateHandlePos()
{
  int x1,y1,x2,y2,d=HANDLE_SIZE/2;

  x1 = EncapRect.x;
  y1 = EncapRect.y;
  x2 = EncapRect.x+EncapRect.width-1;
  y2 = EncapRect.y+EncapRect.height-1;

  Handles[0].x = x1-d;
  Handles[0].y = y1-d;

  Handles[1].x = (x1+x2)/2 - d;
  Handles[1].y = y1-d;

  Handles[2].x = x2-d;
  Handles[2].y = y1-d;

  Handles[3].x = x2-d;
  Handles[3].y = (y1+y2)/2 - d;

  Handles[4].x = x2-d;
  Handles[4].y = y2-d;

  Handles[5].x = (x1+x2)/2 - d;
  Handles[5].y = y2-d;

  Handles[6].x = x1-d;
  Handles[6].y = y2-d;

  Handles[7].x = x1-d;
  Handles[7].y = (y1+y2)/2 - d;
}

char
TCADRectangleObject::HandleDragged(int x,int y,GdkRectangle *RefreshRect)
{
  int X1,Y1,X2,Y2;

  RefreshRect->x = 0;
  X1 = EncapRect.x;
  Y1 = EncapRect.y;
  X2 = EncapRect.x+EncapRect.width;
  Y2 = EncapRect.y+EncapRect.height;

  switch(DraggingHandle) {
    case 0:  // LU
      X1 = x;
      if (X1 >= X2) X1 = X2-1;
      Y1 = y;
      if (Y1 >= Y2) Y1 = Y2-1;
      break;
    case 1:  // U
      Y1 = y;
      if (Y1 >= Y2) Y1 = Y2-1;
      break;
    case 2:  // RU
      X2 = x;
      if (X1 >= X2) X2 = X1+1;
      Y1 = y;
      if (Y1 >= Y2) Y1 = Y2-1;
      break;
    case 3:  // R
      X2 = x;
      if (X1 >= X2) X2 = X1+1;
      break;
    case 4:  // RD
      X2 = x;
      if (X1 >= X2) X2 = X1+1;
      Y2 = y;
      if (Y1 >= Y2) Y2 = Y1+1;
      break;
    case 5:  // D
      Y2 = y;
      if (Y1 >= Y2) Y2 = Y1+1;
      break;
    case 6:  // LD
      X1 = x;
      if (X1 >= X2) X1 = X2-1;
      Y2 = y;
      if (Y1 >= Y2) Y2 = Y1+1;
      break;
    case 7:  // L
      X1 = x;
      if (X1 >= X2) X1 = X2-1;
      break;
  }
  if (X1 < 0) X1 = 0;
  if (Y1 < 0) Y1 = 0;
  if (X2 >= Sheet->EncapRect.width)  X2 = Sheet->EncapRect.width-1;
  if (Y2 >= Sheet->EncapRect.height) Y2 = Sheet->EncapRect.height-1;

  // Clear clipping
  gdk_gc_set_clip_rectangle(Sheet->GC,NULL);

  if (DHandle) Sheet->DrawFocusRect(); // Clear old rect
  DHandle = 1;
  Sheet->FocusRect.x = X1;
  Sheet->FocusRect.y = Y1;
  Sheet->FocusRect.width = X2-X1;
  Sheet->FocusRect.height = Y2-Y1;
  Sheet->DrawFocusRect();

  return(0);
}

void
TCADRectangleObject::HandleButtonPressed(int HandleNo,int x,int y)
{
  HDownX = x;
  HDownY = y;
  DraggingHandle = HandleNo;
}

char
TCADRectangleObject::HandleButtonReleased(GdkRectangle *RefreshRect)
{
  int dx,dy,dw,dh;

  if (!DHandle) return(0);
  DHandle = 0;

  *RefreshRect = EncapRect;

  // Clear clipping
  gdk_gc_set_clip_rectangle(Sheet->GC,NULL);

  // Clear focus rectangle
  Sheet->DrawFocusRect();

  // Move itself
  dx = Sheet->FocusRect.x - EncapRect.x;
  dy = Sheet->FocusRect.y - EncapRect.y;
  dw = Sheet->FocusRect.width - EncapRect.width + 1; // Correction - we want object boundary to contain grid
  dh = Sheet->FocusRect.height - EncapRect.height + 1; // Correction - we want object boundary to contain grid

  MoveResize(dx,dy,dw,dh,RefreshRect);

  return(1);
}

gboolean
TCADRectangleObject::CanAttach(int& x,int& y,TAttach *Attach)
{
#define NEAR(x1,y1,x2,y2) (((x1-x2)*(x1-x2)+(y1-y2)*(y1-y2)) < ATTACH_RANGE)
#define DO_ATTACH(X,Y) \
{ \
  x = X; \
  y = Y; \
  Attach->XOff = X-EncapRect.x; \
  Attach->YOff = Y-EncapRect.y; \
  Attach->Object = this; \
  Attach->Flags = 0; \
  Attach->Direction = 0; \
  Attach->DirectionForced = TRUE; \
  if (X == X2) { \
    Attach->Flags |= AFLAG_RIGHT; \
    Attach->Direction |= DIR_RIGHT; \
  } \
  else if (X == X1) Attach->Direction |= DIR_LEFT; \
  if (Y == Y2) { \
    Attach->Flags |= AFLAG_BOTTOM; \
    Attach->Direction |= DIR_DOWN; \
  } \
  else if (Y == Y1) Attach->Direction |= DIR_UP; \
/*  printf("Attach: TRUE\n");*/ \
  return(TRUE); \
}

  int X1,Y1,X2,Y2;
  int X,Y;
  gboolean X_eq_Y;
  int GridX,GridY;

  Sheet->GetGridOptions(X_eq_Y,GridX,GridY);

  // Generate attachment range
  X1 = (EncapRect.x + GridX-1)/GridX*GridX;
  Y1 = (EncapRect.y + GridY-1)/GridY*GridY;
  X2 = EncapRect.x + EncapRect.width;
  X2 -= X2 % GridX;
  Y2 = EncapRect.y + EncapRect.height;
  Y2 -= Y2 % GridY;

  for(Y=Y1;Y<=Y2;Y+=(Y2-Y1))
   for(X=X1;X<=X2;X+=GridX) {

//     printf("x=%d, y=%d, X=%d, Y=%d\n",x,y,X,Y);

    if (NEAR(x,y,X,Y))
     DO_ATTACH(X,Y);

   }

  for(X=X1;X<=X2;X+=(X2-X1))
   for(Y=Y1+GridY;Y<Y2;Y+=GridY)
    if (NEAR(x,y,X,Y))
     DO_ATTACH(X,Y);

  return(FALSE);
}


void
TCADRectangleObject::ExportFigFrame(FILE *Fl)
{
  int X1,Y1,X2,Y2;

  X1 = EncapRect.x;
  Y1 = EncapRect.y;
  X2 = X1 + EncapRect.width;
  Y2 = Y1 + EncapRect.height;

  fprintf(Fl,"2 2 %d %d %d %d 0 0 %d %f %d %d %d 0 0 %d\n",
    0,  // Line style
    1,  // Thickness
    0,  // Pen color
    7,  // Fill color
    -1, // Area fill
    (float)0,  // Style val
    0,  // Join style
    0,  // Cap style
    -1, // Radius
    5   // # of points
  );
  fprintf(Fl,"\t%d %d  %d %d  %d %d  %d %d  %d %d\n",X1,Y1,X2,Y1,X2,Y2,X1,Y2,X1,Y1);
}

