/************************************\
*                                    *
*  Base class for rectangle objects  *
*                                    *
\************************************/

#ifndef GTKFIG_RECTANGLEOBJECT_H
#define GTKFIG_RECTANGLEOBJECT_H

/*
 * NOTE: This class is used as base for groups and shapes.
 */

#include "object.h"

class TCADSheet ;

class TCADRectangleObject : public TCADObject {
protected:
  TCADHandle Handle[8];

  // Updates handle positions when object forms a box with size of EncapRect.
  virtual void UpdateHandlePos();

  // Exports frame to fig
  virtual void ExportFigFrame(FILE *Fl);
public:
  TCADRectangleObject(TCADSheet *Sheet);

  virtual TCADObject *ButtonPressed(int x,int y);
  virtual void Select(GdkRectangle *RefreshRect);
  virtual void MoveResize(int dx,int dy,int dw,int dh,GdkRectangle *RefreshRect);
  virtual char HandleDragged(int x,int y,GdkRectangle *RefreshRect);
  virtual void HandleButtonPressed(int HandleNo,int x,int y);
  virtual char HandleButtonReleased(GdkRectangle *RefreshRect);

  // Does attachment for rectangular objects
  virtual gboolean CanAttach(int& x,int& y,TAttach *Attach);
};

#endif


