/**************************************************\
*                                                  *
*  Implements line which connects in right angles  *
*                                                  *
\**************************************************/

#ifndef GTKFIG_RIGHTANGLELINE_H
#define GTKFIG_RIGHTANGLELINE_H

#include "line.h"

class TCADRightAngleLine : public TCADLine {
protected:
  const int MAXNUMPOINTS = MAXNUMHANDLES+3;
  GdkPoint Points[MAXNUMPOINTS];
  int NumPoints;
  int XLPN,YLPN;  // LoadPointNumber - for loading

  // Configuration from last draw
  int O_X1,O_Y1,O_DX,O_DY,O_D1,O_D2;

  // These variables are used to store configuration
  int S_X1,S_Y1,S_DX,S_DY,S_D1,S_D2,S_NumPoints;
  GdkPoint S_Points[MAXNUMPOINTS];

  void ConnectPoints(int X1,int Y1,int D1,int X2,int Y2,int D2,int *NumPoints,GdkPoint *Points);
  int Opposite(int Dir);
  gboolean IsOK(int Dir,int X1,int Y1,int X2,int Y2);
  int AddMinLength(int Dir,int X,int Y);
  int AddDesiredLength(int Dir,int X,int Y);
  void AddDesiredLength2(int Dir,int& X,int& Y);
  int NumDirs(int Dir);

  virtual void UpdateHandlePos();

  // Saves line state
  virtual void SaveLineState(int X1,int Y1,int DX,int DY,int D1,int D2);

public:
  TCADRightAngleLine(TCADSheet *Sheet,int x=0,int y=0);
  ~TCADRightAngleLine();

  virtual void Draw(GdkRegion *Region);
  virtual void Save(TCADSaveStream *Fl);
  virtual void SaveProperties(TCADSaveStream *Fl);
  virtual char LoadProperty(TCADLoadStream *Fl,char *ID);
  virtual void PostLoad();
  virtual void Load(TCADLoadStream *Fl);

  virtual char HandleDragged(int x,int y,GdkRectangle *RefreshRect);

  virtual TCADObject *ButtonPressed(int x,int y);
  virtual void HandleButtonPressed(int HandleNo,int x,int y);

  virtual void Export(FILE *Fl,TExportFormat Format);

  virtual void RecomputeEncapRect();

  // Right angle line defines own attachment
  virtual gboolean CanAttach(int& x,int& y,TAttach *Attach);

  // Stub for now
  virtual void UpdateLine(gboolean SaveState);

  // Modifies line so that it is on the sheet
  virtual void KeepOnSheet();
};


#endif

