/*********\
*         *
*  Sheet  *
*         *
\*********/

#ifndef GTKFIG_SHEET_H
#define GTKFIG_SHEET_H

#include <gtk/gtkvruler.h>
#include <gtk/gtkhruler.h>
#include <gtk/gtkframe.h>
#include "group.h"

/*
 * Alignments of ends of lines 
 */
typedef enum { LAL_NONE, LAL_GRID, LAL_HALFGRID } TLineAlignment;

/*
 * For alignment of objects
 */
typedef enum { VAL_NONE, VAL_GRID, VAL_TOPS, VAL_BOTTOMS, VAL_SAMEHEIGHT } TVertAlign;
typedef enum { HAL_NONE, HAL_GRID, HAL_LEFTS, HAL_RIGHTS, HAL_SAMEWIDTH } THorizAlign;

/*
 * Ruler settings
 */
typedef struct {
  gboolean Visible;
  GtkMetricType Metric;
} TRulerSettings;

/*
 * Represents one sheet
 */
class TCADSheet : public TCADGroup {
protected:
  GtkWidget *Window,*ScrolledWindow,*Fixed;
  GtkFrame *Frame;
  GtkVRuler *VRuler;
  GtkHRuler *HRuler;

  GdkRectangle WS;  // Contains window position and size
  unsigned long LastUniq;
  gboolean ButtonDown;  // Left mouse buttown is down
  gboolean Dragging;    // We are dragging objects
  gboolean NewRect;     // We are drawing rectangle where object will be drawn
  gboolean ResetOnUp;   // Try to reset mode on ButtonRelease
  gboolean SelectRect;  // We are drawing selection rectangle
  int DownX,DownY,FocusX,FocusY;  // Position where mouse has gone down
  int OldX,OldY;    // Old position - to recognize when mouse position has changed
  int XCorr,YCorr;  // X/Y correction for grid
  THandleType DHType;	// Type of handle we are dragging

  // Stores last-known visibility information
  GdkVisibilityState VisibilityState;

  TCADObject *FirstSelected;

  // Updates FocusRect to contain rectangle (x,y,DownX,DownY) and draws it.
  void UpdateFocusRect(int x,int y);

  // Grid
  gboolean UseGrid,ShowGrid,GX_eq_GY;
  int GridX,GridY;
  gboolean Toggling;

  // Do not change EncapRect of sheet
  virtual void ComputeEncapRect() { }
  virtual void AffectEncapRect(TCADObject *Child) { Child=Child; }

public:
  TCADSheet(char Visible);
  ~TCADSheet();
  virtual void Save(TCADSaveStream *Fl);
  virtual void SaveProperties(TCADSaveStream *Fl);
  virtual char LoadProperty(TCADLoadStream *Fl,char *ID);
  virtual void PostLoad();
  virtual void Export(char *FileName,TExportFormat Format);

  // Filename or NULL for new sheets
  char *FileName;

  // GC used to draw
  GdkGC *GC;
  GdkColor WhiteColor;
  GdkColor BlackColor;

  // Ruler settings
  TRulerSettings VRulerSettings, HRulerSettings;
  void ApplyRulerSettings();

  // Used to draw moving-objects rectangle
  GdkRectangle FocusRect;

  void SetVisibilityState(GdkVisibilityState State);  // Visibility state changed
  void GotFocus();  // Window got focus
  gboolean HasFocus();  // Returns if window has focus

  // Returns whether close widget
  gboolean Close();

  // Shows/hides window
  void Show();
  void BringToFront();
  void Hide();

  // Draws items in rectangle on the sheet. Rectangle may be NULL
  void DrawRect(GdkRectangle *Rect);

  // Retrieves next uniq number
  unsigned long NextUniq();

  virtual void ButtonPressed(int x,int y,gboolean Shift);
  virtual void ButtonReleased();
  virtual void MouseMoved(int x,int y);

  void DrawFocusRect();

  void AddAccelGroup(GtkAccelGroup *AccelGroup);

  void UnselectAll();
  void SelectAll();
  void SelectObject(TCADObject *Object,GdkRectangle *RefreshRect,GdkRectangle *RefreshRect2);

  void AlignObjects(THorizAlign HA, TVertAlign VA);

  void DeleteSelected();
  void EditText();
  TCADObject *GetFirstSelected();

  GdkDrawable *GetDrawable();
  GdkWindow *GetWindow();

  void ShowArrowProperties();
  void ShowTextProperties();
  void ShowGridProperties();

  // Sets title according to filename
  void SetTitle();

  gboolean GetShowGrid() { return ShowGrid; }
  gboolean GetUseGrid() { return UseGrid; }
  void GetGridOptions(gboolean& X_eq_Y,int& GX,int& GY);
  void SetShowGrid(gboolean Value);
  void SetUseGrid(gboolean Value);
  void SetGridOptions(gboolean X_eq_Y,int GX,int GY);
};


#endif

