/***********************\
*                       *
*  Implements TCADText  *
*                       *
\***********************/

#include <string.h>
#include <stdlib.h>
#include "text.h"

TCADText::TCADText(TCADSheet *Sheet) : TCADTextObject(Sheet)
{
  Text = NULL;
  Lines = 0;
}

TCADText::~TCADText()
{
  if (Text != NULL) free(Text);
}

void TCADText::Save(TCADSaveStream *Fl)
{
  Fl->SaveObjectName("TCADText");
  SaveProperties(Fl);
  Fl->SaveEndObject();
}

void TCADText::SaveProperties(TCADSaveStream *Fl)
{
  char *Tmp;

  TCADObject::SaveProperties(Fl);

  SaveTextProperties(Fl);
  if (Text != NULL) {
    Tmp = GetText();
    Fl->SaveString("Text",Tmp);
    free(Tmp);
  }
}

char TCADText::LoadProperty(TCADLoadStream *Fl,char *ID)
{
  if (strcasecmp(ID,"Text") == 0) SetText(Fl->LoadString());
  else if (TCADTextPropertiesI::LoadProperty(Fl,ID)) ;
  else return TCADObject::LoadProperty(Fl,ID);

  return(TRUE);
}

gchar *TCADText::GetText()
{
  char *Result,*TmpPtr;
  int i;

  if (Text == 0) {
    Result = (char *)malloc(1);
    *Result = 0;
  }
  else {
    Result = (char *)malloc(TextLength);
    memcpy(Result,Text,TextLength);

    // Insert LFs
    TmpPtr = Result;
    for(i=1;i<TextLength;i++)
     if (*(TmpPtr++) == 0)
      *(TmpPtr-1) = 10;
  }

  return(Result);
}

void TCADText::SetText(gchar *Text)
{
  char *TmpPtr;

  if (this->Text != NULL) free(this->Text);
  this->Text = strdup(Text);

  /* Count lines and break text to lines */
  Lines = 1;
  TextLength = 1;
  TmpPtr = this->Text;
  while(*TmpPtr) {
    if (*TmpPtr == 10) {
      *TmpPtr = 0;
      Lines++;
    }
    TmpPtr++;
    TextLength++;
  }
}

void TCADText::GetOffsets(int& TOff,int& BOff,int& LOff,int& ROff)
{
  TOff = 0;
  BOff = 0;
  LOff = 0;
  ROff = 0;
}

void TCADText::Draw(GdkRegion *Region)
{
  GdkGC *GC;
  int CH;
  int i,XOff,YOff;
  char *TmpPtr;
  int TOff,BOff,LOff,ROff; // Offsets

  if (Text == NULL) return;

  if (Region)
   if (gdk_region_rect_in(Region, &EncapRect) == GDK_OVERLAP_RECTANGLE_OUT) return;

  GetOffsets(TOff,BOff,LOff,ROff);

  GC = gdk_gc_new(Sheet->GetDrawable());

  // Copy GC and limit drawing region to object size
  gdk_gc_copy(GC,Sheet->GC);
  gdk_gc_set_clip_rectangle(GC,&EncapRect);
  CH = gdk_text_height(TextFont,"Hello",5)+3;

  /* Compute YOff */
  YOff = EncapRect.y+CH+TOff;
  switch(TextVAlign) {
    case AL_VCENTER:
      YOff = EncapRect.y+CH+(EncapRect.height-Lines*CH) / 2;
      break;
    case AL_BOTTOM:
      YOff = EncapRect.y+CH+EncapRect.height-Lines*CH-BOff;
      break;
    default: ;
  }

  /* Draw */
  TmpPtr = Text;
  for(i=0;i<Lines;i++) {
    XOff = EncapRect.x+LOff;
    switch(TextHAlign) {
      case AL_HCENTER:
        XOff = EncapRect.x+(EncapRect.width-gdk_string_width(TextFont,TmpPtr)) / 2;
        break;
      case AL_RIGHT:
        XOff = EncapRect.x+EncapRect.width-gdk_string_width(TextFont,TmpPtr)-ROff;
        break;
      default: ;
    }
    gdk_draw_string(Sheet->GetDrawable(),TextFont,GC,XOff,YOff,TmpPtr);
    while(*TmpPtr++);  // Advance to next line
    YOff += CH;
  }
  gdk_gc_destroy(GC);
}

void TCADText::Select(GdkRectangle *RefreshRect)
{
  TCADObject::Select(RefreshRect);
   UpdateHandlePos();
}

void TCADText::Export(FILE *Fl,TExportFormat Format)
{
  switch(Format) {
    case EF_LATEX:
      int x,y;
      char *Text;
      Text = GetText();
      x = EncapRect.x;
      y = Sheet->EncapRect.height-EncapRect.y-EncapRect.height;
      fprintf(Fl,"\\put(%d,%d){\\makebox(%d,%d){%s}}\n",x,y,EncapRect.width,EncapRect.height,Text);      free(Text);
      break;
    case EF_FIG:
      ExportFigText(Fl);
      break;
  }
}

void TCADText::ExportFigText(FILE *Fl)
{
  int Align;
  unsigned char *Text,*TmpPtr;
  int X,Y;
  int FontSize = 10;
  int TOff,BOff,LOff,ROff;

  GetOffsets(TOff,BOff,LOff,ROff);

  X = EncapRect.x+LOff;
  switch(TextVAlign) {
    case AL_LEFT:
      Align = 0;
      break;
    case AL_HCENTER:
      Align = 1;
      X += (EncapRect.width-LOff-ROff)/2;
      break;
    case AL_RIGHT: 
      Align = 2;
      X += (EncapRect.width-LOff-ROff);
      break;
  }

  Y = EncapRect.y+TOff+FontSize;
  switch(TextHAlign) {
    case AL_TOP:
      break;
    case AL_VCENTER:
      Y += (EncapRect.height-TOff-BOff)/2;
      Y -= (Lines*(FontSize+2))/2;
      break;
    case AL_RIGHT: 
      Y += (EncapRect.height-BOff-TOff);
      Y -= (Lines*(FontSize+2));
      break;
  }
  
  Text = (unsigned char *)GetText();
  TmpPtr = Text;

  // Create one text object for every line
  while(*TmpPtr) {
    fprintf(Fl,"4 %d %d %d %d %d %d %f %d %d %d %d %d ",
     Align,
     0,        // Color
     0,        // Depth
     0,        // Pen style
     0,        // Font
     FontSize, // Fontsize
     (float)0, // Angle
     0,        // Font flags
     EncapRect.height,
     EncapRect.width,
     X,
     Y
     );

    while(*TmpPtr) {
      if (*TmpPtr == 10) break;

      if (*TmpPtr < 128) fputc(*TmpPtr,Fl);
      else fprintf(Fl,"\\%03o",*TmpPtr);
      TmpPtr++;
    }
    fputs("\\001\n",Fl);
    if (*TmpPtr == 10) TmpPtr++;

    Y += FontSize;
  }
  
  free(Text);
}

