/********************************\
*                                *
*  Implements text-editting box  *
*                                *
\********************************/

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#define RES_OK TRUE
#define RES_CANCEL FALSE

typedef struct {
  GtkWidget *Window;
  GtkWidget *TextWidget;
  void (*CallBack)(char *,gpointer);
  gpointer UserData;
} TEBState;

static void CloseDialog(gboolean Result,TEBState *State)
{
  char *Text;

  gtk_widget_hide(State->Window);
  gtk_grab_remove(State->Window);

  if (Result == RES_CANCEL) State->CallBack(NULL,State->UserData);
  else {
    Text = gtk_editable_get_chars(GTK_EDITABLE(State->TextWidget),0,-1);
    State->CallBack(Text,State->UserData);
    g_free(Text);
  }

  free(State);
}

static gboolean on_delete_event(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
  widget=widget;
  event=event;

  CloseDialog(RES_CANCEL,(TEBState *)user_data);

  return(FALSE);
}

static void on_BOK_clicked(GtkButton *button, gpointer user_data)
{
  button=button;

  CloseDialog(RES_OK,(TEBState *)user_data);
}

static void on_BCancel_clicked(GtkButton *button, gpointer user_data)
{
  button=button;

  CloseDialog(RES_CANCEL,(TEBState *)user_data);
}

void TextEditBox(char *OldText,char *Title,void (*CallBack)(char *,gpointer),gpointer UserData)
{
  GtkWidget *DTextEdit;
  GtkWidget *dialog_vbox3;
  GtkWidget *EText;
  GtkWidget *dialog_action_area3;
  GtkWidget *hbuttonbox4;
  GtkWidget *BOK;
  GtkWidget *BCancel;
  GtkAccelGroup *accel_group;

  TEBState  *State;

  if (Title == NULL) Title = "Edit text";

  State = (TEBState *)malloc(sizeof(*State));

  DTextEdit = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (DTextEdit), "DTextEdit", DTextEdit);
  GTK_WINDOW (DTextEdit)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_title (GTK_WINDOW (DTextEdit), Title);
  gtk_window_set_policy (GTK_WINDOW (DTextEdit), TRUE, TRUE, FALSE);

  gtk_signal_connect (GTK_OBJECT (DTextEdit), "delete_event",
                      GTK_SIGNAL_FUNC (on_delete_event),
                      State);

  dialog_vbox3 = GTK_DIALOG (DTextEdit)->vbox;
  gtk_object_set_data (GTK_OBJECT (DTextEdit), "dialog_vbox3", dialog_vbox3);
  gtk_widget_show (dialog_vbox3);
  gtk_container_border_width (GTK_CONTAINER (dialog_vbox3), 10);

  EText = gtk_text_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (DTextEdit), "EText", EText);
  gtk_widget_show (EText);
  gtk_box_pack_start (GTK_BOX (dialog_vbox3), EText, TRUE, TRUE, 0);
  gtk_text_set_editable (GTK_TEXT (EText), TRUE);

  dialog_action_area3 = GTK_DIALOG (DTextEdit)->action_area;
  gtk_object_set_data (GTK_OBJECT (DTextEdit), "dialog_action_area3", dialog_action_area3);
  gtk_widget_show (dialog_action_area3);

  hbuttonbox4 = gtk_hbutton_box_new ();
  gtk_object_set_data (GTK_OBJECT (DTextEdit), "hbuttonbox4", hbuttonbox4);
  gtk_widget_show (hbuttonbox4);
  gtk_box_pack_start (GTK_BOX (dialog_action_area3), hbuttonbox4, TRUE, TRUE, 0);

  BOK = gtk_button_new_with_label ("OK");
  gtk_object_set_data (GTK_OBJECT (DTextEdit), "BOK", BOK);
  gtk_widget_show (BOK);
  gtk_container_add (GTK_CONTAINER (hbuttonbox4), BOK);
  gtk_signal_connect (GTK_OBJECT (BOK), "clicked",
                      GTK_SIGNAL_FUNC (on_BOK_clicked),
                      State);

  BCancel = gtk_button_new_with_label ("Cancel");
  gtk_object_set_data (GTK_OBJECT (DTextEdit), "BCancel", BCancel);
  gtk_widget_show (BCancel);
  gtk_container_add (GTK_CONTAINER (hbuttonbox4), BCancel);
  gtk_signal_connect (GTK_OBJECT (BCancel), "clicked",
                      GTK_SIGNAL_FUNC (on_BCancel_clicked),
                      State);

  accel_group = gtk_accel_group_new();
  gtk_window_add_accel_group (GTK_WINDOW (DTextEdit), accel_group);
  gtk_widget_add_accelerator (BOK, "clicked", accel_group,
                              GDK_Return, GDK_MOD2_MASK, GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator (BCancel, "clicked", accel_group,
                              GDK_Escape, 0, GTK_ACCEL_VISIBLE);

  gtk_window_set_focus(GTK_WINDOW(DTextEdit),EText);

  State->Window = DTextEdit;
  State->TextWidget = EText;
  State->CallBack = CallBack;
  State->UserData = UserData;

  gtk_widget_show(DTextEdit);
  gtk_grab_add(DTextEdit);

  if (OldText != NULL) gtk_text_insert(GTK_TEXT(EText),NULL,NULL,NULL,OldText,strlen(OldText));
}
