/*
 * Copyright (C) 1998 Nathan Neulinger <nneul@umr.edu>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include "gtkyahoo.h"
#include "window-start-conference.h"
#include "window-addressbook.h"
#include "window-login.h"
#include "window-addignore-proto.h"

extern void create_custom_window(void);
void select_menu_status (guint status);

/* Make this global so can retrieve the various menu widgets later */
GtkItemFactory *menus_if;
GtkItemFactory *status_if;

void handle_menu_file_login(GtkWidget * w, gpointer data)
{
	if (context != NULL)
		return;

	if (current_pass == NULL)
	{
		if ((int) data == 0)
		{
			prompt_for_password();
		}
		else
		{
			get_login_credentials ();
		}
	}
	else
		got_password();
}

/* only doing 'away' custom messages, since we can't detect the others,
no sense in sending them */
void handle_menu_custom_status(GtkWidget * w, gpointer data)
{
	if (context == NULL)
		return;
	create_custom_window(); /* this has been made modal */
	select_menu_status (last_user_status);
}

void handle_menu_status(GtkWidget * w, gpointer data)
{
	int statuscode = (int) data;

	if (context == NULL)
		return;

        /*
         * Even if it's what we sent last time, send again, just to
         * give the status further chance to flush through to all friends.
         */

        if (last_sent_status != YAHOO_STATUS_AVAILABLE)	/* am away */
	{
		if (statuscode == YAHOO_STATUS_AVAILABLE)	/* came back */
		{
			yahoo_cmd_set_back_mode(context, statuscode, NULL);
		}
		else
		{
			/* different away msg than current */
			yahoo_cmd_set_away_mode(context, statuscode, NULL);
		}
	}
	else
		/* am here, going away */
	{
		yahoo_cmd_set_away_mode(context, statuscode, NULL);
	}

	last_user_status = statuscode;
	last_sent_status = statuscode;
	gtkyahoo_userlist_refresh();
	select_menu_status (statuscode);
	have_user_activity();
}

/* handle menu for quit */
void handle_menu_file_quit(GtkWidget * w, gpointer data)
{
	if (context != NULL)
		yahoo_cmd_logoff(context);
	gtk_main_quit();
}

void handle_menu_tools_clearnotify(GtkWidget * w, gpointer data)
{
	int len;

	if (context == NULL)
		return;

	if (mw->notify_textbox)
	{
		gtk_text_freeze(GTK_TEXT(mw->notify_textbox));
		len = gtk_text_get_length(GTK_TEXT(mw->notify_textbox));
		gtk_text_set_point(GTK_TEXT(mw->notify_textbox), 0);
		gtk_text_forward_delete(GTK_TEXT(mw->notify_textbox), len);
		gtk_text_thaw(GTK_TEXT(mw->notify_textbox));
	}
}

void handle_menu_tools_addignore(GtkWidget * w, gpointer data)
{
	if (context == NULL)
		return;

	create_addignore_window();
}

void handle_menu_tools_addfriend(GtkWidget * w, gpointer data)
{
	if (context == NULL)
		return;

	create_addfriend_window();
}

void handle_menu_tools_autoreply(GtkWidget * w, gpointer data)
{
	auto_reply = !auto_reply;

	/* only show the window if we're turning on */
	if (auto_reply)
	{
		create_autoreply_window();
	}
}

void handle_menu_tools_autoforward(GtkWidget * w, gpointer data)
{
	auto_forward = !auto_forward;

	/* only show the window if we're turning on */
	if (auto_forward)
	{
		create_autoforward_window();
	}
}

void handle_menu_tools_sendraw(GtkWidget * w, gpointer data)
{
	if (context == NULL)
		return;

	create_sendraw_window();
}

void handle_menu_tools_sendfile(GtkWidget * w, gpointer data)
{
	if (context == NULL)
		return;

	create_sendfile_window();
}

void handle_menu_user_viewprofile(GtkWidget * w, gpointer data)
{
	char url[1000] = "http://edit.yahoo.com/config/show_identity?user=";

	if (!user_selected)
	{
		return;
	}

	strcat(url, user_selected->id);
	strcat(url, "&.src=pg");

	launch_browser(url);
}

void handle_menu_tools_startchat(GtkWidget * w, gpointer data)
{
	if (context == NULL)
		return;

	create_startchat_window();
}

void handle_menu_tools_startconference(GtkWidget * w, gpointer data)
{
	create_start_conference_window();
}

void handle_menu_tools_sendoffline(GtkWidget * w, gpointer data)
{
	if (context == NULL)
		return;

	create_sendoffline_window(NULL, NULL, NULL);
}

void handle_menu_tools_removefriend(GtkWidget * w, gpointer data)
{
	if (context == NULL)
		return;

	create_removefriend_window();
}

void handle_menu_tools_refreshaddresses(GtkWidget * w, gpointer data)
{
	if (context == NULL)
		return;

	(void) yahoo_fetchaddressbook (context);
	gtkyahoo_userlist_refresh();
}

void handle_menu_tools_onlineonly(GtkWidget * w, gpointer data)
{
	show_online_only =
		GTK_CHECK_MENU_ITEM(mw->menuitem_tools_onlineonly)->active;

	if (context == NULL)
		return;

	gtkyahoo_userlist_refresh();
}

void handle_menu_tools_showtime(GtkWidget * w, gpointer data)
{
	show_status_time =
		GTK_CHECK_MENU_ITEM(mw->menuitem_tools_showtime)->active;

	if (context == NULL)
		return;

	gtkyahoo_userlist_refresh();
}

void handle_menu_tools_real_names(GtkWidget * w, gpointer data)
{
	display_real_names =
		GTK_CHECK_MENU_ITEM(mw->menuitem_tools_real_names)->active;

	if (context == NULL)
		return;

	gtkyahoo_userlist_refresh();
}

void handle_menu_tools_friendlymsgsonly(GtkWidget * w, gpointer data)
{
	friendlymsgsonly =
		GTK_CHECK_MENU_ITEM(mw->menuitem_tools_friendlymsgsonly)->active;
}

void handle_menu_tools_myfontsonly(GtkWidget * w, gpointer data)
{
	myfontsonly = GTK_CHECK_MENU_ITEM(mw->menuitem_tools_myfontsonly)->active;
}

static void handle_friend_show_info (GtkWidget *w, gpointer data)
{
	if (user_selected)
	{
		create_addressbook_window (user_selected->id);
	}
}

void handle_menu_tools_menubars_chatbutton(GtkWidget * w, gpointer data)
{
	show_chat_button =
		GTK_CHECK_MENU_ITEM(mw->menuitem_tools_menubars_chatbutton)->active;
	if(show_chat_button) {
		gtk_widget_show(mw->box_buttons);
	}
	else {
		gtk_widget_hide(mw->box_buttons);
	}
}

void handle_menu_tools_menubars_notify_messages(GtkWidget * w, gpointer data)
{
	show_notify_messages =
		GTK_CHECK_MENU_ITEM(mw->menuitem_tools_menubars_notify_messages)->active;

	if(show_notify_messages) {
		gtk_widget_show(mw->notify_hbox);
	}
	else {
		gtk_widget_hide(mw->notify_hbox);
	}
}

void handle_menu_tools_menubars_status(GtkWidget * w, gpointer data)
{
	show_status =
		GTK_CHECK_MENU_ITEM(mw->menuitem_tools_menubars_status)->active;
	if(show_status) {
		gtk_widget_show(mw->box_status);
	}
	else {
		gtk_widget_hide(mw->box_status);
	}
}

static GtkItemFactoryEntry menu_items[] = {
	{"/_File", NULL, 0, 0, "<Branch>"},
	{"/File/About GTKYahoo...", NULL, create_about_window,
		0, "<Item>"},
	{"/File/sep1", NULL, NULL,
		0, "<Separator>"},
	{"/File/Login", "<control><shift>L", handle_menu_file_login,
		0, "<Item>"},
	{"/File/Get Login Credentials...", "<control>L", handle_menu_file_login,
		1, "<Item>"},
	{"/File/sep2", NULL, NULL,
		0, "<Separator>"},
	{"/File/Quit", "<control>Q", handle_menu_file_quit,
		0, "<Item>"},

	{"/_Edit", NULL, 0, 0, "<Branch>"},
	{"/Edit/Friends & Groups", NULL, launch_browser_cb,
		(guint) "http://msg.edit.yahoo.com/config/set_buddylist", "<Item>"},
	{"/Edit/Account Information", NULL, launch_browser_cb,
		(guint) "http://msg.edit.yahoo.com/config/eval_profile", "<Item>"},
	{"/Edit/Profiles & Identities", NULL, launch_browser_cb,
		(guint) "http://msg.edit.yahoo.com/config/edit_identity", "<Item>"},

	{"/_Tools", NULL, 0, 0, "<Branch>"},
	{"/Tools/Start Chat...", "<control>M", handle_menu_tools_startchat,
		0, "<Item>"},
	{"/Tools/Start A Conference...", "<control>C", handle_menu_tools_startconference,
		0, "<Item>"},
	{"/Tools/Send Raw Packet...", "<control>P", handle_menu_tools_sendraw,
		0, "<Item>"},
	{"/Tools/Send Offline Message...", "<control>O", handle_menu_tools_sendoffline,
		0, "<Item>"},
	{"/Tools/Send File...", "<control>F", handle_menu_tools_sendfile,
		0, "<Item>"},
	{"/Tools/Add Friend...", "<control>A", handle_menu_tools_addfriend,
		0, "<Item>"},
	{"/Tools/Remove Friend...", "<control>R", handle_menu_tools_removefriend,
		0, "<Item>"},
	{"/Tools/Ignore User...", "<control>I", handle_menu_tools_addignore,
		0, "<Item>"},
	{"/Tools/Refresh Address Book cache", "<alt>A", handle_menu_tools_refreshaddresses,
		0, "<Item>"},
	{"/Tools/sep1", NULL, NULL,
		0, "<Separator>"},
	{"/Tools/Auto Reply...", NULL, handle_menu_tools_autoreply,
		0, "<CheckItem>"},
	{"/Tools/Auto Forward...", NULL, handle_menu_tools_autoforward,
		0, "<CheckItem>"},
	{"/Tools/Show Online Friends Only", NULL, handle_menu_tools_onlineonly,
		0, "<CheckItem>"},
	{"/Tools/Show Status-Change Times", NULL, handle_menu_tools_showtime,
		0, "<CheckItem>"},
	{"/Tools/Display Real Names", NULL, handle_menu_tools_real_names,
		0, "<CheckItem>"},
	{"/Tools/Accept Messages From Friends Only", NULL, handle_menu_tools_friendlymsgsonly,
		0, "<CheckItem>"},
	{"/Tools/Always Use My Fonts", NULL, handle_menu_tools_myfontsonly,
		0, "<CheckItem>"},
	{"/Tools/Menu Bars", NULL, NULL, 0, "<Branch>"},
	{"/Tools/Menu Bars/Chat Button", NULL, handle_menu_tools_menubars_chatbutton,
		0, "<CheckItem>"},
	{"/Tools/Menu Bars/Notify Messages", NULL, handle_menu_tools_menubars_notify_messages,
		0, "<CheckItem>"},
	{"/Tools/Menu Bars/Status", NULL, handle_menu_tools_menubars_status,
		0, "<CheckItem>"},

	{"/_Y!", NULL, 0, 0, "<Branch>"},
	{"/Y!/Yahoo! Home", NULL, launch_browser_cb,
		(guint) "http://www.yahoo.com", "<Item>"},
	{"/Y!/Find New Friends", NULL, launch_browser_cb,
		(guint) "http://search.profiles.yahoo.com", "<Item>"},
	{"/Y!/Check & Send Email", NULL, launch_browser_cb,
		(guint) "http://mail.yahoo.com", "<Item>"},
	{"/Y!/View Your Address Book", NULL, launch_browser_cb,
		(guint) "http://address.yahoo.com", "<Item>"},
	{"/Y!/View Your Calendar", NULL, launch_browser_cb,
		(guint) "http://calendar.yahoo.com", "<Item>"},
	{"/Y!/Stock Quotes", NULL, launch_browser_cb,
		(guint) "http://finance.yahoo.com", "<Item>"},
	{"/Y!/Personalize Yahoo!", NULL, launch_browser_cb,
		(guint) "http://my.yahoo.com", "<Item>"},
	{"/Y!/Shopping", NULL, launch_browser_cb,
		(guint) "http://shopping.yahoo.com", "<Item>"},
	{"/Y!/Bid on Auctions", NULL, launch_browser_cb,
		(guint) "http://auctions.yahoo.com", "<Item>"},
	{"/Y!/Classified Ads", NULL, launch_browser_cb,
		(guint) "http://classifieds.yahoo.com", "<Item>"},
	{"/Y!/Join & View Clubs", NULL, launch_browser_cb,
		(guint) "http://clubs.yahoo.com", "<Item>"},
	{"/Y!/Play Games", NULL, launch_browser_cb,
		(guint) "http://games.yahoo.com", "<Item>"},
	{"/Y!/Chat With Friends", NULL, launch_browser_cb,
		(guint) "http://chat.yahoo.com", "<Item>"},
	{"/Y!/View & Post Personals", NULL, launch_browser_cb,
		(guint) "http://personals.yahoo.com", "<Item>"},
	{"/Y!/Message Boards", NULL, launch_browser_cb,
		(guint) "http://messages.yahoo.com", "<Item>"},
	{"/Y!/Free Home Pages at GeoCities", NULL, launch_browser_cb,
		(guint) "http://geocities.yahoo.com/home", "<Item>"}
};

static GtkItemFactoryEntry status_items[] = {
	{"/Available",		"<control>F1", handle_menu_status, YAHOO_STATUS_AVAILABLE, "<Item>"},
	{"/sep1",		NULL, 0, 0, "<Separator>"},
	{"/Be Right Back",	"<Control>F2", handle_menu_status, YAHOO_STATUS_BRB, "<Item>"},
	{"/Busy",		"<Control>F3", handle_menu_status, YAHOO_STATUS_BUSY, "<Item>"},
	{"/Not at Home",	"<Control>F4", handle_menu_status, YAHOO_STATUS_NOTATHOME, "<Item>"},
	{"/Not at my Desk",	"<Control>F5", handle_menu_status, YAHOO_STATUS_NOTATDESK, "<Item>"},
	{"/Not in the Office",	"<Control>F6", handle_menu_status, YAHOO_STATUS_NOTINOFFICE, "<Item>"},
	{"/On the Phone",	"<Control>F7", handle_menu_status, YAHOO_STATUS_ONPHONE, "<Item>"},
	{"/On Vacation",	"<Control>F8", handle_menu_status, YAHOO_STATUS_ONVACATION, "<Item>"},
	{"/Out to Lunch",	"<Control>F9", handle_menu_status, YAHOO_STATUS_OUTTOLUNCH, "<Item>"},
	{"/Stepped Out",	"<Control>F10", handle_menu_status, YAHOO_STATUS_STEPPEDOUT, "<Item>"},
	{"/Invisible",		"<Control>F11", handle_menu_status, YAHOO_STATUS_INVISIBLE, "<Item>"},
	{"/sep2",		NULL, 0, 0, "<Separator>"}, 
	{"/Custom Message",	"<Control>F12", handle_menu_custom_status, YAHOO_STATUS_CUSTOM, "<Item>"}
};

static GtkItemFactoryEntry user_online_menu_items[] = {
	{"/Start Chat...", NULL, handle_menu_tools_startchat, 0, "<Item>"},
	{"/Send File...", NULL, handle_menu_tools_sendfile, 0, "<Item>"},
	{"/View Profile...", NULL, handle_menu_user_viewprofile, 0, "<Item>"},
	{"/sep1", NULL, 0, 0, "<Separator>"},
	{"/Remove Friend...", NULL, handle_menu_tools_removefriend, 0, "<Item>"},
	{"/Ignore Friend...", NULL, handle_menu_tools_addignore, 0, "<Item>"},
	/*{"/Ignore Friend...", NULL, handle_menu_tools_addignore_with_name, 0, "<Item>"},*/
	{"/View Nickname \\ Address Book Info...", NULL, handle_friend_show_info, 0, "<Item>"}
};

static GtkItemFactoryEntry user_offline_menu_items[] = {

	{"/Send Offline Message...", NULL, handle_menu_tools_sendoffline, 0,
		"<Item>"},
	{"/Send File...", NULL, handle_menu_tools_sendfile, 0, "<Item>"},
	{"/View Profile...", NULL, handle_menu_user_viewprofile, 0, "<Item>"},
	{"/sep1", NULL, 0, 0, "<Separator>"},
	{"/Remove Friend...", NULL, handle_menu_tools_removefriend, 0, "<Item>"},
	{"/Ignore Friend...", NULL, handle_menu_tools_addignore, 0, "<Item>"},
	/*{"/Ignore Friend...", NULL, handle_menu_tools_addignore_with_name, 0, "<Item>"},*/
	{"/View Nickname \\ Address Book Info...", NULL, handle_friend_show_info, 0, "<Item>"}
};

static GtkItemFactoryEntry notify_menu_items[] = {

	{"/Clear Notify Messages", NULL, handle_menu_tools_clearnotify, 0,
		"<Item>"}
};

void get_main_menu(GtkWidget * window, GtkWidget ** menubar)
{
	GtkItemFactory *item_factory;
	GtkAccelGroup *accel_group;
	gint nmenu_items = sizeof(menu_items) / sizeof(menu_items[0]);

	accel_group = gtk_accel_group_new();

	/* This function initializes the item factory.
	   Param 1: The type of menu - can be GTK_TYPE_MENU_BAR, GTK_TYPE_MENU,
	   or GTK_TYPE_OPTION_MENU.
	   Param 2: The path of the menu.
	   Param 3: A pointer to a gtk_accel_group.  The item factory sets up
	   the accelerator table while generating menus.
	 */

	item_factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>",
		accel_group);
	menus_if = item_factory;

	/* This function generates the menu items. Pass the item factory,
	   the number of items in the array, the array itself, and any
	   callback data for the the menu items. */
	gtk_item_factory_create_items(item_factory, nmenu_items, menu_items,
		NULL);

	/* Attach the new accelerator group to the window. */
	gtk_window_add_accel_group(GTK_WINDOW(window), accel_group);

	if (menubar)
		/* Finally, return the actual menu bar created by the item factory. */
		*menubar = gtk_item_factory_get_widget(item_factory, "<main>");
}

void get_status_menu(GtkWidget * window, GtkWidget ** opmenu)
{
	GtkItemFactory *item_factory;
	GtkAccelGroup *accel_group;
	gint nstatus_items = sizeof(status_items) / sizeof(status_items[0]);

	accel_group = gtk_accel_group_new();

	/* This function initializes the item factory.
	   Param 1: The type of menu - can be GTK_TYPE_MENU_BAR, GTK_TYPE_MENU,
	   or GTK_TYPE_OPTION_MENU.
	   Param 2: The path of the menu.
	   Param 3: A pointer to a gtk_accel_group.  The item factory sets up
	   the accelerator table while generating menus.
	 */

	item_factory = gtk_item_factory_new(GTK_TYPE_MENU, "<status>", accel_group);

	/* This function generates the menu items. Pass the item factory,
	   the number of items in the array, the array itself, and any
	   callback data for the the menu items. */
	gtk_item_factory_create_items(item_factory, nstatus_items, status_items,
		NULL);

	/* Attach the new accelerator group to the window. */
	gtk_window_add_accel_group(GTK_WINDOW(window), accel_group);

	if (opmenu)
		/* Finally, return the actual menu bar created by the item factory. */
		*opmenu = gtk_item_factory_get_widget(item_factory, "<status>");
}

GtkWidget* create_main_menus(struct gtkyahoo_main_window *mw)
{
	get_main_menu(mw->window, &mw->menubar);
	gtk_widget_show(mw->menubar);

	/* set the variables so we will be able to do the toggling of checkbox */
	mw->menuitem_tools_friendlymsgsonly =
		gtk_item_factory_get_widget(menus_if,
		"/Tools/Accept Messages From Friends Only");
	mw->menuitem_tools_myfontsonly =
		gtk_item_factory_get_widget(menus_if, "/Tools/Always Use My Fonts");
	mw->menuitem_tools_onlineonly =
		gtk_item_factory_get_widget(menus_if,
		"/Tools/Show Online Friends Only");
	mw->menuitem_tools_showtime =
		gtk_item_factory_get_widget(menus_if,
		"/Tools/Show Status-Change Times");
	mw->menuitem_tools_real_names =
		gtk_item_factory_get_widget(menus_if,
		"/Tools/Display Real Names");
	mw->menuitem_tools_autoreply =
		gtk_item_factory_get_widget(menus_if, "/Tools/Auto Reply...");
	mw->menuitem_tools_autoforward =
		gtk_item_factory_get_widget(menus_if, "/Tools/Auto Forward...");
	mw->menuitem_tools_sendfile =
		gtk_item_factory_get_widget(menus_if, "/Tools/Send File...");
	mw->menuitem_tools_sendoffline =
		gtk_item_factory_get_widget(menus_if,
		"/Tools/Send Offline Message...");
	mw->menuitem_tools_addfriend =
		gtk_item_factory_get_widget(menus_if, "/Tools/Add Friend...");
	mw->menuitem_tools_removefriend =
		gtk_item_factory_get_widget(menus_if, "/Tools/Remove Friend...");
	mw->menuitem_tools_addignore =
		gtk_item_factory_get_widget(menus_if, "/Tools/Ignore User...");
	mw->menuitem_tools_sendraw =
		gtk_item_factory_get_widget(menus_if, "/Tools/Send Raw Packet...");
	mw->menuitem_tools_startchat =
		gtk_item_factory_get_widget(menus_if, "/Tools/Start Chat...");
	mw->menuitem_file_login =
		gtk_item_factory_get_widget(menus_if, "/File/Login");
	mw->menuitem_file_credentials =
		gtk_item_factory_get_widget(menus_if, "/File/Get Login Credentials...");
	mw->menuitem_tools_menubars_chatbutton =
		gtk_item_factory_get_widget(menus_if, "/Tools/Menu Bars/Chat Button");
	mw->menuitem_tools_menubars_notify_messages =
		gtk_item_factory_get_widget(menus_if, "/Tools/Menu Bars/Notify Messages");
	mw->menuitem_tools_menubars_status =
		gtk_item_factory_get_widget(menus_if, "/Tools/Menu Bars/Status");

	/* set toggle indicator for friendly messages only */
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
		(mw->menuitem_tools_friendlymsgsonly), friendlymsgsonly);
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
		(mw->menuitem_tools_myfontsonly), myfontsonly);
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM
		(mw->menuitem_tools_friendlymsgsonly), TRUE);

	/* set toggle indicator for show online only */
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
		(mw->menuitem_tools_onlineonly), show_online_only);
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM
		(mw->menuitem_tools_onlineonly), TRUE);

	/* set toggle indicator for show status times */
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
		(mw->menuitem_tools_showtime), show_status_time);
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM
		(mw->menuitem_tools_showtime), TRUE);

	/* set toggle indicator for display real names */
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
		(mw->menuitem_tools_real_names), display_real_names);
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM
		(mw->menuitem_tools_real_names), TRUE);

	/* set toggle indicator for auto-reply */
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
		(mw->menuitem_tools_autoreply), auto_reply);
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM
		(mw->menuitem_tools_autoreply), TRUE);

	/* set toggle indicator for auto-forward */
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
		(mw->menuitem_tools_autoforward), auto_forward);
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM
		(mw->menuitem_tools_autoforward), TRUE);

	/* set toggle indicator for chat button menubar */
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
		(mw->menuitem_tools_menubars_chatbutton), show_chat_button);
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM
		(mw->menuitem_tools_menubars_chatbutton), TRUE);

	/* set toggle indicator for status window menubar */
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
		(mw->menuitem_tools_menubars_notify_messages), show_notify_messages);
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM
		(mw->menuitem_tools_menubars_notify_messages), TRUE);

	/* set toggle indicator for status menubar */
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
		(mw->menuitem_tools_menubars_status), show_status);
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM
		(mw->menuitem_tools_menubars_status), TRUE);

	return(mw->menubar);
}

void popup_your_menu(void)
{
    static const gint popup_count = sizeof (status_items) / sizeof (status_items[0]);
    static GtkWidget *popup = NULL;
    static GtkItemFactory *popup_fac = NULL;

    if (NULL == popup_fac)
    {
	popup_fac = gtk_item_factory_new (GTK_TYPE_MENU, "<popup>", NULL);
	gtk_item_factory_create_items (popup_fac, popup_count, status_items, NULL);
	popup = gtk_item_factory_get_widget (popup_fac, "<popup>");
    }

    gtk_menu_popup ((GtkMenu *) popup, NULL, NULL, NULL, NULL, 1, 0);
}

void popup_user_menu(void)
{
	static GtkWidget *user_online_menu = NULL, *user_offline_menu =
		NULL, *user_menu = NULL;
	char *user = NULL;

	if (!user_selected)
	{
		return;
	}

	user = user_selected->id;

	if (status_get_in_pager(user) || status_get_in_chat(user)
		|| status_get_in_game(user))
	{
		if (NULL == user_online_menu)
		{
			const gint item_count =
				sizeof(user_online_menu_items) /

				sizeof(user_online_menu_items[0]);
			GtkItemFactory *item_factory =
				gtk_item_factory_new(GTK_TYPE_MENU, "<user>", NULL);

			gtk_item_factory_create_items(item_factory, item_count,
				user_online_menu_items, NULL);
			user_online_menu =
				gtk_item_factory_get_widget(item_factory, "<user>");
		}

		user_menu = user_online_menu;
	}
	else
	{
		if (NULL == user_offline_menu)
		{
			const gint item_count =
				sizeof(user_offline_menu_items) /

				sizeof(user_offline_menu_items[0]);
			GtkItemFactory *item_factory =
				gtk_item_factory_new(GTK_TYPE_MENU, "<user>", NULL);

			gtk_item_factory_create_items(item_factory, item_count,
				user_offline_menu_items, NULL);
			user_offline_menu =
				gtk_item_factory_get_widget(item_factory, "<user>");
		}

		user_menu = user_offline_menu;
	}

	if (NULL != user_menu)
	{
		gtk_menu_popup((GtkMenu *) user_menu, NULL, NULL, NULL, NULL, 1, 0);
	}
}

void popup_notify_menu(void)
{
	static GtkWidget *notify_menu = NULL;

	if (NULL == notify_menu)
	{
		const gint item_count =
			sizeof(notify_menu_items) / sizeof(notify_menu_items[0]);
		GtkItemFactory *item_factory =
			gtk_item_factory_new(GTK_TYPE_MENU, "<user>", NULL);

		gtk_item_factory_create_items(item_factory, item_count,
			notify_menu_items, NULL);
		notify_menu = gtk_item_factory_get_widget(item_factory, "<user>");
	}

	if (NULL != notify_menu)
	{
		gtk_menu_popup((GtkMenu *) notify_menu, NULL, NULL, NULL, NULL, 1, 0);
	}
}

static void status_announce_func (gpointer key, gpointer value, gpointer user_data)
{
    if (NULL != user_data)
    {
	append_chat_window_notification (value, user_data);
    }
}


void select_menu_status (guint status)
{
    static const gint count = sizeof (status_items) / sizeof (status_items[0]);
    char msg[1000], *your_status = NULL;
    gint i = 0;
    GtkItemFactoryEntry *item = &status_items[0];

    if (status == YAHOO_STATUS_CUSTOM)
    {
	snprintf (msg, 1000, "You are now %s", last_custom_msg);
	your_status = msg;
    }
    else
    {
	your_status = yahoo_get_your_status_string (status);
    }

    for (;i < count; ++i, ++item)
    {
	if (item->callback_action == status)
	{
	    gtk_option_menu_set_history ((GtkOptionMenu *) mw->optionmenu_status, i);
	    if (NULL != cwhash && NULL != your_status)
	    {
		g_hash_table_foreach (cwhash, status_announce_func, your_status);
	    }
	    return;
	}
    }
}
