%{
#include "y.tab.h"
#include <string.h>

extern int lineno;
void yyerror(char *s);

void warning(char *s);
static int yywrap(void);
static char *unescape(char *string);
static char *tmpstring;

#ifdef yywrap
#undef yywrap
#endif
#define YY_NO_UNPUT

%}

ws	[ \t]+
nl	\n

comment_shell   #.*
comment_smb   ;.*
comment_cxx   "//".*
comment_c   "/*".*"*/"
comment		({comment_shell}|{comment_smb}|{comment_cxx}|{comment_c})

 /* these are pure evil, they allow backslashing of quotes within a  */
 /* quoted string */
qstring_single   \'([^\'\n]*|\\\')*[\'\n]
qstring_double   \"([^\"\n]*|\\\")*[\"\n]

integer		[+-]*[0-9]+

%%

{ws}	;
{comment} ;

config	{ return CONFIG; }
end-config	{ return END_CONFIG; }
global	{ return GLOBAL; }
end-global { return END_GLOBAL; }

userid	{ return USERID; }
password { return PASSWORD; }
invisible { return INVISIBLE; }
show-online-only { return SHOW_ONLINE_ONLY; }
show-status-times? { return SHOW_STATUS_TIMES; }
show-idle-messages { return SHOW_IDLE_MESSAGES; }
friendly-messages-only { return FRIENDLYMSGSONLY; }
my-fonts-only { return MYFONTSONLY; }
friends-list-height { return FRIENDS_LIST_HEIGHT; }
chat-window-size { return CHAT_WINDOW_SIZE; }
chat-window-wrap { return CHAT_WINDOW_WRAP; }
show-chat-timestamp { return SHOW_TIMESTAMP; }
debug { return DEBUG; }
show-notify-messages { return NOTIFYMSGS; }
display-real-names { return DISPLAYREALNAMES; }

auto-reply { return AUTO_REPLY; }
auto-forward { return AUTO_FORWARD; }
url-handler { return URL_HANDLER; }
email-handler { return EMAIL_HANDLER; }
connect-retries { return CONNECT_RETRIES; }
connect-delay { return CONNECT_DELAY; }
system-log-file { return SYSTEM_LOG_FILE; }
chat-log-fileformat { return CHAT_LOG_FILE; }

contact { return CONTACT; }
end-contact { return END_CONTACT; }
name { return NAME; }
email { return EMAIL; }

idle-time { return IDLE_TIME; }

action { return ACTION; }
end-action { return END_ACTION; }
type { return TYPE; }
delay { return DELAY; }
command { return COMMAND; }
event { return EVENT; }
sound { return SOUND; }
message { return MESSAGE; }
sound-handler { return SOUND_HANDLER; }

xpm-status-idle { return IMAGE_STATUS_IDLE; }
xpm-status-away { return IMAGE_STATUS_AWAY; }
xpm-status-here { return IMAGE_STATUS_HERE; }
xpm-status-offline { return IMAGE_STATUS_OFFLINE; }

connect-mode { return CONNECT_MODE; }
proxy-host { return PROXY_HOST; }
proxy-user { return PROXY_USER; }
proxy-password { return PROXY_PASSWORD; }
proxy-port { return PROXY_PORT; }

yes 	{ yylval.boolean = 1; return BOOLEAN; }
no 		{ yylval.boolean = 0; return BOOLEAN; }
true 	{ yylval.boolean = 1; return BOOLEAN; }
false 	{ yylval.boolean = 0; return BOOLEAN; }
on 		{ yylval.boolean = 1; return BOOLEAN; }
off 	{ yylval.boolean = 0; return BOOLEAN; }

{qstring_single} { tmpstring = strdup(yytext+1); /* skip open quote */
            if(tmpstring[yyleng-2] != '\'')
                warning("Unterminated single quoted string");
            else
                tmpstring[yyleng-2] = '\0'; /* remove close quote */
			yylval.string = unescape(tmpstring);
			free(tmpstring);
            return QSTRING;
          }

{qstring_double} { tmpstring = strdup(yytext+1); /* skip open quote */
            if(tmpstring[yyleng-2] != '"')
                warning("Unterminated double quoted string");
            else
                tmpstring[yyleng-2] = '\0'; /* remove close quote */
			yylval.string = unescape(tmpstring);
			free(tmpstring);
            return QSTRING;
          }

{integer} { yylval.integer = atoi(yytext); return INTEGER; }

{nl}	{ lineno++; }

%%

void warning(char *s)
{
    printf("\n<warning> %d: %s at %s\n", lineno, s, yytext);
}

void yyerror(char *s)
{
    printf("\n%d: %s at '%s'\n", lineno, s, yytext);
}

static int yywrap(void)
{
	return 1;
}

static char *unescape(char *string)
{
	int i,j,len;
	char *tmp;

	if ( !string ) { return NULL; }
	tmp = strdup(string);

	j = 0;
	len = strlen(string);
	for (i=0; i<len; i++)
	{
		if ( (string[i] == '\\') && (i+1 < len) )
		{
			tmp[j] = string[i+1];
			i++; /* so we'll skip the escaped character */
		}
		else
		{
			tmp[j] = string[i];
		}
		j++;
	}
	tmp[j] = '\0';

	return tmp;
}

