%{
#include <stdio.h>
#include "gtkyahoo.h"
#include "window-login.h"
#include <libyahoo-debug.h>

void yyerror(char *s);
void warning(char *s);
int yylex(void);

static int    config_match = 1;

static char *in_action = NULL;
static char *in_contact = NULL;
static char *in_config = NULL;

%}

%union {
	char *string;
	int boolean;
	int integer;
}

/* major sections */
%token CONFIG END_CONFIG 
%token GLOBAL END_GLOBAL
%token CONTACT END_CONTACT
%token ACTION END_ACTION

%token URL_HANDLER EMAIL_HANDLER SOUND_HANDLER 

%token SHOW_CHAT_BUTTON
%token SHOW_ONLINE_ONLY
%token SHOW_STATUS
%token SHOW_STATUS_TIMES
%token SHOW_IDLE_MESSAGES
%token FRIENDLYMSGSONLY
%token MYFONTSONLY
%token NOTIFYMSGS
%token DISPLAYREALNAMES
%token SHOW_TIMESTAMP
%token FRIENDS_LIST_HEIGHT
%token CHAT_WINDOW_SIZE
%token CHAT_WINDOW_WRAP
%token IMAGE_STATUS_IDLE
%token IMAGE_STATUS_AWAY
%token IMAGE_STATUS_HERE
%token IMAGE_STATUS_OFFLINE
%token USERID
%token PASSWORD
%token INVISIBLE
%token DEBUG
%token AUTO_REPLY 
%token AUTO_FORWARD
%token NAME
%token EMAIL
%token SINGLE_INSTANCE
%token SYSTEM_LOG_FILE
%token CHAT_LOG_FILE
%token EVENT

%token TYPE
%token DELAY
%token MAX_INSTANCES
%token COMMAND
%token FUNCTION
%token SOUND
%token MESSAGE

%token IDLE_TIME

%token PROXY_USER PROXY_PASSWORD PROXY_HOST PROXY_PORT
%token CONNECT_MODE
%token CONNECT_RETRIES
%token CONNECT_DELAY

%token <boolean> BOOLEAN
%token <string> QSTRING
%token <integer> INTEGER

%%

rcfile:	blocks 
	;

blocks: /* empty */ 
	| blocks block 
	;

block: config_start config_options config_end
	| global_start config_options global_end 
	| contact_block
	| action_start action_options action_end
	;

contact_block: contact_start contact_options contact_end
	;

global_start: GLOBAL {
		DBG_Print("rcfile", "[RC] Starting Global Block\n");
		if ( in_config )
		{
			free(in_config);
		}
		in_config = NULL;
		config_match = 1;
	}
	;

global_end: END_GLOBAL {
		DBG_Print("rcfile", "[RC] Ending Global Block\n");
		config_match = 0;
	}
	;

config_start: CONFIG QSTRING {
		if ( !current_config ) /* use first config section */
		{
			current_config = strdup($2);
		}
		if (strcasecmp(current_config, $2)) {
			config_match = 0;
		}
		else
		{
			config_match = 1;
		}

		DBG_Print("rcfile", "[RC] Starting Config Block (%s) %s\n",
				 $2, config_match ? "Enabled" : "Disabled");

		if ( in_config )
		{
			free(in_config);
		}
		in_config = strdup($2);
		name_list = g_list_append (name_list, strdup ($2));
	}
	;

config_end: END_CONFIG {
		DBG_Print("rcfile", "[RC] Ended Config Block (%s)\n", in_config);
		in_config = NULL;
	}
	;

contact_start: CONTACT QSTRING {
		if ( in_contact )
		{
			free(in_contact);
		}
		in_contact = strdup($2);
		DBG_Print("rcfile", "[RC] Starting Contact Block (%s)\n", in_contact);
	}
	;

contact_end: END_CONTACT {
		DBG_Print("rcfile", "[RC] Ended Contact Block (%s)\n", in_contact);
		free(in_contact);
		in_contact = NULL;
	}
	;

action_start: ACTION QSTRING {
		DBG_Print("rcfile", "[RC] Starting Action Block (%s)\n", $2);
		if ( in_action )
		{
			free(in_action);
		}
		in_action = strdup($2);
	}
	;

action_options: /* empty */
	| action_options TYPE QSTRING {
		if (config_match) {
			DBG_Print("rcfile", "[RC]\tGot action type (%s)\n", $3);
			if ( !strcasecmp($3, "command") )
			{
				action_set_type(in_action, ACTION_TYPE_COMMAND);
			}
			else if ( !strcasecmp($3, "perl") )
			{
				action_set_type(in_action, ACTION_TYPE_PERL);
			}
			else if ( !strcasecmp($3, "sound") )
			{
				action_set_type(in_action, ACTION_TYPE_SOUND);
			}
			else if ( !strcasecmp($3, "dialog") )
			{
				action_set_type(in_action, ACTION_TYPE_DIALOG);
			}
			else
			{
				action_set_type(in_action, ACTION_TYPE_UNKNOWN);
			}
		}
	} 
	| action_options DELAY INTEGER {
		if (config_match) {
			DBG_Print("rcfile", "[RC]\tGot action delay (%d)\n", $3);
			action_set_delay(in_action, $3);
		}
	}
	| action_options COMMAND QSTRING {
		if (config_match) {
			DBG_Print("rcfile", "[RC]\tGot action command (%s)\n", $3);
			action_set_command(in_action, $3);
		}
	}
	| action_options SOUND QSTRING {
		if (config_match) {
			DBG_Print("rcfile", "[RC]\tGot action sound (%s)\n", $3);
			action_set_sound(in_action, $3);
		}
	}
	| action_options MESSAGE QSTRING {
		if (config_match) {
			DBG_Print("rcfile", "[RC]\tGot action message (%s)\n", $3);
			action_set_message(in_action, $3);
		}
	}
	;
	

action_end: END_ACTION {
		DBG_Print("rcfile", "[RC] Ended Action Block (%s)\n", in_action);
		free(in_action);
		in_action = NULL;
	}
	;

config_options: /* empty */
	| config_options contact_block /* allow contact to be config specific */
	| config_options auto_reply_option
	| config_options userid_option
	| config_options password_option 
	| config_options invisible_option 
	| config_options show_online_only_option
	| config_options show_status_times_option
	| config_options show_idle_messages_option
	| config_options friendlymsgsonly_option
	| config_options myfontsonly_option
	| config_options show_timestamp_option
	| config_options friends_list_height_option
	| config_options chat_window_size_option
	| config_options chat_window_wrap_option
	| config_options debug_option
	| config_options image_option
	| config_options event_option
	| config_options url_handler_option
	| config_options email_handler_option
	| config_options sound_handler_option
	| config_options connection_options
	| config_options chat_log_fileformat_option
	| config_options logfile_option
	| config_options idle_time_option
	| config_options show_notify_messages_option
	| config_options display_real_names_option
	| config_options show_chat_button_option
	| config_options show_status_option

contact_options: /* empty */
	| contact_options name_option
	| contact_options event_option
	| contact_options email_option

name_option: NAME QSTRING {
		DBG_Print("rcfile", "[RC] Got contact name (%s)\n", $2);
	} ;

email_option: EMAIL QSTRING {
		DBG_Print("rcfile", "[RC] Got contact email (%s)\n", $2);
	} ;

event_option: EVENT QSTRING QSTRING {
		if (config_match) {
			DBG_Print("rcfile", "[RC] Got event handler (%s) for (%s)\n", $3, $2);
			event_set($2, in_contact, current_config, $3);
		}
	} ;

image_option: IMAGE_STATUS_AWAY QSTRING {
    if ( images.status.away ) 
	    free(images.status.away);
	images.status.away = strdup($2); } 
    ;
    | IMAGE_STATUS_IDLE QSTRING { 	
    if ( images.status.idle ) 
	    free(images.status.idle);
	images.status.idle = strdup($2); } 
    ;
    | IMAGE_STATUS_HERE QSTRING { 	
    if ( images.status.here ) 
	    free(images.status.here);
	images.status.here = strdup($2); } 
    ;
    | IMAGE_STATUS_OFFLINE QSTRING { 	
    if ( images.status.offline ) 
	    free(images.status.offline);
	images.status.offline = strdup($2); } 
    ;

logfile_option: SYSTEM_LOG_FILE QSTRING {
		if (config_match) {
			if ( logfilename )
				free(logfilename);
			DBG_Print("rcfile", "[RC] Log file set to '%s'\n", $2);
			logfilename = strdup($2); }
		}
	;

chat_log_fileformat_option: CHAT_LOG_FILE QSTRING {
        if (config_match) {
            if ( chat_log_fileformat )
                 free( chat_log_fileformat );
                DBG_Print("rcfile", 
					"[RC] Chat log file format set to '%s'\n", $2);
                 chat_log_fileformat = strdup($2); }
           }
    ;


connection_options: PROXY_USER QSTRING
	| PROXY_PASSWORD QSTRING
	| connect_mode
	| connect_retries
	| connect_delay
	| PROXY_HOST QSTRING {
		if (config_match) {
			if ( proxy_host ) 
				free(proxy_host);
			DBG_Print("rcfile", "[RC] Set proxy host to '%s'\n", $2);
			proxy_host = strdup($2); }
		}
	;
	| PROXY_PORT INTEGER {
		if (config_match) {
			proxy_port = $2;
			DBG_Print("rcfile", "[RC] Set proxy port to '%d'\n", $2);
		}
	}
	;

connect_retries: CONNECT_RETRIES INTEGER {
		if (config_match) {
			if ( $2 < 0 )
			{
				printf("Warning: connect-retries of %d ignored.\n", $2);
			}
			else
			{
				connect_retries = $2;
			}
		}
	}
	;

connect_delay: CONNECT_DELAY INTEGER {
		if (config_match) {
			if ( $2 < 1 )
			{
				printf("Warning: connect-delay of %d ignored.\n", $2);
			}
			else
			{
				connect_retries = $2;
			}
		}
	}
	;

connect_mode: CONNECT_MODE QSTRING {
		if (config_match) {
			if ( !strcasecmp($2, "normal") )
			{
				connect_mode = YAHOO_CONNECT_NORMAL;
			}
			else if ( !strcasecmp($2, "http") )
			{
				connect_mode = YAHOO_CONNECT_HTTP;
			}
			else if ( !strcasecmp($2, "http-proxy") )
			{
				connect_mode = YAHOO_CONNECT_HTTPPROXY;
			}
#if defined(WITH_SOCKS4)
			else if ( !strcasecmp($2, "socks4") )
			{
				connect_mode = YAHOO_CONNECT_SOCKS4;
			}
#endif /* defined(WITH_SOCKS4) */
#if defined(WITH_SOCKS5)
			else if ( !strcasecmp($2, "socks5") )
			{
				connect_mode = YAHOO_CONNECT_SOCKS5;
			}
#endif /* defined(WITH_SOCKS5) */
		}
	}
	;


url_handler_option: URL_HANDLER QSTRING {
	if (config_match) {
		if ( url_handler )
			free(url_handler);
		url_handler = strdup($2); }
	}
	;

email_handler_option: EMAIL_HANDLER QSTRING {
	if (config_match) {
		if ( email_handler )
			free(email_handler);
		email_handler = strdup($2); }
	}
	;

sound_handler_option: SOUND_HANDLER QSTRING {
	if (config_match) {
		if ( sound_handler )
			free(sound_handler);
		sound_handler = strdup($2); }
	}
	;

userid_option: USERID QSTRING { 
		id_list = g_list_append (id_list, strdup ($2));
		if (config_match) {
			if ( current_user ) 
				free(current_user);
			current_user = strdup($2); 
		}
	}
	;

password_option: PASSWORD QSTRING { 
		if (config_match) {
			if ( current_pass ) 
				free(current_pass);
			current_pass = strdup($2); 
		}
	}
	;

invisible_option: INVISIBLE BOOLEAN { 
		if (config_match) {
			invisible_login = $2;
			DBG_Print("rcfile", "Login invisible set to (%d)\n", $2);
		}
	}
	;

show_online_only_option: SHOW_ONLINE_ONLY BOOLEAN {
		if (config_match) {
			show_online_only = $2;
			DBG_Print("rcfile", "Show online only set to (%d)\n", $2);
		}
	}
	;

show_status_times_option: SHOW_STATUS_TIMES BOOLEAN {
		if (config_match) {
			show_status_time = $2;
			DBG_Print("rcfile", "Show status times set to (%d)\n", $2);
		}
	}
	;

show_idle_messages_option: SHOW_IDLE_MESSAGES BOOLEAN {
		if (config_match) {
			show_idle_messages = $2;
			DBG_Print("rcfile", "Show Idle messages set to (%d)\n", $2);
		}
	}
	;

show_notify_messages_option: NOTIFYMSGS BOOLEAN {
		if (config_match) {
			show_notify_messages = $2;
			DBG_Print("rcfile", "Show notify messages set to (%d)\n", $2);
		}
	}
	;

display_real_names_option: DISPLAYREALNAMES BOOLEAN {
		if (config_match) {
			display_real_names = $2;
			DBG_Print("rcfile", "Display Real Names set to (%d)\n", $2);
		}
	}
	;

friendlymsgsonly_option: FRIENDLYMSGSONLY BOOLEAN {
		if (config_match) {
			friendlymsgsonly = $2;
			DBG_Print("rcfile", "Friendly messages only set to (%d)\n", $2);
		}
	}
	;

myfontsonly_option: MYFONTSONLY BOOLEAN {
		if (config_match) {
			myfontsonly = $2;
			DBG_Print("rcfile", "My Fonts only set to (%d)\n", $2);
		}
	}
	;

friends_list_height_option: FRIENDS_LIST_HEIGHT INTEGER {
		if (config_match) {
			if ( $2 < -1 )
			{
				printf("Warning: friends-list-height of %d ignored.\n", $2);
			}
			else
			{
				friends_list_height = $2;
			}
			friends_list_height = $2;
		}
	}
	;

chat_window_size_option: CHAT_WINDOW_SIZE INTEGER INTEGER {
		if (config_match) {
			if ( $2 < -1 )
			{
				printf("Warning: chat-window-size <width> of %d ignored.\n", $2);
			}
			else
			{
				chat_window_sizew = $2;
			}
			chat_window_sizew = $2;
			if ( $3 < -1 )
			{
				printf("Warning: chat-window-size <height> of %d ignored.\n", $3);
			}
			else
			{
				chat_window_sizeh = $3;
			}
			chat_window_sizeh = $3;
		}
	}
	;

chat_window_wrap_option: CHAT_WINDOW_WRAP BOOLEAN {
		if (config_match) {
			chat_window_wrap = $2;
		}
	}
	;

show_timestamp_option: SHOW_TIMESTAMP BOOLEAN {
		if (config_match) {
			show_timestamp = $2;
		}
	}
	;

idle_time_option: IDLE_TIME INTEGER {
		if (config_match) {
			DBG_Print("rcfile", "idle-time set to (%d) seconds.\n", $2);
			idle_time = $2;
		}
	}
	;

auto_reply_option: AUTO_REPLY BOOLEAN {
		if (config_match) {
			auto_reply = $2;
		}
	}
	| AUTO_REPLY BOOLEAN QSTRING {
		if (config_match) {
			auto_reply = $2;
			if ( auto_reply_message )
				free(auto_reply_message);
			auto_reply_message = strdup($3);
		}
	}
	| AUTO_FORWARD BOOLEAN {
		if (config_match) {
			auto_forward = $2;
		}
	}
	| AUTO_FORWARD BOOLEAN QSTRING {
		if (config_match) {
			auto_forward = $2;
			if ( auto_forward_address )
				free(auto_forward_address);
			auto_forward_address = strdup($3);
		}
	}
	;

debug_option: DEBUG QSTRING INTEGER {
		if (config_match) {
			DBG_Enable($2);
			yahoo_dbg_Enable($2);
		}
	}
	| DEBUG QSTRING {
		if (config_match) {
			DBG_Enable($2);
			yahoo_dbg_Enable($2);
		}
	}
	;

show_chat_button_option: SHOW_CHAT_BUTTON BOOLEAN {
		if (config_match) {
			show_chat_button = $2;
			DBG_Print("rcfile", "Show chat button set to (%d)\n", $2);
		}
	}
	;

show_status_option: SHOW_STATUS BOOLEAN {
		if (config_match) {
			show_status = $2;
			DBG_Print("rcfile", "Show status set to (%d)\n", $2);
		}
	}
	;

%%
int lineno = 1;






