#ifndef GTKYAHOO_STRUCTS_H
#define GTKYAHOO_STRUCTS_H

/* Do not include this file, gtkyahoo.h pulls it in automatically */

/* Both of these need to go away with new events code */
struct gtkyahoo_action
{
	char *command;
	pid_t pid;
	int single_instance;
};

struct gtkyahoo_actions
{
	char *id;
	struct gtkyahoo_actions *next;

	struct gtkyahoo_action logon;
	struct gtkyahoo_action logoff;
	struct gtkyahoo_action status;
	struct gtkyahoo_action message;
	struct gtkyahoo_action mail;
	struct gtkyahoo_action nomail;
	/* When adding more entries, modify lookup_useractions() to strdup them */
};

struct gtkyahoo_images
{
	struct
	{
		char *here;
		char *away;
		char *idle;
		char *offline;
	} status;
};

struct gtkyahoo_chat_window
{
	/* GTK Window Elements */
	GtkWidget *window;

	GtkWidget *box_window;
	GtkWidget *box_menus;
	GtkWidget *box_text;
	GtkWidget *box_entry;

	GtkWidget *button;
	GtkWidget *scroll;

	GtkWidget *textbox;
	GtkWidget *entry;

	/* Parameters for this chat session */
	char *key;
	char *chat_to;				/* Who am I chatting with */
	char *chat_from;			/* Who am I */

	/* If defined, logging a transcript to this file */
	FILE *transcript;
	int singlelog;	/* flag to indicate whether to use multilpe logfiles */
	int hasFocus;
};

struct gtkyahoo_calendar_window
{
	GtkWidget *window;

	GtkWidget *box_window;
	GtkWidget *box_text;

	GtkWidget *label_title;
	GtkWidget *label_timestamp;

	GtkWidget *scroll;
	GtkWidget *textbox;

	GtkWidget *button_view;
};

struct gtkyahoo_sendfile_window
{
	GtkWidget *window;
	GtkWidget *table;
	GtkWidget *hbox;

	GtkWidget *label_active_id;
	GtkWidget *label_id;
	GtkWidget *label_msg;
	GtkWidget *label_file;

	GtkWidget *fs;

	GtkWidget *entry_id;
	GtkWidget *entry_msg;
	GtkWidget *entry_file;

	GtkWidget *combo_active_id;

	GtkWidget *button_browse;
	GtkWidget *button_send;
	GtkWidget *button_cancel;
};

struct gtkyahoo_recvfile_window
{
	GtkWidget *window;

	GtkWidget *box_window;
	GtkWidget *box_text;

	GtkWidget *label_from;
	GtkWidget *label_to;
	GtkWidget *label_url;
	char *url;					/* keep the url in a handy form */
	GtkWidget *label_timestamp;

	GtkWidget *scroll;
	GtkWidget *textbox;

	GtkWidget *button_receive;
};

struct gtkyahoo_chatinvite_window
{
	GtkWidget *window;

	GtkWidget *box_window;
	GtkWidget *box_text;
	GtkWidget *scroll;
	GtkWidget *textbox;
};

struct gtkyahoo_startchat_window
{
	GtkWidget *window;
	GtkWidget *table;

	GtkWidget *label_active_id;
	GtkWidget *label_id;
	GtkWidget *label_msg;

	GtkWidget *entry_id;
	GtkWidget *entry_msg;

	GtkWidget *combo_active_id;

	GtkWidget *hbox;
	GtkWidget *button;
};

struct gtkyahoo_alert_window
{
	GtkWidget *window;
	int modal;

	/* no need to keep labels around */

	GtkWidget *box;
	GtkWidget *button;
};

struct gtkyahoo_sendoffline_window
{
	GtkWidget *window;
	GtkWidget *table;

	GtkWidget *label_active_id;
	GtkWidget *label_id;
	GtkWidget *label_msg;

	GtkWidget *entry_id;
	GtkWidget *entry_msg;

	GtkWidget *combo_active_id;

	GtkWidget *hbox;
	GtkWidget *button;
};

struct gtkyahoo_about_window
{
	GtkWidget *window;
	GtkStyle *about_style;
	GtkStyle *head_style;

	GtkWidget *vbox;
	GtkWidget *label;
	GtkWidget *hbox;
	GtkWidget *scrollw;
	GtkWidget *clist;
	GtkWidget *sep;
	GtkWidget *button;
};

struct gtkyahoo_autoreply_window
{
	GtkWidget *window;
	GtkWidget *table;

	GtkWidget *entry_msg;
	GtkWidget *button;
};

struct gtkyahoo_autoforward_window
{
	GtkWidget *window;
	GtkWidget *table;

	GtkWidget *entry_address;
	GtkWidget *button;
};

struct gtkyahoo_sendraw_window
{
	GtkWidget *window;
	GtkWidget *table;

	GtkWidget *label_service;
	GtkWidget *label_active_id;
	GtkWidget *label_content;

	GtkWidget *entry_service;
	GtkWidget *combo_active_id;
	GtkWidget *entry_content;

	GtkWidget *hbox;
	GtkWidget *button;
};

struct gtkyahoo_addfriend_window
{
	GtkWidget *window;

	GtkWidget *table;

	GtkWidget *label_active_id;
	GtkWidget *label_id;
	GtkWidget *label_group;
	GtkWidget *label_msg;

	GtkWidget *combo_active_id;
	GtkWidget *entry_id;
	GtkWidget *combo_group;
	GtkWidget *entry_msg;

	GtkWidget *button;
	GtkWidget *hbox;			/* Send and Cancel button */

};

struct gtkyahoo_addignore_window
{
	GtkWidget *window;

	GtkWidget *table;

	GtkWidget *label_id;

	GtkWidget *entry_id;

	GtkWidget *button;
	GtkWidget *hbox;			/* Send and Cancel button */

};

struct gtkyahoo_removefriend_window
{
	GtkWidget *window;
	GtkWidget *table;

	GtkWidget *label_active_id;
	GtkWidget *label_id;
	GtkWidget *label_group;
	GtkWidget *label_msg;

	GtkWidget *combo_active_id;
	GtkWidget *entry_id;
	GtkWidget *combo_group;
	GtkWidget *entry_msg;

	GtkWidget *hbox;
	GtkWidget *button;
};

struct gtkyahoo_main_window
{
	GtkStyle *windowstyle;

	GtkTooltips *tooltips;

	GtkWidget *pmwid_pager;
	GdkPixmap *pm_pager;
	GdkBitmap *mask_pager;

	GdkPixmap *pm_icon;
	GdkBitmap *mask_icon;

	GtkWidget *button_mailstatus;
	GtkWidget *pmwid_mailstatus;
	GdkPixmap *pm_mail_full;
	GdkBitmap *mask_mail_full;
	GdkPixmap *pm_mail_empty;
	GdkBitmap *mask_mail_empty;

	GdkPixmap *pm_here;
	GdkBitmap *mask_here;

	GdkPixmap *pm_away;
	GdkBitmap *mask_away;

	GdkPixmap *pm_offline;
	GdkBitmap *mask_offline;

	GdkPixmap *pm_idle;
	GdkBitmap *mask_idle;

	GtkWidget *box_window;
	GtkWidget *box_status;
	GtkWidget *box_userlist;
	GtkWidget *box_notify;
	GtkWidget *box_buttons;

	GtkWidget *notify_hbox;

	GtkWidget *window;
	GtkWidget *button;
	GtkWidget *scrolled_userlist;
	GtkWidget *scroll;

	GtkWidget *menubar;
	GtkWidget *toolbar;

	GtkWidget *rootmenu_file;
	GtkWidget *optionmenu_status;
	GtkWidget *rootmenu_tools;
	GtkWidget *rootmenu_edit;
	GtkWidget *rootmenu_y;
	GtkWidget *menu_file;
	GtkWidget *menu_status;
	GtkWidget *menu_tools;
	GtkWidget *menu_edit;
	GtkWidget *menu_y;
	GtkWidget *menuitem_file_about;
	GtkWidget *menuitem_file_sep;
	GtkWidget *menuitem_file_quit;
	GtkWidget *menuitem_file_sep2;
	GtkWidget *menuitem_file_login;
	GtkWidget *menuitem_file_credentials;
	GtkWidget *menuitem_status_available;
	GtkWidget *menuitem_status_sep;
	GtkWidget *menuitem_status_brb;
	GtkWidget *menuitem_status_busy;
	GtkWidget *menuitem_status_notathome;
	GtkWidget *menuitem_status_notatdesk;
	GtkWidget *menuitem_status_notinoffice;
	GtkWidget *menuitem_status_onphone;
	GtkWidget *menuitem_status_onvacation;
	GtkWidget *menuitem_status_outtolunch;
	GtkWidget *menuitem_status_steppedout;
	GtkWidget *menuitem_status_invisible;
	GtkWidget *menuitem_tools_startchat;
	GtkWidget *menuitem_tools_sendraw;
	GtkWidget *menuitem_tools_sendfile;
	GtkWidget *menuitem_tools_sendoffline;
	GtkWidget *menuitem_tools_addfriend;
	GtkWidget *menuitem_tools_addignore;
	GtkWidget *menuitem_tools_removefriend;
	GtkWidget *menuitem_tools_sep;
	GtkWidget *menuitem_tools_autoreply;
	GtkWidget *menuitem_tools_autoforward;
	GtkWidget *menuitem_tools_onlineonly;
	GtkWidget *menuitem_tools_showtime;
	GtkWidget *menuitem_tools_real_names;
	GtkWidget *menuitem_tools_friendlymsgsonly;
	GtkWidget *menuitem_tools_myfontsonly;
	GtkWidget *menuitem_tools_menubars_chatbutton;
	GtkWidget *menuitem_tools_menubars_notify_messages;
	GtkWidget *menuitem_tools_menubars_status;
	GtkWidget *menuitem_edit_groups;
	GtkWidget *menuitem_edit_acct;
	GtkWidget *menuitem_edit_profiles;
	GtkWidget *menuitem_y_home;
	GtkWidget *menuitem_y_newfriends;
	GtkWidget *menuitem_y_checkmail;
	GtkWidget *menuitem_y_calendar;
	GtkWidget *menuitem_y_quotes;
	GtkWidget *menuitem_y_my;
	GtkWidget *menuitem_y_shop;
	GtkWidget *menuitem_y_auctions;
	GtkWidget *menuitem_y_classifieds;
	GtkWidget *menuitem_y_clubs;
	GtkWidget *menuitem_y_games;
	GtkWidget *menuitem_y_chat;
	GtkWidget *menuitem_y_personals;
	GtkWidget *menuitem_y_msgboards;
	GtkWidget *menuitem_y_geo;

	GtkCTree *userlist;
	int userlist_rowcount;

	GtkWidget *notify_scroll;
	GtkWidget *notify_textbox;
};

#endif
