/*
 * Copyright (C) 1998 Nathan Neulinger <nneul@umr.edu>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include "gtkyahoo.h"
#include "gtkyahoo-authors.h"
#include <libyahoo-authors.h>

#include <sys/utsname.h>

/* Current about window, so we will only show one */
static struct gtkyahoo_about_window *current_aboutw = NULL;

/* Destroy a about window */
void delete_about_window(GtkWidget * widget,
	GdkEvent * event, gpointer * data)
{
	struct gtkyahoo_about_window *aboutw;

	aboutw = (struct gtkyahoo_about_window *) data;

	gtk_widget_destroy(GTK_WIDGET(aboutw->window));
	gtk_style_unref(aboutw->head_style);
	gtk_style_unref(aboutw->about_style);

	free(aboutw);
	current_aboutw = NULL;
}

/* Handle click on continue button */
static void continue_callback(GtkWidget * widget, gpointer * data)
{
	delete_about_window(NULL, NULL, data);
}

/* Create a about window */
void create_about_window(void)
{
	struct gtkyahoo_about_window *aboutw;
	char buf[512];
	struct utsname un;
	int i;
	gchar *titles[3][2] = {
	    { "People who contribute to GTKYahoo", "" },
	    { "People who contribute to libyahoo", "" },
	    { "", "" }
	};

	/* delete the current window if one exists */
	if (current_aboutw)
	{
		delete_about_window(NULL, NULL, (gpointer *) current_aboutw);
		current_aboutw = NULL;
	}

	/* Allocate local structure */
	aboutw = (struct gtkyahoo_about_window *) malloc(sizeof(*aboutw));
	current_aboutw = aboutw;

	/* Allocate a style */
	aboutw->head_style = gtk_style_new();
	aboutw->head_style->font =
		gdk_font_load
		("-adobe-new century schoolbook-bold-r-normal-*-*-240-*-*-p-*-iso8859-1");
	if (!aboutw->head_style->font)
		aboutw->head_style->font = gdk_font_load("fixed");

	aboutw->about_style = gtk_style_new();
	aboutw->about_style->font = gdk_font_load("fixed");

	/* Create main window */
	aboutw->window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_position(GTK_WINDOW(aboutw->window), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(aboutw->window), "About GTKYahoo");
	gtk_container_border_width(GTK_CONTAINER(aboutw->window), 5);
	gtk_widget_realize(aboutw->window);

	/* Trap delete_event signal */
	gtk_signal_connect(GTK_OBJECT(aboutw->window), "delete_event",
		GTK_SIGNAL_FUNC(delete_about_window), (gpointer) aboutw);

	/* Create the vertical box */
	aboutw->vbox = gtk_vbox_new(0, 2);
	gtk_container_add(GTK_CONTAINER(aboutw->window), aboutw->vbox);
	gtk_widget_show(aboutw->vbox);

	aboutw->label = gtk_entry_new();
	gtk_entry_set_editable(GTK_ENTRY(aboutw->label), FALSE);
	gtk_entry_set_text(GTK_ENTRY(aboutw->label), "GTKYahoo " VERSION);
	gtk_widget_set_style(aboutw->label, aboutw->head_style);
	gtk_container_add(GTK_CONTAINER(aboutw->vbox), aboutw->label);
	gtk_widget_show(aboutw->label);

	aboutw->label = gtk_label_new(gtkyahoo_gnu_banner);
	gtk_container_add(GTK_CONTAINER(aboutw->vbox), aboutw->label);
	gtk_widget_show(aboutw->label);

	uname(&un);
	snprintf(buf, sizeof(buf),
		"  Project Started ....... : December 1998\n"
		"  This Binary Compiled .. : " __DATE__ "\n"
		"  GTK+ Version .......... : %d.%d.%d\n"
		"  Currently Running on .. : %s %s [%s]\n"
		"  Author EMail .......... : nneul@umr.edu\n"
		"  Web Page .............. : http://gtkyahoo.sourceforge.net/\n",
		gtk_major_version, gtk_minor_version, gtk_micro_version,
		un.sysname, un.release, un.machine);

	aboutw->label = gtk_label_new(buf);
	gtk_container_add(GTK_CONTAINER(aboutw->vbox), aboutw->label);
	gtk_widget_set_style(aboutw->label, aboutw->about_style);
	gtk_label_set_justify(GTK_LABEL(aboutw->label), GTK_JUSTIFY_LEFT);
	gtk_widget_show(aboutw->label);

	aboutw->sep = gtk_hseparator_new();
	gtk_container_add(GTK_CONTAINER(aboutw->vbox), aboutw->sep);
	gtk_widget_show(aboutw->sep);

	aboutw->label =
		gtk_label_new("\n              "
		"People who contribute to the GTKYahoo and libyahoo projects" "              \n");
	gtk_container_add(GTK_CONTAINER(aboutw->vbox), aboutw->label);
	gtk_widget_set_style(aboutw->label, aboutw->about_style);
	gtk_label_set_justify(GTK_LABEL(aboutw->label), GTK_JUSTIFY_LEFT);
	gtk_widget_show(aboutw->label);

	aboutw->scrollw = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(aboutw->scrollw),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(aboutw->vbox), aboutw->scrollw, TRUE, TRUE, 0);
	gtk_widget_set_usize (aboutw->scrollw, 0, 100);
	gtk_widget_show(aboutw->scrollw);

	aboutw->clist = gtk_clist_new(2);

	gtk_clist_set_column_auto_resize(GTK_CLIST(aboutw->clist), 0, TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(aboutw->clist), 1, TRUE);

	gtk_clist_append(GTK_CLIST(aboutw->clist), titles[0]);
	gtk_clist_append(GTK_CLIST(aboutw->clist), titles[2]);

	for (i = 0; i < AUTHORS_COUNT; ++i)
	{
		gtk_clist_append(GTK_CLIST(aboutw->clist), gtkyahoo_authors[i]);
	}

	gtk_clist_append(GTK_CLIST(aboutw->clist), titles[1]);
	gtk_clist_append(GTK_CLIST(aboutw->clist), titles[2]);

	for (i = 0; i < LIBYAHOO_AUTHORS_COUNT; ++i)
	{
		gtk_clist_append(GTK_CLIST(aboutw->clist), libyahoo_authors[i]);
	}

	gtk_container_add(GTK_CONTAINER(aboutw->scrollw), aboutw->clist);
	gtk_widget_show(aboutw->clist);

	aboutw->hbox = gtk_hbox_new(0, 2);
	gtk_container_add(GTK_CONTAINER(aboutw->vbox), aboutw->hbox);
	gtk_widget_show(aboutw->hbox);

	aboutw->button = gtk_button_new_with_label("  Continue  ");
	gtk_container_set_border_width(GTK_CONTAINER(aboutw->hbox), 2);
	GTK_WIDGET_SET_FLAGS(aboutw->button, GTK_HAS_DEFAULT);
	GTK_WIDGET_SET_FLAGS(aboutw->button, GTK_HAS_FOCUS);
	gtk_box_pack_end(GTK_BOX(aboutw->hbox), aboutw->button, 0, 0, 0);
	gtk_signal_connect(GTK_OBJECT(aboutw->button), "clicked",
		GTK_SIGNAL_FUNC(continue_callback), (gpointer *) aboutw);
	gtk_widget_show(aboutw->button);

	gtk_widget_show(aboutw->window);

	return;
}
