/*
 * Copyright (C) 1998 Nathan Neulinger <nneul@umr.edu>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include "gtkyahoo.h"

void delete_addfriend_window(GtkWidget * widget,
	GdkEvent * event, gpointer * data)
{
	struct gtkyahoo_addfriend_window *afw;

	afw = (struct gtkyahoo_addfriend_window *) data;

	gtk_widget_destroy(GTK_WIDGET(afw->window));
	free(afw);
}

void addfriend_callback(GtkWidget * widget, gpointer * data)
{
	char *active_id, *id, *group, *msg;
	struct gtkyahoo_addfriend_window *afw;

	afw = (struct gtkyahoo_addfriend_window *) data;

	active_id =
		strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(afw->
			combo_active_id)->entry)));
	id = strdup(gtk_entry_get_text(GTK_ENTRY(afw->entry_id)));
	group =
		strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(afw->
				combo_group)->entry)));
	msg = strdup(gtk_entry_get_text(GTK_ENTRY(afw->entry_msg)));

	if (!strcmp(group, ""))
	{
		free(group);
		group = strdup("Misc");
	}

	yahoo_add_buddy(context, id, active_id, group, msg);

	if (msg != NULL && '\0' != *msg)
	{
		char opener[1000];
		struct gtkyahoo_chat_window *cw = get_chat_window(active_id, id);

		snprintf(opener, 1000, "%sYou have made %s your friend...%s",
			YAHOO_COLOR_RED, id, YAHOO_COLOR_BLACK);
		append_chat_msg(cw, NULL, opener);
		append_chat_msg(cw, active_id, msg);
	}

	/* Add the user to the user list, even though the add might not have */
	/* been successful */
	gtkyahoo_userlist_update(id);

	/* Trigger a user status update so the user will be added to the window */
	/* seems that some user adds show up automatically, others don't */
	/* perhaps only if the remote user is logged on */
	have_user_activity();
	yahoo_cmd_user_status(context);

	/* Clean up the window */
	delete_addfriend_window(NULL, NULL, data);

	/* Clean up temp */
	free(active_id);
	free(id);
	free(group);
	free(msg);
}

void callback_cancel_addfriend(GtkWidget * widget, gpointer * data)
{
	delete_addfriend_window(NULL, NULL, data);
}

void create_addfriend_window_with_name(const char *name)
{
	struct gtkyahoo_addfriend_window *afw;

	/* Allocate local structure */
	afw = (struct gtkyahoo_addfriend_window *) malloc(sizeof(*afw));

	/* Create main window */
	afw->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(afw->window), "GTKYahoo: Add Friend");
	gtk_container_border_width(GTK_CONTAINER(afw->window), 5);
	gtk_widget_realize(afw->window);

	/* Trap delete_event signal */
	gtk_signal_connect(GTK_OBJECT(afw->window), "delete_event",
		GTK_SIGNAL_FUNC(delete_addfriend_window), (gpointer) afw);

	/* Create the table */
	afw->table = gtk_table_new(5, 2, FALSE);
	gtk_container_add(GTK_CONTAINER(afw->window), afw->table);
	gtk_widget_show(afw->table);

	/* Create the add-from entry and label */
	afw->label_active_id = gtk_label_new("Add as:");
	gtk_misc_set_alignment(GTK_MISC(afw->label_active_id), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(afw->table), afw->label_active_id, 0, 1, 0, 1,
		GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(afw->label_active_id);

	afw->combo_active_id = create_combo_identities(current_user, 0);
	gtk_table_attach(GTK_TABLE(afw->table), afw->combo_active_id, 1, 2, 0, 1,
		GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
	gtk_widget_show(afw->combo_active_id);

	/* Create the add-from entry and label */
	afw->label_id = gtk_label_new("User to Add:");
	gtk_misc_set_alignment(GTK_MISC(afw->label_id), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(afw->table), afw->label_id, 0, 1, 1, 2,
		GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(afw->label_id);

	afw->entry_id = gtk_entry_new_with_max_length(40);
	gtk_table_attach(GTK_TABLE(afw->table), afw->entry_id, 1, 2, 1, 2,
		GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
	gtk_widget_show(afw->entry_id);
	gtk_widget_grab_focus(afw->entry_id);

	if (NULL != name)
	{
		gtk_entry_set_text(GTK_ENTRY(afw->entry_id), name);
	}

	/* Create the add-from entry and label */
	afw->label_group = gtk_label_new("Group:");
	gtk_misc_set_alignment(GTK_MISC(afw->label_group), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(afw->table), afw->label_group, 0, 1, 2, 3,
		GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(afw->label_group);

	afw->combo_group =
		create_combo_groups((NULL ==
user_selected ? NULL : user_selected->group), 1);
	gtk_table_attach(GTK_TABLE(afw->table), afw->combo_group, 1, 2, 2, 3,
		GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
	gtk_widget_show(afw->combo_group);
	gtk_widget_grab_focus(afw->combo_group);

	/* Create the add-from entry and label */
	afw->label_msg = gtk_label_new("Message:");
	gtk_misc_set_alignment(GTK_MISC(afw->label_msg), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(afw->table), afw->label_msg, 0, 1, 3, 4,
		GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(afw->label_msg);

	afw->entry_msg = gtk_entry_new_with_max_length(100);
	gtk_table_attach(GTK_TABLE(afw->table), afw->entry_msg, 1, 2, 3, 4,
		GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
	gtk_widget_show(afw->entry_msg);
	gtk_widget_grab_focus(afw->entry_msg);

	/* Create a box to hold send and cancel buttons */
	afw->hbox = gtk_hbox_new(TRUE, 2);
	gtk_widget_show(afw->hbox);

	gtk_table_attach(GTK_TABLE(afw->table), afw->hbox, 1, 2, 4, 5,
		GTK_FILL, GTK_FILL, 2, 2);

	/* Create the send button */
	afw->button = gtk_button_new();
	gtk_box_pack_end(GTK_BOX(afw->hbox), afw->button, FALSE, TRUE, 2);
	gtk_widget_show(afw->button);
	gtk_signal_connect(GTK_OBJECT(afw->button), "clicked",
		GTK_SIGNAL_FUNC(addfriend_callback), (gpointer) afw);
	gtk_container_add(GTK_CONTAINER(afw->button),
		xpm_label_box(afw->window, pixmapdata_send, "Add"));

	/* Create a Cancel Button */
	afw->button = gtk_button_new();
	gtk_box_pack_end(GTK_BOX(afw->hbox), afw->button, FALSE, TRUE, 2);
	gtk_widget_show(afw->button);
	gtk_signal_connect(GTK_OBJECT(afw->button), "clicked",
		GTK_SIGNAL_FUNC(callback_cancel_addfriend), (gpointer) afw);
	gtk_container_add(GTK_CONTAINER(afw->button),
		xpm_label_box(afw->window, pixmapdata_cancel, "Cancel"));

	/* Grab focus */
	gtk_widget_show(afw->window);
	gtk_widget_grab_focus(afw->entry_id);
}

void create_addfriend_window(void)
{
	create_addfriend_window_with_name(NULL);
}
