/*
 * Copyright (C) 1998 Nathan Neulinger <nneul@umr.edu>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include "gtkyahoo.h"

void delete_addignore_window(GtkWidget * widget,
	GdkEvent * event, gpointer * data)
{
	struct gtkyahoo_addignore_window *afw;

	afw = (struct gtkyahoo_addignore_window *) data;

	gtk_widget_destroy(GTK_WIDGET(afw->window));
	free(afw);
}

void addignore_callback(GtkWidget * widget, gpointer * data)
{
	char *id;
	struct gtkyahoo_addignore_window *afw;

	afw = (struct gtkyahoo_addignore_window *) data;

	id = strdup(gtk_entry_get_text(GTK_ENTRY(afw->entry_id)));

	/*yahoo_add_buddy(context, id, active_id, group, msg);*/


	/* Trigger a user status update so the user will be removed from the window if needed*/
	have_user_activity();
	yahoo_cmd_user_status(context);

	/* Clean up the window */
	delete_addignore_window(NULL, NULL, data);

	/* Clean up temp */
	free(id);
}

void callback_cancel_addignore(GtkWidget * widget, gpointer * data)
{
	delete_addignore_window(NULL, NULL, data);
}

void create_addignore_window(void)
{
	struct gtkyahoo_addignore_window *afw;

	/* Allocate local structure */
	afw = (struct gtkyahoo_addignore_window *) malloc(sizeof(*afw));

	/* Create main window */
	afw->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(afw->window), "GTKYahoo: Add to Ignore");
	gtk_container_border_width(GTK_CONTAINER(afw->window), 5);
	gtk_widget_realize(afw->window);

	/* Trap delete_event signal */
	gtk_signal_connect(GTK_OBJECT(afw->window), "delete_event",
		GTK_SIGNAL_FUNC(delete_addignore_window), (gpointer) afw);

	/* Create the table */
	afw->table = gtk_table_new(5, 2, FALSE);
	gtk_container_add(GTK_CONTAINER(afw->window), afw->table);
	gtk_widget_show(afw->table);

	/* Create the add-from entry and label */
	afw->label_id = gtk_label_new("User to Ignore:");
	gtk_misc_set_alignment(GTK_MISC(afw->label_id), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(afw->table), afw->label_id, 0, 1, 1, 2,
		GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(afw->label_id);

	afw->entry_id = gtk_entry_new_with_max_length(40);
	gtk_table_attach(GTK_TABLE(afw->table), afw->entry_id, 1, 2, 1, 2,
		GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
	gtk_widget_show(afw->entry_id);
	gtk_widget_grab_focus(afw->entry_id);

	if (user_selected)
	{
		gtk_entry_set_text(GTK_ENTRY(afw->entry_id), user_selected->id);
	}

	/* Create a box to hold send and cancel buttons */
	afw->hbox = gtk_hbox_new(TRUE, 2);
	gtk_widget_show(afw->hbox);

	gtk_table_attach(GTK_TABLE(afw->table), afw->hbox, 1, 2, 4, 5,
		GTK_FILL, GTK_FILL, 2, 2);

	/* Create the send button */
	afw->button = gtk_button_new();
	gtk_box_pack_end(GTK_BOX(afw->hbox), afw->button, FALSE, TRUE, 2);
	gtk_widget_show(afw->button);
	gtk_signal_connect(GTK_OBJECT(afw->button), "clicked",
		GTK_SIGNAL_FUNC(addignore_callback), (gpointer) afw);
	gtk_container_add(GTK_CONTAINER(afw->button),
		xpm_label_box(afw->window, pixmapdata_send, "Ignore"));

	/* Create a Cancel Button */
	afw->button = gtk_button_new();
	gtk_box_pack_end(GTK_BOX(afw->hbox), afw->button, FALSE, TRUE, 2);
	gtk_widget_show(afw->button);
	gtk_signal_connect(GTK_OBJECT(afw->button), "clicked",
		GTK_SIGNAL_FUNC(callback_cancel_addignore), (gpointer) afw);
	gtk_container_add(GTK_CONTAINER(afw->button),
		xpm_label_box(afw->window, pixmapdata_cancel, "Cancel"));

	/* Grab focus */
	gtk_widget_show(afw->window);
	gtk_widget_grab_focus(afw->entry_id);
}
