#include "gtkyahoo.h"

/**********************************************************************************************************************************/
/* Implementation (local) functions */
/**********************************************************************************************************************************/

static void on_ab_cancel_clicked(GtkButton * button, gpointer window)
{
	gtk_widget_destroy(GTK_WIDGET(window));
}

static void on_ab_view_details_clicked(GtkButton * button, gpointer window)
{
	char url[50];
	struct yahoo_address *add_p =
		(struct yahoo_address *) gtk_object_get_data(GTK_OBJECT(window),
		"add_p");

	if (NULL != add_p)
	{
		snprintf(url, 50, "http://address.yahoo.com/yab?A=t&id=%d",
			add_p->entryid);
		launch_browser(url);
	}
	gtk_widget_destroy(GTK_WIDGET(window));
}

static GtkWidget *create_addressbook(void)
{
	GtkWidget *addressbook;
	GtkWidget *ab_box;
	GtkWidget *ab_name_frm;
	GtkWidget *ab_name_table;
	GtkWidget *ab_name_pkr;
	GtkWidget *ab_name_box1;
	GtkWidget *ab_first_lbl;
	GtkWidget *ab_first;
	GtkWidget *ab_name_box2;
	GtkWidget *ad_last_lbl;
	GtkWidget *ab_last;
	GtkWidget *ab_name_box3;
	GtkWidget *ab_nick_lbl;
	GtkWidget *ab_nickname;
	GtkWidget *ab_phone_frm;
	GtkWidget *ab_phone_box1;
	GtkWidget *ab_phone_box4;
	GtkWidget *ab_home_phone_lbl;
	GtkWidget *ab_home_phone;
	GtkWidget *ab_work_phone_lbl;
	GtkWidget *ab_work_phone;
	GtkWidget *ab_prim_phone_frm;
	GtkWidget *ab_phone_box2;
	GtkWidget *ab_phone_box3;
	GSList *ab_phone_box3_group = NULL;
	GtkWidget *ab_radio_home;
	GtkWidget *ab_radio_work;
	GtkWidget *ab_email_frm;
	GtkWidget *ab_email_box;
	GtkWidget *ab_email_lbl;
	GtkWidget *ab_email;
	GtkWidget *ab_button_box;
	GtkWidget *ab_button_bar;
	GtkWidget *ab_view_details;
	GtkWidget *ab_cancel;
	GtkWidget *ab_button_pkr;
	GtkAccelGroup *accel_group;

	accel_group = gtk_accel_group_new();

	addressbook = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data(GTK_OBJECT(addressbook), "addressbook", addressbook);
	gtk_window_set_title(GTK_WINDOW(addressbook), "Address Book Entry for");

	ab_box = gtk_vbox_new(FALSE, 0);
	gtk_widget_ref(ab_box);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_box", ab_box,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_box);
	gtk_container_add(GTK_CONTAINER(addressbook), ab_box);

	ab_name_frm = gtk_frame_new("Name Details");
	gtk_widget_ref(ab_name_frm);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_name_frm",
		ab_name_frm, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_name_frm);
	gtk_box_pack_start(GTK_BOX(ab_box), ab_name_frm, TRUE, TRUE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(ab_name_frm), 4);

	ab_name_table = gtk_table_new(2, 2, FALSE);
	gtk_widget_ref(ab_name_table);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_name_table",
		ab_name_table, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_name_table);
	gtk_container_add(GTK_CONTAINER(ab_name_frm), ab_name_table);

	ab_name_pkr = gtk_packer_new();
	gtk_widget_ref(ab_name_pkr);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_name_pkr",
		ab_name_pkr, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_name_pkr);
	gtk_table_attach(GTK_TABLE(ab_name_table), ab_name_pkr, 1, 2, 1, 2,
		(GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		(GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

	ab_name_box1 = gtk_vbox_new(FALSE, 0);
	gtk_widget_ref(ab_name_box1);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_name_box1",
		ab_name_box1, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_name_box1);
	gtk_table_attach(GTK_TABLE(ab_name_table), ab_name_box1, 0, 1, 0, 1,
		(GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		(GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

	ab_first_lbl = gtk_label_new("First:");
	gtk_widget_ref(ab_first_lbl);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_first_lbl",
		ab_first_lbl, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_first_lbl);
	gtk_box_pack_start(GTK_BOX(ab_name_box1), ab_first_lbl, FALSE, FALSE, 0);
	gtk_misc_set_alignment(GTK_MISC(ab_first_lbl), 0, 0.5);

	ab_first = gtk_entry_new();
	gtk_widget_ref(ab_first);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_first", ab_first,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_first);
	gtk_box_pack_start(GTK_BOX(ab_name_box1), ab_first, FALSE, FALSE, 0);
	GTK_WIDGET_UNSET_FLAGS(ab_first, GTK_CAN_FOCUS);

	ab_name_box2 = gtk_vbox_new(FALSE, 0);
	gtk_widget_ref(ab_name_box2);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_name_box2",
		ab_name_box2, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_name_box2);
	gtk_table_attach(GTK_TABLE(ab_name_table), ab_name_box2, 1, 2, 0, 1,
		(GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);

	ad_last_lbl = gtk_label_new("Last:");
	gtk_widget_ref(ad_last_lbl);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ad_last_lbl",
		ad_last_lbl, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ad_last_lbl);
	gtk_box_pack_start(GTK_BOX(ab_name_box2), ad_last_lbl, FALSE, FALSE, 0);
	gtk_label_set_justify(GTK_LABEL(ad_last_lbl), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment(GTK_MISC(ad_last_lbl), 0, 0.5);

	ab_last = gtk_entry_new();
	gtk_widget_ref(ab_last);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_last", ab_last,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_last);
	gtk_box_pack_start(GTK_BOX(ab_name_box2), ab_last, FALSE, FALSE, 0);
	GTK_WIDGET_UNSET_FLAGS(ab_last, GTK_CAN_FOCUS);

	ab_name_box3 = gtk_vbox_new(FALSE, 0);
	gtk_widget_ref(ab_name_box3);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_name_box3",
		ab_name_box3, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_name_box3);
	gtk_table_attach(GTK_TABLE(ab_name_table), ab_name_box3, 0, 1, 1, 2,
		(GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);

	ab_nick_lbl = gtk_label_new("Nick Name:");
	gtk_widget_ref(ab_nick_lbl);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_nick_lbl",
		ab_nick_lbl, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_nick_lbl);
	gtk_box_pack_start(GTK_BOX(ab_name_box3), ab_nick_lbl, FALSE, FALSE, 0);
	gtk_misc_set_alignment(GTK_MISC(ab_nick_lbl), 0, 0.5);

	ab_nickname = gtk_entry_new();
	gtk_widget_ref(ab_nickname);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_nickname",
		ab_nickname, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_nickname);
	gtk_box_pack_start(GTK_BOX(ab_name_box3), ab_nickname, FALSE, FALSE, 0);
	GTK_WIDGET_UNSET_FLAGS(ab_nickname, GTK_CAN_FOCUS);

	ab_phone_frm = gtk_frame_new("Phone");
	gtk_widget_ref(ab_phone_frm);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_phone_frm",
		ab_phone_frm, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_phone_frm);
	gtk_box_pack_start(GTK_BOX(ab_box), ab_phone_frm, TRUE, TRUE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(ab_phone_frm), 4);

	ab_phone_box1 = gtk_hbox_new(FALSE, 0);
	gtk_widget_ref(ab_phone_box1);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_phone_box1",
		ab_phone_box1, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_phone_box1);
	gtk_container_add(GTK_CONTAINER(ab_phone_frm), ab_phone_box1);

	ab_phone_box4 = gtk_vbox_new(FALSE, 0);
	gtk_widget_ref(ab_phone_box4);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_phone_box4",
		ab_phone_box4, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_phone_box4);
	gtk_box_pack_start(GTK_BOX(ab_phone_box1), ab_phone_box4, TRUE, TRUE, 0);

	ab_home_phone_lbl = gtk_label_new("Home Phone:");
	gtk_widget_ref(ab_home_phone_lbl);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_home_phone_lbl",
		ab_home_phone_lbl, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_home_phone_lbl);
	gtk_box_pack_start(GTK_BOX(ab_phone_box4), ab_home_phone_lbl, FALSE,
		FALSE, 0);
	gtk_misc_set_alignment(GTK_MISC(ab_home_phone_lbl), 0, 0.5);

	ab_home_phone = gtk_entry_new();
	gtk_widget_ref(ab_home_phone);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_home_phone",
		ab_home_phone, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_home_phone);
	gtk_box_pack_start(GTK_BOX(ab_phone_box4), ab_home_phone, FALSE, FALSE,
		0);
	GTK_WIDGET_UNSET_FLAGS(ab_home_phone, GTK_CAN_FOCUS);
	gtk_entry_set_editable(GTK_ENTRY(ab_home_phone), FALSE);

	ab_work_phone_lbl = gtk_label_new("Work Phone:");
	gtk_widget_ref(ab_work_phone_lbl);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_work_phone_lbl",
		ab_work_phone_lbl, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_work_phone_lbl);
	gtk_box_pack_start(GTK_BOX(ab_phone_box4), ab_work_phone_lbl, FALSE,
		FALSE, 0);
	gtk_misc_set_alignment(GTK_MISC(ab_work_phone_lbl), 0, 0.5);

	ab_work_phone = gtk_entry_new();
	gtk_widget_ref(ab_work_phone);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_work_phone",
		ab_work_phone, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_work_phone);
	gtk_box_pack_start(GTK_BOX(ab_phone_box4), ab_work_phone, FALSE, FALSE,
		0);
	GTK_WIDGET_UNSET_FLAGS(ab_work_phone, GTK_CAN_FOCUS);
	gtk_entry_set_editable(GTK_ENTRY(ab_work_phone), FALSE);

	ab_prim_phone_frm = gtk_frame_new("Primary Phone");
	gtk_widget_ref(ab_prim_phone_frm);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_prim_phone_frm",
		ab_prim_phone_frm, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_prim_phone_frm);
	gtk_box_pack_start(GTK_BOX(ab_phone_box1), ab_prim_phone_frm, TRUE, TRUE,
		0);
	gtk_container_set_border_width(GTK_CONTAINER(ab_prim_phone_frm), 4);

	ab_phone_box2 = gtk_hbox_new(FALSE, 0);
	gtk_widget_ref(ab_phone_box2);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_phone_box2",
		ab_phone_box2, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_phone_box2);
	gtk_container_add(GTK_CONTAINER(ab_prim_phone_frm), ab_phone_box2);

	ab_phone_box3 = gtk_vbox_new(FALSE, 0);
	gtk_widget_ref(ab_phone_box3);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_phone_box3",
		ab_phone_box3, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_phone_box3);
	gtk_box_pack_start(GTK_BOX(ab_phone_box2), ab_phone_box3, TRUE, TRUE, 0);

	ab_radio_home =
		gtk_radio_button_new_with_label(ab_phone_box3_group, "Home");
	ab_phone_box3_group =
		gtk_radio_button_group(GTK_RADIO_BUTTON(ab_radio_home));
	gtk_widget_ref(ab_radio_home);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_radio_home",
		ab_radio_home, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_radio_home);
	gtk_box_pack_start(GTK_BOX(ab_phone_box3), ab_radio_home, FALSE, FALSE,
		0);
	GTK_WIDGET_UNSET_FLAGS(ab_radio_home, GTK_CAN_FOCUS);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ab_radio_home), TRUE);

	ab_radio_work =
		gtk_radio_button_new_with_label(ab_phone_box3_group, "Work");
	ab_phone_box3_group =
		gtk_radio_button_group(GTK_RADIO_BUTTON(ab_radio_work));
	gtk_widget_ref(ab_radio_work);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_radio_work",
		ab_radio_work, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_radio_work);
	gtk_box_pack_start(GTK_BOX(ab_phone_box3), ab_radio_work, FALSE, FALSE,
		0);
	GTK_WIDGET_UNSET_FLAGS(ab_radio_work, GTK_CAN_FOCUS);

	ab_email_frm = gtk_frame_new("Other");
	gtk_widget_ref(ab_email_frm);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_email_frm",
		ab_email_frm, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_email_frm);
	gtk_box_pack_start(GTK_BOX(ab_box), ab_email_frm, TRUE, TRUE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(ab_email_frm), 4);

	ab_email_box = gtk_hbox_new(FALSE, 0);
	gtk_widget_ref(ab_email_box);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_email_box",
		ab_email_box, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_email_box);
	gtk_container_add(GTK_CONTAINER(ab_email_frm), ab_email_box);

	ab_email_lbl = gtk_label_new("Email Address:");
	gtk_widget_ref(ab_email_lbl);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_email_lbl",
		ab_email_lbl, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_email_lbl);
	gtk_box_pack_start(GTK_BOX(ab_email_box), ab_email_lbl, FALSE, FALSE, 0);
	gtk_misc_set_alignment(GTK_MISC(ab_email_lbl), 0, 0.5);

	ab_email = gtk_entry_new();
	gtk_widget_ref(ab_email);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_email", ab_email,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_email);
	gtk_box_pack_start(GTK_BOX(ab_email_box), ab_email, TRUE, TRUE, 0);
	GTK_WIDGET_UNSET_FLAGS(ab_email, GTK_CAN_FOCUS);
	gtk_entry_set_editable(GTK_ENTRY(ab_email), FALSE);

	ab_button_box = gtk_hbox_new(FALSE, 0);
	gtk_widget_ref(ab_button_box);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_button_box",
		ab_button_box, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_button_box);
	gtk_box_pack_start(GTK_BOX(ab_box), ab_button_box, TRUE, TRUE, 0);

	ab_button_bar = gtk_hbutton_box_new();
	gtk_widget_ref(ab_button_bar);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_button_bar",
		ab_button_bar, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_button_bar);
	gtk_box_pack_start(GTK_BOX(ab_button_box), ab_button_bar, TRUE, TRUE, 0);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(ab_button_bar),
		GTK_BUTTONBOX_START);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(ab_button_bar), 0);

	ab_view_details = gtk_button_new_with_label("View Details");
	gtk_widget_ref(ab_view_details);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_view_details",
		ab_view_details, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_view_details);
	gtk_container_add(GTK_CONTAINER(ab_button_bar), ab_view_details);
	GTK_WIDGET_SET_FLAGS(ab_view_details, GTK_CAN_DEFAULT);

	ab_cancel = gtk_button_new_with_label("Cancel");
	gtk_widget_ref(ab_cancel);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_cancel", ab_cancel,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_cancel);
	gtk_container_add(GTK_CONTAINER(ab_button_bar), ab_cancel);
	GTK_WIDGET_SET_FLAGS(ab_cancel, GTK_CAN_DEFAULT);
	gtk_widget_add_accelerator(ab_cancel, "clicked", accel_group,
		GDK_Escape, 0, GTK_ACCEL_VISIBLE);

	ab_button_pkr = gtk_packer_new();
	gtk_widget_ref(ab_button_pkr);
	gtk_object_set_data_full(GTK_OBJECT(addressbook), "ab_button_pkr",
		ab_button_pkr, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ab_button_pkr);
	gtk_box_pack_start(GTK_BOX(ab_button_box), ab_button_pkr, TRUE, TRUE, 0);

	gtk_signal_connect(GTK_OBJECT(ab_cancel), "clicked",
		GTK_SIGNAL_FUNC(on_ab_cancel_clicked), addressbook);
	gtk_signal_connect(GTK_OBJECT(ab_view_details), "clicked",
		GTK_SIGNAL_FUNC(on_ab_view_details_clicked), addressbook);

	gtk_widget_grab_default(ab_cancel);
	gtk_window_add_accel_group(GTK_WINDOW(addressbook), accel_group);

	return addressbook;
}

static struct yahoo_address *find_address(const char *id)
{
	struct yahoo_address *add_p = NULL;
	unsigned int count = 0;

	if (NULL == context || NULL == context->addresses
		|| 0 == context->address_count)
		return NULL;

	add_p = context->addresses;
	count = context->address_count;
	while (count-- > 0)
	{
		if (0 == strcasecmp(id, add_p->id))
		{
			return add_p;
		}

		++add_p;
	}

	return NULL;
}

/**********************************************************************************************************************************/
/* Interface (global) functions */
/**********************************************************************************************************************************/

void create_addressbook_window(const char *id)
{
	GtkWindow *window = NULL;
	struct yahoo_address *add_p = find_address(id);

	if (NULL != add_p)
	{
		char *title = NULL, title_head[] = "Address Book Entry for ";

		window = GTK_WINDOW(create_addressbook());
		if (NULL == window)
			return;

		title = malloc(sizeof (title_head) + strlen(id));
		strcpy(title, title_head);
		strcat(title, id);

		gtk_window_set_title(window, title);
		free(title);
		title = NULL;

		if (NULL != add_p->firstname)
		{
			GtkWidget *first =
				gtk_object_get_data(GTK_OBJECT(window), "ab_first");

			if (NULL != first)
				gtk_entry_set_text(GTK_ENTRY(first), add_p->firstname);
		}

		if (NULL != add_p->lastname)
		{
			GtkWidget *last =
				gtk_object_get_data(GTK_OBJECT(window), "ab_last");

			if (NULL != last)
				gtk_entry_set_text(GTK_ENTRY(last), add_p->lastname);
		}

		if (NULL != add_p->emailnickname)
		{
			GtkWidget *nickname =
				gtk_object_get_data(GTK_OBJECT(window), "ab_nickname");

			if (NULL != nickname)
				gtk_entry_set_text(GTK_ENTRY(nickname), add_p->emailnickname);
		}

		if (NULL != add_p->email)
		{
			GtkWidget *email =
				gtk_object_get_data(GTK_OBJECT(window), "ab_email");

			if (NULL != email)
				gtk_entry_set_text(GTK_ENTRY(email), add_p->email);
		}

		if (NULL != add_p->workphone)
		{
			GtkWidget *workphone =
				gtk_object_get_data(GTK_OBJECT(window), "ab_work_phone");

			if (NULL != workphone)
				gtk_entry_set_text(GTK_ENTRY(workphone), add_p->workphone);
		}

		if (NULL != add_p->homephone)
		{
			GtkWidget *homephone =
				gtk_object_get_data(GTK_OBJECT(window), "ab_home_phone");

			if (NULL != homephone)
				gtk_entry_set_text(GTK_ENTRY(homephone), add_p->homephone);
		}

		{
			GtkWidget *radio_home = NULL, *radio_work = NULL;

			radio_home =
				gtk_object_get_data(GTK_OBJECT(window), "ab_radio_home");
			radio_work =
				gtk_object_get_data(GTK_OBJECT(window), "ab_radio_work");
			gtk_widget_set_sensitive(GTK_WIDGET(radio_home), FALSE);
			gtk_widget_set_sensitive(GTK_WIDGET(radio_work), FALSE);
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(add_p->
					primary_phone == home ? radio_home : radio_work), TRUE);
		}

		gtk_object_set_data(GTK_OBJECT(window), "add_p", add_p);
		gtk_widget_show(GTK_WIDGET(window));
	}
	else
	{
		char *msgs[] = {"You do not have an entry for that friend", NULL};

		create_alert_window("GTKYahoo: Address Book Error", msgs, "Oh!", TRUE);
	}
}
