/*
 * Copyright (C) 1998 Nathan Neulinger <nneul@umr.edu>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include "gtkyahoo.h"

#ifndef RET_IF_NULL
#define RET_IF_NULL(_ptr) if (NULL == (void *) (_ptr)) {return;}
#endif /* ndef RET_IF_NULL */

/* Destroy a alert window */
void delete_alert_window(GtkWidget * widget,
	GdkEvent * event, gpointer * data)
{
	struct gtkyahoo_alert_window *alertw;

	RET_IF_NULL (data);

	alertw = (struct gtkyahoo_alert_window *) data;
	gtk_widget_destroy(GTK_WIDGET(alertw->window));

	if (alertw->modal)
	{
		/* This is what the GTK+ FAQ says we should do
		 * but we get SEGV!
		 * gtk_grab_remove (alertw->window);
		 *
		 * Craig.
		 */
		gtk_main_quit();
	}
	free(alertw);
}

void callback_cancel_alert(GtkWidget * widget, gpointer * data)
{
	delete_alert_window(NULL, NULL, data);
}

/* Create a alert window */
void create_alert_window(char *window_title, char *msgs[], char *button_text,
	int modal)
{
	struct gtkyahoo_alert_window *alertw;
	GtkWidget *label;

	/* Allocate local structure */
	alertw = (struct gtkyahoo_alert_window *) malloc(sizeof(*alertw));

	/* Create main window */
	alertw->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(alertw->window), window_title);
	gtk_container_border_width(GTK_CONTAINER(alertw->window), 5);
	gtk_widget_realize(alertw->window);

	/* set whether window is modal or not */
	gtk_window_set_modal(GTK_WINDOW(alertw->window), modal);
	alertw->modal = modal;

	/* Trap delete_event signal */
	gtk_signal_connect(GTK_OBJECT(alertw->window), "delete_event",
		GTK_SIGNAL_FUNC(delete_alert_window), (gpointer) alertw);

	/* Create the hbox for the start/cancel buttons */
	alertw->box = gtk_vbox_new(TRUE, 2);
	gtk_widget_show(alertw->box);
	gtk_container_add(GTK_CONTAINER(alertw->window), alertw->box);

	/* Create the add-from entry and label */
	if (msgs)
	{
		int i = 0;

		while (msgs[i])
		{
			label = gtk_label_new(msgs[i]);
			gtk_box_pack_start(GTK_BOX(alertw->box), label, FALSE, TRUE, 2);
			gtk_widget_show(label);
			i++;
		}
	}

	/* Create the button */
	alertw->button = gtk_button_new();
	gtk_box_pack_start(GTK_BOX(alertw->box), alertw->button, FALSE, FALSE, 2);
	gtk_widget_show(alertw->button);
	gtk_signal_connect(GTK_OBJECT(alertw->button), "clicked",
		GTK_SIGNAL_FUNC(callback_cancel_alert), (gpointer) alertw);
	label = gtk_label_new(button_text);
	gtk_container_add(GTK_CONTAINER(alertw->button), label);
	gtk_widget_show(label);

	gtk_widget_grab_focus(GTK_WIDGET(alertw->button));

	gtk_widget_show(alertw->window);

	if (modal)
	{
		/* This is what the GTK+ FAQ says we should do
		 * but we get SEGV!
		 * gtk_grab_add (alertw->window);
		 *
		 * Craig.
		 */
		gtk_main();
	}
	return;
}
