/*
 * Copyright (C) 1998 Nathan Neulinger <nneul@umr.edu>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include "gtkyahoo.h"

/* Start a chat session from autoforward window */
void autoforward_callback(GtkWidget * widget, gpointer * data)
{
	char *msg;
	struct gtkyahoo_autoforward_window *afw;

	/* get the window */
	afw = (struct gtkyahoo_autoforward_window *) data;
	msg = strdup(gtk_entry_get_text(GTK_ENTRY(afw->entry_address)));

	/* get rid of the window since not needed */
	delete_autoforward_window(NULL, NULL, data);

	/* Store the new parameters */
	if (auto_forward_address)
	{
		free(auto_forward_address);
	}
	auto_forward_address = msg;
}

/* Destroy a autoforward window */
void delete_autoforward_window(GtkWidget * widget,
	GdkEvent * event, gpointer * data)
{
	struct gtkyahoo_autoforward_window *afw;

	afw = (struct gtkyahoo_autoforward_window *) data;
	gtk_widget_destroy(GTK_WIDGET(afw->window));
	free(afw);
}

/* Call the delete function  */
void callback_cancel_autoforward(GtkWidget * widget, gpointer data)
{
	delete_autoforward_window(NULL, NULL, data);
}

/* Create a autoforward window */
void create_autoforward_window(void)
{
	struct gtkyahoo_autoforward_window *afw;

	/* Allocate local structure */
	afw = (struct gtkyahoo_autoforward_window *) malloc(sizeof(*afw));

	/* Create main window */
	afw->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(afw->window), "GTKYahoo: Auto Forward");
	gtk_container_border_width(GTK_CONTAINER(afw->window), 5);
	gtk_widget_realize(afw->window);

	/* Trap delete_event signal */
	gtk_signal_connect(GTK_OBJECT(afw->window), "delete_event",
		GTK_SIGNAL_FUNC(delete_autoforward_window), (gpointer) afw);

	/* Create the table */
	afw->table = gtk_table_new(2, 2, FALSE);
	gtk_widget_show(afw->table);
	gtk_container_add(GTK_CONTAINER(afw->window), afw->table);

	/* Create the message entry */
	afw->entry_address = gtk_entry_new_with_max_length(255);
	gtk_table_attach(GTK_TABLE(afw->table), afw->entry_address, 0, 2, 0, 1,
		GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
	if (auto_forward_address)
	{
		gtk_entry_set_text(GTK_ENTRY(afw->entry_address),
			auto_forward_address);
	}
	gtk_widget_show(afw->entry_address);
	gtk_widget_grab_focus(afw->entry_address);

	gtk_signal_connect(GTK_OBJECT(afw->entry_address), "activate",
		GTK_SIGNAL_FUNC(autoforward_callback), (gpointer) afw);

	/* Create the cancel button */
	afw->button = gtk_button_new_with_label("Cancel");
	gtk_table_attach(GTK_TABLE(afw->table), afw->button, 0, 1, 1, 2,
		GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 2, 2);
	gtk_signal_connect(GTK_OBJECT(afw->button), "clicked",
		GTK_SIGNAL_FUNC(callback_cancel_autoforward), (gpointer) afw);
	gtk_widget_show(afw->button);

	/* Create the ok button */
	afw->button = gtk_button_new_with_label("Configure Auto-Forward");
	gtk_table_attach(GTK_TABLE(afw->table), afw->button, 1, 2, 1, 2,
		GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 2, 2);
	gtk_widget_show(afw->button);
	gtk_signal_connect(GTK_OBJECT(afw->button), "clicked",
		GTK_SIGNAL_FUNC(autoforward_callback), (gpointer) afw);

	gtk_widget_show(afw->window);
	return;
}

void handle_autoforward(struct yahoo_packet *pkt)
{
	char tmpmsg[150];
	struct gtkyahoo_chat_window *cw;
	FILE *mailer;

	if (!pkt || !pkt->msg)
	{
		printf("Error: autoforward got null pkt or msg\n");
		return;
	}

	if (!auto_forward)
	{
		/* autoforward not enabled */
		return;
	}

	if (!auto_forward_address)
	{
		return;
	}

	if (!email_handler)
	{
		return;
	}

	if (strstr(pkt->msg, "<Auto-Reply>"))
	{
		/* never autoforward an auto-reply message */
		return;
	}

	/* send the message */
	mailer = popen(email_handler, "w");
	if (!mailer)
	{
		printf("Error: Couldn't open email handler\n");
		return;
	}
	fprintf(mailer, "To: %s\n", auto_forward_address);
	fprintf(mailer, "Subject: Yahoo message from %s\n", pkt->msg_id);
	fprintf(mailer, "\n\n");
	fprintf(mailer, "Message From: %s\n", pkt->msg_id);
	fprintf(mailer, "Message To: %s\n", pkt->active_id);
	fprintf(mailer, "Message:\n\n");
	fprintf(mailer, "%s", pkt->msg);
	pclose(mailer);

	/* build the notification message */
	strcpy(tmpmsg, YAHOO_COLOR_RED "<Auto-Reply> " YAHOO_COLOR_BLACK);
	strcat(tmpmsg, "Message forwarded via e-mail.");

	/* let the remote person know we forwarded the message via email */
	cw = get_chat_window(pkt->active_id, pkt->msg_id);
	gdk_window_raise(cw->window->window);

	have_user_activity();
	yahoo_cmd_msg(context, pkt->active_id, pkt->msg_id, tmpmsg);
	append_chat_msg(cw, NULL, YAHOO_COLOR_RED "<Message Auto-Forwarded>");

	/* Grab focus */
	gtk_widget_grab_focus(cw->entry);
}
