/*
 * Copyright (C) 1998 Nathan Neulinger <nneul@umr.edu>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include "gtkyahoo.h"

/* Start a chat session from autoreply window */
void autoreply_callback(GtkWidget * widget, gpointer * data)
{
	char *msg;
	struct gtkyahoo_autoreply_window *arw;

	/* get the window */
	arw = (struct gtkyahoo_autoreply_window *) data;
	msg = strdup(gtk_entry_get_text(GTK_ENTRY(arw->entry_msg)));

	/* get rid of the window since not needed */
	delete_autoreply_window(NULL, NULL, data);

	/* Store the new parameters */
	if (auto_reply_message)
	{
		free(auto_reply_message);
	}
	auto_reply_message = msg;
}

/* Destroy a autoreply window */
void delete_autoreply_window(GtkWidget * widget,
	GdkEvent * event, gpointer * data)
{
	struct gtkyahoo_autoreply_window *arw;

	arw = (struct gtkyahoo_autoreply_window *) data;
	gtk_widget_destroy(GTK_WIDGET(arw->window));
	free(arw);
}

/* Call the delete function */
void callback_cancel_autoreply(GtkWidget * widget, gpointer data)
{
	delete_autoreply_window(NULL, NULL, data);
}

/* Create a autoreply window */
void create_autoreply_window(void)
{
	struct gtkyahoo_autoreply_window *arw;

	/* Allocate local structure */
	arw = (struct gtkyahoo_autoreply_window *) malloc(sizeof(*arw));

	/* Create main window */
	arw->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(arw->window), "GTKYahoo: Auto Reply");
	gtk_container_border_width(GTK_CONTAINER(arw->window), 5);
	gtk_widget_realize(arw->window);

	/* Trap delete_event signal */
	gtk_signal_connect(GTK_OBJECT(arw->window), "delete_event",
		GTK_SIGNAL_FUNC(delete_autoreply_window), (gpointer) arw);

	/* Create the table */
	arw->table = gtk_table_new(2, 2, FALSE);
	gtk_widget_show(arw->table);
	gtk_container_add(GTK_CONTAINER(arw->window), arw->table);

	/* Create the message entry */
	arw->entry_msg = gtk_entry_new_with_max_length(255);
	gtk_table_attach(GTK_TABLE(arw->table), arw->entry_msg, 0, 2, 0, 1,
		GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 2, 2);
	if (auto_reply_message)
	{
		gtk_entry_set_text(GTK_ENTRY(arw->entry_msg), auto_reply_message);
	}
	gtk_widget_show(arw->entry_msg);
	gtk_widget_grab_focus(arw->entry_msg);

	gtk_signal_connect(GTK_OBJECT(arw->entry_msg), "activate",
		GTK_SIGNAL_FUNC(autoreply_callback), (gpointer) arw);

	/* Create the cancel button */
	arw->button = gtk_button_new_with_label("Cancel");
	gtk_table_attach(GTK_TABLE(arw->table), arw->button, 0, 1, 1, 2,
		GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 2, 2);
	gtk_widget_show(arw->button);
	gtk_signal_connect(GTK_OBJECT(arw->button), "clicked",
		GTK_SIGNAL_FUNC(callback_cancel_autoreply), (gpointer) arw);

	/* Create the ok button */
	arw->button = gtk_button_new_with_label("Configure Auto-Reply");
	gtk_table_attach(GTK_TABLE(arw->table), arw->button, 1, 2, 1, 2,
		GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 2, 2);
	gtk_widget_show(arw->button);
	gtk_signal_connect(GTK_OBJECT(arw->button), "clicked",
		GTK_SIGNAL_FUNC(autoreply_callback), (gpointer) arw);

	gtk_widget_show(arw->window);
	return;
}

void handle_autoreply(struct yahoo_packet *pkt)
{
	char *tmpmsg;
	struct gtkyahoo_chat_window *cw;

	if (!pkt || !pkt->msg)
	{
		printf("Error: autoreply got null pkt or msg\n");
		return;
	}

	if (!auto_reply)
	{
		/* autoreply not enabled */
		return;
	}

	if (strstr(pkt->msg, "<Auto-Reply>"))
	{
		/* never autoreply to an autoreply message */
		return;
	}

	if (!auto_reply_message)
	{
		auto_reply_message = strdup("I'm not here.");
	}

	/* build the message */
	tmpmsg = (char *) malloc(strlen(auto_reply_message) + 40);
	if (!tmpmsg)
	{
		exit(1);
	}
	strcpy(tmpmsg, YAHOO_COLOR_RED "<Auto-Reply> " YAHOO_COLOR_BLACK);
	strcat(tmpmsg, auto_reply_message);

	/* actually send the message and add the note to the chat window */
	cw = get_chat_window(pkt->active_id, pkt->msg_id);
	gdk_window_raise(cw->window->window);

	have_user_activity();
	yahoo_cmd_msg(context, pkt->active_id, pkt->msg_id, tmpmsg);
	append_chat_msg(cw, NULL, YAHOO_COLOR_RED "<Auto-Reply Sent>");

	/* Free the temporary message */
	free(tmpmsg);

	/* Grab focus */
	gtk_widget_grab_focus(cw->entry);
}
