/*
 * Copyright (C) 1998 Nathan Neulinger <nneul@umr.edu>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include "gtkyahoo.h"

#ifndef RET_IF_NULL
#define RET_IF_NULL(_ptr) if (NULL == (void *) (_ptr)) {return;}
#endif /* ndef RET_IF_NULL */

/* another callback */
void delete_calendar_window(GtkWidget * widget,
	GdkEvent * event, gpointer * data)
{
	struct gtkyahoo_calendar_window *tmpcw;

	RET_IF_NULL (data);

	tmpcw = (struct gtkyahoo_calendar_window *) data;

	/* Destroy/free all the window elements */
	gtk_widget_destroy(GTK_WIDGET(tmpcw->window));

	free(tmpcw);
}

/* create a calendar event window */
/* Create a chat window */
struct gtkyahoo_calendar_window *create_calendar_window(struct yahoo_packet
	*pkt)
{
	struct gtkyahoo_calendar_window *cw;

	/* Allocate local structure */
	cw = (struct gtkyahoo_calendar_window *) malloc(sizeof(*cw));

	/* Create main window */
	cw->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(cw->window), "Calendar Event");
	gtk_container_border_width(GTK_CONTAINER(cw->window), 5);
	gtk_widget_realize(cw->window);

	/* Trap delete_event signal */
	gtk_signal_connect(GTK_OBJECT(cw->window), "delete_event",
		GTK_SIGNAL_FUNC(delete_calendar_window), (gpointer) cw);

	cw->box_window = gtk_vbox_new(FALSE, 0);
	cw->box_text = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(cw->box_window);
	gtk_widget_show(cw->box_text);

	/* build the full window box */
	gtk_container_add(GTK_CONTAINER(cw->window), cw->box_window);

	/* create the first label */
	cw->label_title = gtk_label_new(pkt->cal_title);
	gtk_widget_show(cw->label_title);
	gtk_box_pack_start(GTK_BOX(cw->box_window),
		cw->label_title, TRUE, TRUE, 5);

	cw->label_timestamp = gtk_label_new(pkt->cal_timestamp);
	gtk_widget_show(cw->label_timestamp);
	gtk_box_pack_start(GTK_BOX(cw->box_window),
		cw->label_timestamp, TRUE, TRUE, 5);

	/* pack the box for the text area and scrollbar */
	gtk_box_pack_start(GTK_BOX(cw->box_window), cw->box_text, TRUE, TRUE, 5);

	/* create a text box */
	cw->textbox = gtk_text_new(NULL, NULL);
	gtk_box_pack_start(GTK_BOX(cw->box_text), cw->textbox, TRUE, TRUE, 0);
	gtk_widget_show(cw->textbox);

	/* Make the text box scrollable */
	cw->scroll = gtk_vscrollbar_new(GTK_TEXT(cw->textbox)->vadj);
	gtk_box_pack_start(GTK_BOX(cw->box_text), cw->scroll, FALSE, FALSE, 0);
	gtk_widget_show(cw->scroll);

	/* put the packets content into the text box */
	append_to_textbox(cw->window, cw->textbox, pkt->cal_description);

	/* create the view-event button */
	cw->button_view = gtk_button_new();
	gtk_box_pack_start(GTK_BOX(cw->box_window), cw->button_view,
		FALSE, TRUE, 0);
	gtk_widget_show(cw->button_view);
/* for now, just destroy the window */
	gtk_signal_connect(GTK_OBJECT(cw->button_view), "clicked",
		GTK_SIGNAL_FUNC(delete_calendar_window), NULL);
	gtk_container_add(GTK_CONTAINER(cw->button_view),
		xpm_label_box(cw->window, pixmapdata_send, "View Event"));

	gtk_widget_show(cw->window);
	return cw;
}
