/*
 * Copyright (C) 1998 Nathan Neulinger <nneul@umr.edu>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include "gtkyahoo.h"

/* another callback */
void delete_chatinvite_window(GtkWidget * widget,
	GdkEvent * event, gpointer * data)
{
	struct gtkyahoo_chatinvite_window *tmpcw;

	tmpcw = (struct gtkyahoo_chatinvite_window *) data;

	/* Destroy/free all the window elements */
	gtk_widget_destroy(GTK_WIDGET(tmpcw->window));

	free(tmpcw);
}

/* create a chatinvite event window */
/* Create a chat window */
struct gtkyahoo_chatinvite_window *create_chatinvite_window(char *content)
{
	struct gtkyahoo_chatinvite_window *cw;

	/* Allocate local structure */
	cw = (struct gtkyahoo_chatinvite_window *) malloc(sizeof(*cw));

	/* Create main window */
	cw->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(cw->window), "Chat Invitation");
	gtk_container_border_width(GTK_CONTAINER(cw->window), 5);
	gtk_widget_realize(cw->window);

	/* Trap delete_event signal */
	gtk_signal_connect(GTK_OBJECT(cw->window), "delete_event",
		GTK_SIGNAL_FUNC(delete_chatinvite_window), (gpointer) cw);

	/* Create the boxes */
	/* 1) whole window (menu_box,image,text_box) */
	/* 2) menu bar box */
	/* 3) text area box */
	cw->box_window = gtk_vbox_new(FALSE, 0);
	cw->box_text = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(cw->box_window);
	gtk_widget_show(cw->box_text);

	/* build the full window box */
	gtk_container_add(GTK_CONTAINER(cw->window), cw->box_window);
	gtk_box_pack_start(GTK_BOX(cw->box_window), cw->box_text, TRUE, TRUE, 5);

	/* create a text box */
	cw->textbox = gtk_text_new(NULL, NULL);
	gtk_box_pack_start(GTK_BOX(cw->box_text), cw->textbox, TRUE, TRUE, 0);
	/* turned off since looked a little weird */
	/* gtk_text_set_word_wrap(GTK_TEXT(cw->textbox), TRUE); */
	gtk_widget_show(cw->textbox);

	/* Make the text box scrollable */
	cw->scroll = gtk_vscrollbar_new(GTK_TEXT(cw->textbox)->vadj);
	gtk_box_pack_start(GTK_BOX(cw->box_text), cw->scroll, FALSE, FALSE, 0);
	gtk_widget_show(cw->scroll);

	/* put the pkt content into the text box */
	append_to_textbox(cw->window, cw->textbox, content);

	gtk_widget_show(cw->window);
	return cw;
}
