/* Standard system headers */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/* Dependant library headers */
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <libyahoo.h>

/* Project headers */
#include "gtkyahoo-proto.h"
#include "window-conference-invitation.h"
#include "window-alert-proto.h"
#include "window-conference.h"

/* MACRO definitions */
#define _(A) A

/**********************************************************************************************************************************/
/* Implementation (local) functions */
/**********************************************************************************************************************************/

static void on_decline_send_clicked(GtkButton * button, gpointer window)
{
	GtkEntry *declined =
		GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(window), "declined"));

	gtk_object_set_data(GTK_OBJECT(window), "reply",
		gtk_entry_get_text(declined));
	gtk_main_quit();
}

static void on_decline_cancel_clicked(GtkButton * button, gpointer window)
{
	gtk_main_quit();
}

static GtkWidget *create_conference_decline(void)
{
	GtkWidget *conference_decline;
	GtkWidget *vbox3;
	GtkWidget *decline_lbl;
	GtkWidget *declined;
	GtkWidget *hbuttonbox2;
	GtkWidget *send;
	GtkWidget *cancel;
	GtkAccelGroup *accel_group;

	accel_group = gtk_accel_group_new();

	conference_decline = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data(GTK_OBJECT(conference_decline), "conference_decline",
		conference_decline);
	gtk_window_set_title(GTK_WINDOW(conference_decline),
		_("Decline Conference"));

	vbox3 = gtk_vbox_new(FALSE, 0);
	gtk_widget_ref(vbox3);
	gtk_object_set_data_full(GTK_OBJECT(conference_decline), "vbox3", vbox3,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(vbox3);
	gtk_container_add(GTK_CONTAINER(conference_decline), vbox3);

	decline_lbl =
		gtk_label_new(_
		("You may enter a message to the Host of the conference exlpaining why you wish to decline:"));
	gtk_widget_ref(decline_lbl);
	gtk_object_set_data_full(GTK_OBJECT(conference_decline), "decline_lbl",
		decline_lbl, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(decline_lbl);
	gtk_box_pack_start(GTK_BOX(vbox3), decline_lbl, TRUE, FALSE, 0);
	gtk_label_set_line_wrap(GTK_LABEL(decline_lbl), TRUE);

	declined = gtk_entry_new();
	gtk_widget_ref(declined);
	gtk_object_set_data_full(GTK_OBJECT(conference_decline), "declined",
		declined, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(declined);
	gtk_box_pack_start(GTK_BOX(vbox3), declined, FALSE, FALSE, 10);
	gtk_entry_set_text(GTK_ENTRY(declined), _("Thanks, but no thanks."));

	hbuttonbox2 = gtk_hbutton_box_new();
	gtk_widget_ref(hbuttonbox2);
	gtk_object_set_data_full(GTK_OBJECT(conference_decline), "hbuttonbox2",
		hbuttonbox2, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(hbuttonbox2);
	gtk_box_pack_start(GTK_BOX(vbox3), hbuttonbox2, TRUE, FALSE, 0);
	gtk_widget_set_usize(hbuttonbox2, -2, 31);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox2),
		GTK_BUTTONBOX_SPREAD);

	send = gtk_button_new_with_label(_("Send"));
	gtk_widget_ref(send);
	gtk_object_set_data_full(GTK_OBJECT(conference_decline), "send", send,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(send);
	gtk_container_add(GTK_CONTAINER(hbuttonbox2), send);
	GTK_WIDGET_SET_FLAGS(send, GTK_CAN_DEFAULT);

	cancel = gtk_button_new_with_label(_("Cancel"));
	gtk_widget_ref(cancel);
	gtk_object_set_data_full(GTK_OBJECT(conference_decline), "cancel", cancel,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(cancel);
	gtk_container_add(GTK_CONTAINER(hbuttonbox2), cancel);
	GTK_WIDGET_SET_FLAGS(cancel, GTK_CAN_DEFAULT);
	gtk_widget_add_accelerator(cancel, "clicked", accel_group,
		GDK_Escape, 0, GTK_ACCEL_VISIBLE);

	gtk_signal_connect(GTK_OBJECT(declined), "activate",
		GTK_SIGNAL_FUNC(on_decline_send_clicked), conference_decline);
	gtk_signal_connect(GTK_OBJECT(send), "clicked",
		GTK_SIGNAL_FUNC(on_decline_send_clicked), conference_decline);
	gtk_signal_connect(GTK_OBJECT(cancel), "clicked",
		GTK_SIGNAL_FUNC(on_decline_cancel_clicked), conference_decline);

	gtk_widget_grab_focus(declined);
	gtk_window_add_accel_group(GTK_WINDOW(conference_decline), accel_group);

	return conference_decline;
}

static gchar *ask_for_decline_msg(void)
{
	GtkWidget *decline_window = NULL;
	GtkEntry *declined = NULL;
	gchar *reply = NULL;

	gtk_widget_show(decline_window = create_conference_decline());
	declined =
		GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(decline_window),
	 "declined"));
	gtk_entry_select_region(GTK_ENTRY(declined), 0, -1);
	gtk_window_set_modal(GTK_WINDOW(decline_window), TRUE);
	gtk_main();

	reply = gtk_object_get_data(GTK_OBJECT(decline_window), "reply");;
	if (reply)
		reply = strdup(reply);

	gtk_widget_destroy(decline_window);

	return reply;
}

static void decline(GtkWindow * window, gchar * msg)
{
	gchar _msg[] = "Thanks, but no thanks.", *conf_id = 0, *conf_host =
		0, **userarray = 0, *userlist = 0;
	int ret = 0;

	conf_id = gtk_object_get_data(GTK_OBJECT(window), "conf_id");
	conf_host = gtk_object_get_data(GTK_OBJECT(window), "inviter_id");
	userlist = gtk_object_get_data(GTK_OBJECT(window), "userlist");
	if (NULL != userlist)
		userarray =
			yahoo_list2array(gtk_object_get_data(GTK_OBJECT(window),
		"userlist"));

	if (!msg)
		msg = _msg;

	ret = yahoo_cmd_decline_conf(context, conf_id, conf_host, userarray, msg);
	yahoo_arraykill(userarray);
	g_message("Saying no with \"%s\" returned %d", msg, ret);
}

static void close_conference_invitation(GtkWindow * window)
{
	gchar *conf_id = NULL, *inviter_id = NULL;

	conf_id = gtk_object_get_data(GTK_OBJECT(window), "conf_id");
	inviter_id = gtk_object_get_data(GTK_OBJECT(window), "inviter_id");

	if (conf_id)
		free(conf_id);

	if (inviter_id)
		free(inviter_id);

	gtk_widget_destroy(GTK_WIDGET(window));
}

static void on_join_clicked(GtkButton * button, gpointer window)
{
	int ret = 0;
	char *conf_id = NULL, *host = NULL, *userlist = NULL, **userarray = NULL;

	conf_id = strdup(gtk_object_get_data(GTK_OBJECT(window), "conf_id"));
	host = strdup(gtk_object_get_data(GTK_OBJECT(window), "inviter_id"));
	userlist = gtk_object_get_data(GTK_OBJECT(window), "userlist");
	if (NULL != userlist)
	{
		userarray =
			yahoo_list2array(gtk_object_get_data(GTK_OBJECT(window),
		"userlist"));
		free(userlist);
		userlist = NULL;
	}

	close_conference_invitation(GTK_WINDOW(window));
	ret = yahoo_cmd_conf_logon(context, conf_id, host, userarray);
	(void) create_conference(conf_id, host, userarray, "joining conference");
	free(host);
}

static void on_close_clicked(GtkButton * button, gpointer window)
{
	decline(window, NULL);

	close_conference_invitation(GTK_WINDOW(window));
}

static void on_decline_clicked(GtkButton * button, gpointer window)
{
	gchar *declination = ask_for_decline_msg();

	if (declination)
	{
		decline(window, declination);

		close_conference_invitation(GTK_WINDOW(window));
	}
}

/**********************************************************************************************************************************/
/* Interface (global) functions */
/**********************************************************************************************************************************/

static GtkWidget *field_invitation(struct yahoo_packet *pkt)
{
	GtkWidget *conference_invitation;
	GtkWidget *vbox1;
	GtkWidget *who_bx;
	GtkWidget *to_bx;
	GtkWidget *to_lbl;
	GtkWidget *to_scr;
	GtkWidget *to;
	GtkWidget *from_bx;
	GtkWidget *from_lbl;
	GtkWidget *from_scr;
	GtkWidget *from;
	GtkWidget *message_scr;
	GtkWidget *message;
	GtkWidget *button_bx;
	GtkWidget *join;
	GtkWidget *decline;
	GtkWidget *close;
	GtkAccelGroup *accel_group;

	accel_group = gtk_accel_group_new();

	conference_invitation = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data(GTK_OBJECT(conference_invitation),
		"conference_invitation", conference_invitation);
	gtk_window_set_title(GTK_WINDOW(conference_invitation),
		_("Conference Invitation"));

	vbox1 = gtk_vbox_new(FALSE, 0);
	gtk_widget_ref(vbox1);
	gtk_object_set_data_full(GTK_OBJECT(conference_invitation), "vbox1",
		vbox1, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(vbox1);
	gtk_container_add(GTK_CONTAINER(conference_invitation), vbox1);

	who_bx = gtk_vbox_new(FALSE, 0);
	gtk_widget_ref(who_bx);
	gtk_object_set_data_full(GTK_OBJECT(conference_invitation), "who_bx",
		who_bx, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(who_bx);
	gtk_box_pack_start(GTK_BOX(vbox1), who_bx, TRUE, TRUE, 0);

	to_bx = gtk_hbox_new(FALSE, 0);
	gtk_widget_ref(to_bx);
	gtk_object_set_data_full(GTK_OBJECT(conference_invitation), "to_bx",
		to_bx, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(to_bx);
	gtk_box_pack_start(GTK_BOX(who_bx), to_bx, TRUE, TRUE, 0);

	to_lbl = gtk_label_new(_("To:"));
	gtk_widget_ref(to_lbl);
	gtk_object_set_data_full(GTK_OBJECT(conference_invitation), "to_lbl",
		to_lbl, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(to_lbl);
	gtk_box_pack_start(GTK_BOX(to_bx), to_lbl, FALSE, FALSE, 0);
	gtk_widget_set_usize(to_lbl, -2, 20);

	to_scr = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_ref(to_scr);
	gtk_object_set_data_full(GTK_OBJECT(conference_invitation), "to_scr",
		to_scr, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(to_scr);
	gtk_box_pack_start(GTK_BOX(to_bx), to_scr, TRUE, TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(to_scr), 2);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(to_scr),
		GTK_POLICY_NEVER, GTK_POLICY_NEVER);

	to = gtk_text_new(NULL, NULL);
	gtk_widget_ref(to);
	gtk_object_set_data_full(GTK_OBJECT(conference_invitation), "to", to,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(to);
	gtk_container_add(GTK_CONTAINER(to_scr), to);
	gtk_widget_set_usize(to, 100, 20);
	gtk_widget_set_sensitive(to, FALSE);
	GTK_WIDGET_UNSET_FLAGS(to, GTK_CAN_FOCUS);

	from_bx = gtk_hbox_new(FALSE, 0);
	gtk_widget_ref(from_bx);
	gtk_object_set_data_full(GTK_OBJECT(conference_invitation), "from_bx",
		from_bx, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(from_bx);
	gtk_box_pack_start(GTK_BOX(who_bx), from_bx, TRUE, TRUE, 0);

	from_lbl = gtk_label_new(_("From"));
	gtk_widget_ref(from_lbl);
	gtk_object_set_data_full(GTK_OBJECT(conference_invitation), "from_lbl",
		from_lbl, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(from_lbl);
	gtk_box_pack_start(GTK_BOX(from_bx), from_lbl, FALSE, FALSE, 0);
	gtk_widget_set_usize(from_lbl, -2, 20);

	from_scr = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_ref(from_scr);
	gtk_object_set_data_full(GTK_OBJECT(conference_invitation), "from_scr",
		from_scr, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(from_scr);
	gtk_box_pack_start(GTK_BOX(from_bx), from_scr, TRUE, TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(from_scr), 2);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(from_scr),
		GTK_POLICY_NEVER, GTK_POLICY_NEVER);

	from = gtk_text_new(NULL, NULL);
	gtk_widget_ref(from);
	gtk_object_set_data_full(GTK_OBJECT(conference_invitation), "from", from,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(from);
	gtk_container_add(GTK_CONTAINER(from_scr), from);
	gtk_widget_set_usize(from, 100, 20);
	gtk_widget_set_sensitive(from, FALSE);
	GTK_WIDGET_UNSET_FLAGS(from, GTK_CAN_FOCUS);

	message_scr = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_ref(message_scr);
	gtk_object_set_data_full(GTK_OBJECT(conference_invitation), "message_scr",
		message_scr, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(message_scr);
	gtk_box_pack_start(GTK_BOX(vbox1), message_scr, TRUE, TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(message_scr), 2);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(message_scr),
		GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

	message = gtk_text_new(NULL, NULL);
	gtk_widget_ref(message);
	gtk_object_set_data_full(GTK_OBJECT(conference_invitation), "message",
		message, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(message);
	gtk_container_add(GTK_CONTAINER(message_scr), message);
	gtk_widget_set_sensitive(message, FALSE);
	GTK_WIDGET_UNSET_FLAGS(message, GTK_CAN_FOCUS);

	button_bx = gtk_hbutton_box_new();
	gtk_widget_ref(button_bx);
	gtk_object_set_data_full(GTK_OBJECT(conference_invitation), "button_bx",
		button_bx, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(button_bx);
	gtk_box_pack_start(GTK_BOX(vbox1), button_bx, TRUE, TRUE, 0);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(button_bx),
		GTK_BUTTONBOX_SPREAD);

	join = gtk_button_new_with_label(_("Join"));
	gtk_widget_ref(join);
	gtk_object_set_data_full(GTK_OBJECT(conference_invitation), "join", join,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(join);
	gtk_widget_grab_focus(join);
	gtk_container_add(GTK_CONTAINER(button_bx), join);
	GTK_WIDGET_SET_FLAGS(join, GTK_CAN_DEFAULT);

	decline = gtk_button_new_with_label(_("Decline"));
	gtk_widget_ref(decline);
	gtk_object_set_data_full(GTK_OBJECT(conference_invitation), "decline",
		decline, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(decline);
	gtk_container_add(GTK_CONTAINER(button_bx), decline);
	GTK_WIDGET_SET_FLAGS(decline, GTK_CAN_DEFAULT);

	close = gtk_button_new_with_label(_("Close"));
	gtk_widget_ref(close);
	gtk_object_set_data_full(GTK_OBJECT(conference_invitation), "close",
		close, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(close);
	gtk_container_add(GTK_CONTAINER(button_bx), close);
	GTK_WIDGET_SET_FLAGS(close, GTK_CAN_DEFAULT);
	gtk_widget_add_accelerator(close, "clicked", accel_group,
		GDK_Escape, 0, GTK_ACCEL_VISIBLE);

	gtk_signal_connect(GTK_OBJECT(decline), "clicked",
		GTK_SIGNAL_FUNC(on_decline_clicked), conference_invitation);
	gtk_signal_connect(GTK_OBJECT(close), "clicked",
		GTK_SIGNAL_FUNC(on_close_clicked), conference_invitation);
	gtk_signal_connect(GTK_OBJECT(join), "clicked",
		GTK_SIGNAL_FUNC(on_join_clicked), conference_invitation);

	gtk_window_add_accel_group(GTK_WINDOW(conference_invitation),
		accel_group);

	if (NULL != pkt->conf_id)
		gtk_object_set_data(GTK_OBJECT(conference_invitation), "conf_id",
			strdup(pkt->conf_id));
	if (NULL != pkt->conf_host)
	{
		gtk_object_set_data(GTK_OBJECT(conference_invitation), "inviter_id",
			strdup(pkt->conf_host));
		gtk_text_insert(GTK_TEXT(from), NULL, NULL, NULL, pkt->conf_host,
			strlen(pkt->conf_host));
	}
	else
	{
		if (NULL != pkt->conf_inviter)
		{
			gtk_object_set_data(GTK_OBJECT(conference_invitation),
				"inviter_id", strdup(pkt->conf_inviter));
			gtk_text_insert(GTK_TEXT(from), NULL, NULL, NULL,
				pkt->conf_inviter, strlen(pkt->conf_inviter));
		}
	}
	if (NULL != pkt->conf_userlist)
	{
		gtk_object_set_data(GTK_OBJECT(conference_invitation), "userlist",
			yahoo_array2list(pkt->conf_userlist));
	}

	gtk_text_insert(GTK_TEXT(to), NULL, NULL, NULL, pkt->active_id,
		strlen(pkt->active_id));
	gtk_text_insert(GTK_TEXT(message), NULL, NULL, NULL, pkt->conf_msg,
		strlen(pkt->conf_msg));
	gtk_widget_show(GTK_WIDGET(conference_invitation));

	return conference_invitation;
}

GtkWidget *conference_field_invitation(struct yahoo_packet * pkt)
{
	char **identity = 0;

	if (0 == pkt->conf_user)
	{
		g_message("conf_user = NULL ergo the invitation is for me!");
		return field_invitation(pkt);
	}

	g_message("Checking identities against user at address 0x%p",
		pkt->conf_user);
	g_message("Checking identities against user \"%s\"", pkt->conf_user);
	for (identity = context->identities; 0 != *identity; ++identity)
	{
		g_message("Checking identity at address 0x%p", *identity);
		g_message("Checking identity \"%s\"", *identity);
		if (0 == strcmp(*identity, pkt->conf_user))
		{
			g_message("You (as \"%s\") have been invited into a conference!",
				*identity);
			return field_invitation(pkt);
		}
	}

	g_message
		("You've recived an invitation request that was sent to user \"%s\"",
		pkt->conf_user);
	return (GtkWidget *) 0;
}
