/*
 * Copyright (C) 1998 Nathan Neulinger <nneul@umr.edu>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include "gtkyahoo.h"

struct gtkyahoo_custom_window
{
	GtkWidget *window;
	GtkWidget *table;
	GtkWidget *entry_msg;
	GtkWidget *button;
};

char *auto_custom_message;

/* Destroy a custom window */
void delete_custom_window(GtkWidget * widget,
	GdkEvent * event, gpointer * data)
{
	struct gtkyahoo_custom_window *arw;

	arw = (struct gtkyahoo_custom_window *) data;
	gtk_widget_destroy(GTK_WIDGET(arw->window));
	free(arw);
}

/* Start a chat session from custom window */
void custom_callback(GtkWidget * widget, gpointer * data)
{
	char *msg;
	struct gtkyahoo_custom_window *arw;

	/* get the window */
	arw = (struct gtkyahoo_custom_window *) data;
	msg = strdup(gtk_entry_get_text(GTK_ENTRY(arw->entry_msg)));

	/* get rid of the window since not needed */
	delete_custom_window(NULL, NULL, data);

	/* Store the new parameters */
	if (auto_custom_message)
	{
		free(auto_custom_message);
	}
	if (NULL != last_custom_msg)
	    free (last_custom_msg);
	last_custom_msg = auto_custom_message = msg;

	yahoo_cmd_set_away_mode(context, YAHOO_STATUS_CUSTOM, msg);
	last_sent_status = YAHOO_STATUS_CUSTOM;
	last_user_status = YAHOO_STATUS_CUSTOM;
	gtkyahoo_userlist_refresh();
	have_user_activity();
	gtk_main_quit ();

}

/* Call the delete function */
void callback_cancel_custom(GtkWidget * widget, gpointer data)
{
	delete_custom_window(NULL, NULL, data);
	gtk_main_quit ();
}

/* Create a custom window */
void create_custom_window(void)
{
	struct gtkyahoo_custom_window *arw;

//        char *msg;

	/* Allocate local structure */
	arw = (struct gtkyahoo_custom_window *) malloc(sizeof(*arw));

	/* Create main window */
	arw->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	/* I wanted the custom window to appear about the middle of my screen,
	 * todo: find out the user's root window size instead
	gtk_widget_set_uposition(arw->window, 1024/2 - 50, 768/2 - 30);
	 */
	gtk_window_set_title(GTK_WINDOW(arw->window), "GTKYahoo: Custom Status");
	gtk_container_border_width(GTK_CONTAINER(arw->window), 5);
	gtk_widget_realize(arw->window);

	/* Trap delete_event signal */
	gtk_signal_connect(GTK_OBJECT(arw->window), "delete_event",
		GTK_SIGNAL_FUNC(delete_custom_window), (gpointer) arw);

	/* Create the table */
	arw->table = gtk_table_new(2, 2, FALSE);
	gtk_widget_show(arw->table);
	gtk_container_add(GTK_CONTAINER(arw->window), arw->table);

	/* Create the message entry */
	arw->entry_msg = gtk_entry_new_with_max_length(255);
	gtk_table_attach(GTK_TABLE(arw->table), arw->entry_msg, 0, 2, 0, 1,
		GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 2, 2);
	if (auto_custom_message)
	{
		gtk_entry_set_text(GTK_ENTRY(arw->entry_msg), auto_custom_message);
		gtk_entry_select_region(GTK_ENTRY(arw->entry_msg), 
						0, GTK_ENTRY(arw->entry_msg)->text_length);
	}
	gtk_widget_show(arw->entry_msg);
	gtk_widget_grab_focus(arw->entry_msg);

	gtk_signal_connect(GTK_OBJECT(arw->entry_msg), "activate",
		GTK_SIGNAL_FUNC(custom_callback), (gpointer) arw);

	/* Create the cancel button */
	arw->button = gtk_button_new_with_label("Cancel");
	gtk_table_attach(GTK_TABLE(arw->table), arw->button, 0, 1, 1, 2,
		GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 2, 2);
	gtk_widget_show(arw->button);
	gtk_signal_connect(GTK_OBJECT(arw->button), "clicked",
		GTK_SIGNAL_FUNC(callback_cancel_custom), (gpointer) arw);

	/* Create the ok button */
	arw->button = gtk_button_new_with_label("Configure Custom Status");
	gtk_table_attach(GTK_TABLE(arw->table), arw->button, 1, 2, 1, 2,
		GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 2, 2);
	gtk_widget_show(arw->button);
	gtk_signal_connect(GTK_OBJECT(arw->button), "clicked",
		GTK_SIGNAL_FUNC(custom_callback), (gpointer) arw);

/*my code is here

	msg = strdup(gtk_entry_get_text(GTK_ENTRY(arw->entry_msg)));
	yahoo_cmd_set_away_mode(context, YAHOO_STATUS_CUSTOM, msg);
	last_sent_status=YAHOO_STATUS_CUSTOM;
	last_user_status=YAHOO_STATUS_CUSTOM;
	have_user_activity();
*/
	gtk_widget_show(arw->window);
	gtk_main ();
	return;
}

void handle_custom(struct yahoo_packet *pkt)
{
	char *tmpmsg;
	struct gtkyahoo_chat_window *cw;

	if (!pkt || !pkt->msg)
	{
		printf("Error: custom got null pkt or msg\n");
		return;
	}

	//if (!auto_custom)
	//{
	//  /* custom not enabled */
	//  return;
	//}

	if (strstr(pkt->msg, "<Auto-Reply>"))
	{
		/* never custom to an custom message */
		return;
	}

	if (!auto_custom_message)
	{
		auto_custom_message = strdup("I'm not here.");
	}

	/* build the message */
	tmpmsg = (char *) malloc(strlen(auto_custom_message) + 40);
	if (!tmpmsg)
	{
		exit(1);
	}
	strcpy(tmpmsg, YAHOO_COLOR_RED "<Auto-Reply> " YAHOO_COLOR_BLACK);
	strcat(tmpmsg, auto_custom_message);

	/* actually send the message and add the note to the chat window */
	cw = get_chat_window(pkt->active_id, pkt->msg_id);
	gdk_window_raise(cw->window->window);

	have_user_activity();
	yahoo_cmd_msg(context, pkt->active_id, pkt->msg_id, tmpmsg);
	append_chat_msg(cw, NULL, YAHOO_COLOR_RED "<Auto-Reply Sent>");

	/* Free the temporary message */
	free(tmpmsg);

	/* Grab focus */
	gtk_widget_grab_focus(cw->entry);
}

