/*
 * Copyright (C) 1998 Nathan Neulinger <nneul@umr.edu>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include "gtkyahoo.h"

/* Start a chat session from sendraw window */
void sendraw_callback(GtkWidget * widget, gpointer * data)
{
	int service;
	int i;
	char *active_id, *content;
	struct gtkyahoo_sendraw_window *srw;

	/* get the window */
	srw = (struct gtkyahoo_sendraw_window *) data;

	/* get the info from the window */
	service = atoi(gtk_entry_get_text(GTK_ENTRY(srw->entry_service)));
	active_id =
		strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(srw->
			combo_active_id)->entry)));
	content = strdup(gtk_entry_get_text(GTK_ENTRY(srw->entry_content)));

	/* get rid of the window since not needed */
	delete_sendraw_window(NULL, NULL, data);

	printf("\n");
	printf("Handle SendRaw: Service=%d\n", service);
	printf("Handle SendRaw: ActiveID=%s\n", active_id);
	printf("Handle SendRaw: Content=%s\n", content);

	/* Turn ^ into ^B */
	for (i = 0; i < strlen(content); i++)
	{
		if (content[i] == '^')
			content[i] = 2;
		if (content[i] == '|')
			content[i] = 1;
	}

	/* send the message and add it to the window */
	have_user_activity();
	yahoo_sendcmd(context, service, active_id, content, 0);

	/* free the temporary variables */
	free(active_id);
	free(content);
}

/* Destroy a sendraw window */
void delete_sendraw_window(GtkWidget * widget,
	GdkEvent * event, gpointer * data)
{
	struct gtkyahoo_sendraw_window *srw;

	srw = (struct gtkyahoo_sendraw_window *) data;
	gtk_widget_destroy(GTK_WIDGET(srw->window));
	free(srw);
}

/* Call the delete function */
void callback_cancel_sendraw(GtkWidget * widget, gpointer data)
{
	delete_sendraw_window(NULL, NULL, data);
}

/* Create a sendraw window */
void create_sendraw_window(void)
{
	struct gtkyahoo_sendraw_window *srw;

	/* Allocate local structure */
	srw = (struct gtkyahoo_sendraw_window *) malloc(sizeof(*srw));

	/* Create main window */
	srw->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(srw->window),
		"GTKYahoo: Send Raw Packet");
	gtk_container_border_width(GTK_CONTAINER(srw->window), 5);
	gtk_widget_realize(srw->window);

	/* Trap delete_event signal */
	gtk_signal_connect(GTK_OBJECT(srw->window), "delete_event",
		GTK_SIGNAL_FUNC(delete_sendraw_window), (gpointer) srw);

	/* add the table */
	srw->table = gtk_table_new(4, 2, FALSE);
	gtk_widget_show(srw->table);
	gtk_container_add(GTK_CONTAINER(srw->window), srw->table);

	/* Create the add-from entry and label */
	srw->label_service = gtk_label_new("Service Number:");
	gtk_misc_set_alignment(GTK_MISC(srw->label_service), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(srw->table), srw->label_service, 0, 1, 0, 1,
		GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(srw->label_service);

	srw->entry_service = gtk_entry_new_with_max_length(40);
	gtk_table_attach(GTK_TABLE(srw->table), srw->entry_service, 1, 2, 0, 1,
		GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
	gtk_widget_show(srw->entry_service);

	/* Create the add-from entry and label */
	srw->label_active_id = gtk_label_new("Active ID:");
	gtk_misc_set_alignment(GTK_MISC(srw->label_active_id), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(srw->table), srw->label_active_id, 0, 1, 1, 2,
		GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(srw->label_active_id);

	srw->combo_active_id = create_combo_identities(current_user, FALSE);
	gtk_table_attach(GTK_TABLE(srw->table), srw->combo_active_id, 1, 2, 1, 2,
		GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
	gtk_widget_show(srw->combo_active_id);

	/* Create the add-from entry and label */
	srw->label_content = gtk_label_new("Content (| is ^A, ^ is ^B):");
	gtk_misc_set_alignment(GTK_MISC(srw->label_content), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(srw->table), srw->label_content, 0, 1, 2, 3,
		GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(srw->label_content);

	srw->entry_content = gtk_entry_new_with_max_length(250);
	gtk_table_attach(GTK_TABLE(srw->table), srw->entry_content, 1, 2, 2, 3,
		GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
	gtk_widget_show(srw->entry_content);

	gtk_signal_connect(GTK_OBJECT(srw->entry_content), "activate",
		GTK_SIGNAL_FUNC(sendraw_callback), (gpointer) srw);

	/* hbox for cancel and send buttons */
	srw->hbox = gtk_hbox_new(TRUE, 2);
	gtk_widget_show(srw->hbox);

	gtk_table_attach(GTK_TABLE(srw->table), srw->hbox, 1, 2, 3, 4,
		GTK_FILL, GTK_FILL, 2, 2);

	/* Create the send raw button */
	srw->button = gtk_button_new();
	gtk_box_pack_end(GTK_BOX(srw->hbox), srw->button, FALSE, TRUE, 2);
	gtk_widget_show(srw->button);
	gtk_signal_connect(GTK_OBJECT(srw->button), "clicked",
		GTK_SIGNAL_FUNC(sendraw_callback), (gpointer) srw);
	gtk_container_add(GTK_CONTAINER(srw->button),
		xpm_label_box(srw->window, pixmapdata_send, "Send"));

	/* Create the cancel button */
	srw->button = gtk_button_new();
	gtk_box_pack_end(GTK_BOX(srw->hbox), srw->button, FALSE, TRUE, 2);
	gtk_widget_show(srw->button);
	gtk_signal_connect(GTK_OBJECT(srw->button), "clicked",
		GTK_SIGNAL_FUNC(callback_cancel_sendraw), (gpointer) srw);
	gtk_container_add(GTK_CONTAINER(srw->button),
		xpm_label_box(srw->window, pixmapdata_cancel, "Cancel"));

	gtk_widget_show(srw->window);
	return;
}
