/*
 * Copyright (C) 1998 Nathan Neulinger <nneul@umr.edu>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include "gtkyahoo.h"

/* another callback */
void delete_recvfile_window(GtkWidget * widget,
	GdkEvent * event, gpointer * data)
{
	struct gtkyahoo_recvfile_window *tmprfw;

	tmprfw = (struct gtkyahoo_recvfile_window *) data;

	/* Destroy/free all the window elements */
	gtk_widget_destroy(GTK_WIDGET(tmprfw->window));

	free(tmprfw);
}

/* another callback */
void handle_recvfile_window_recv(gpointer * data)
{
	struct gtkyahoo_recvfile_window *tmprfw;

	tmprfw = (struct gtkyahoo_recvfile_window *) data;

	/* Destroy/free all the window elements */
	gtk_widget_destroy(GTK_WIDGET(tmprfw->window));

	/* tell browser to retrieve file */
	if (tmprfw->url)
	{
		launch_browser(tmprfw->url);
		free(tmprfw->url);
		tmprfw->url = NULL;
	}
	free(tmprfw);
}

/* create a recvfile event window */
/* Create a chat window */
struct gtkyahoo_recvfile_window *create_recvfile_window(struct yahoo_packet
	*pkt)
{
	struct gtkyahoo_recvfile_window *rfw;

	/* Allocate local structure */
	rfw = (struct gtkyahoo_recvfile_window *) calloc(1, sizeof(*rfw));

	/* Create main window */
	rfw->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(rfw->window),
		"File Transfer - Receive File");
	gtk_container_border_width(GTK_CONTAINER(rfw->window), 5);
	gtk_widget_realize(rfw->window);

	/* Trap delete_event signal */
	gtk_signal_connect(GTK_OBJECT(rfw->window), "delete_event",
		GTK_SIGNAL_FUNC(delete_recvfile_window), (gpointer) rfw);

	rfw->box_window = gtk_vbox_new(FALSE, 0);
	rfw->box_text = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(rfw->box_window);
	gtk_widget_show(rfw->box_text);

	/* build the full window box */
	gtk_container_add(GTK_CONTAINER(rfw->window), rfw->box_window);

	/* create the first label */
	rfw->label_from = gtk_label_new(pkt->file_from);
	gtk_widget_show(rfw->label_from);
	gtk_box_pack_start(GTK_BOX(rfw->box_window),
		rfw->label_from, TRUE, TRUE, 5);

	rfw->label_to = gtk_label_new(pkt->active_id);
	gtk_widget_show(rfw->label_to);
	gtk_box_pack_start(GTK_BOX(rfw->box_window),
		rfw->label_to, TRUE, TRUE, 5);

	rfw->url = strdup(pkt->file_url);

	rfw->label_url = gtk_label_new(pkt->file_url);
	gtk_widget_show(rfw->label_url);
	gtk_box_pack_start(GTK_BOX(rfw->box_window),
		rfw->label_url, TRUE, TRUE, 5);

	rfw->label_timestamp = gtk_label_new("fill in later");
	gtk_widget_show(rfw->label_timestamp);
	gtk_box_pack_start(GTK_BOX(rfw->box_window),
		rfw->label_timestamp, TRUE, TRUE, 5);

	/* pack the box for the text area and scrollbar */
	gtk_box_pack_start(GTK_BOX(rfw->box_window), rfw->box_text, TRUE, TRUE,
		5);

	/* create a text box */
	rfw->textbox = gtk_text_new(NULL, NULL);
	gtk_box_pack_start(GTK_BOX(rfw->box_text), rfw->textbox, TRUE, TRUE, 0);
	gtk_widget_show(rfw->textbox);

	/* Make the text box scrollable */
	rfw->scroll = gtk_vscrollbar_new(GTK_TEXT(rfw->textbox)->vadj);
	gtk_box_pack_start(GTK_BOX(rfw->box_text), rfw->scroll, FALSE, FALSE, 0);
	gtk_widget_show(rfw->scroll);

	/* put the packets content into the text box */
	append_to_textbox(rfw->window, rfw->textbox, pkt->file_description);

	/* create the view-event button */
	rfw->button_receive = gtk_button_new();
	gtk_box_pack_start(GTK_BOX(rfw->box_window), rfw->button_receive,
		FALSE, TRUE, 0);
	gtk_widget_show(rfw->button_receive);

	/* let the user click to download the file */
	gtk_signal_connect_object(GTK_OBJECT(rfw->button_receive), "clicked",
		GTK_SIGNAL_FUNC(handle_recvfile_window_recv), (gpointer) rfw);
	gtk_container_add(GTK_CONTAINER(rfw->button_receive),
		xpm_label_box(rfw->window, pixmapdata_send, "Receive File"));

	gtk_widget_show(rfw->window);
	return rfw;
}
