/*
 * Copyright (C) 1998 Nathan Neulinger <nneul@umr.edu>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include "gtkyahoo.h"

void delete_removefriend_window(GtkWidget * widget,
	GdkEvent * event, gpointer * data)
{
	struct gtkyahoo_removefriend_window *rfw;

	rfw = (struct gtkyahoo_removefriend_window *) data;

	gtk_widget_destroy(GTK_WIDGET(rfw->window));
	free(rfw);
}

void removefriend_callback(GtkWidget * widget, gpointer * data)
{
	char *active_id, *id, *group, *msg;
	struct gtkyahoo_removefriend_window *rfw;

	rfw = (struct gtkyahoo_removefriend_window *) data;

	active_id =
		strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(rfw->
			combo_active_id)->entry)));
	id = strdup(gtk_entry_get_text(GTK_ENTRY(rfw->entry_id)));
	group =
		strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(rfw->
				combo_group)->entry)));
	msg = strdup(gtk_entry_get_text(GTK_ENTRY(rfw->entry_msg)));

//  printf("*** Add_Friend(%s) to (%s) by (%s): (%s)\n", id, group, 
	//      active_id, msg);

	if (!strcmp(group, ""))
	{
		free(group);
		group = strdup("Misc");
	}

	yahoo_remove_buddy(context, id, active_id, group, msg);

	/* Add the user to the user list, even though the add might not have */
	/* been successful */
	gtkyahoo_userlist_update(id);

	/* Trigger a user status update so the user will be added to the window */
	/* seems that some user adds show up automatically, others don't */
	/* perhaps only if the remote user is logged on */
	have_user_activity();
	yahoo_cmd_user_status(context);

	/* Clean up the window */
	delete_removefriend_window(NULL, NULL, data);

	/* Clean up temp */
	free(active_id);
	free(id);
	free(group);
	free(msg);
}

void callback_cancel_removefriend(GtkWidget * widget, gpointer data)
{
	delete_removefriend_window(NULL, NULL, data);
}

void create_removefriend_window(void)
{
	struct gtkyahoo_removefriend_window *rfw;

	/* Allocate local structure */
	rfw = (struct gtkyahoo_removefriend_window *) malloc(sizeof(*rfw));

	/* Create main window */
	rfw->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(rfw->window), "GTKYahoo: Remove Friend");
	gtk_container_border_width(GTK_CONTAINER(rfw->window), 5);
	gtk_widget_realize(rfw->window);

	/* Trap delete_event signal */
	gtk_signal_connect(GTK_OBJECT(rfw->window), "delete_event",
		GTK_SIGNAL_FUNC(delete_removefriend_window), (gpointer) rfw);

	/* Create table */
	rfw->table = gtk_table_new(5, 2, FALSE);
	gtk_widget_show(rfw->table);
	gtk_container_add(GTK_CONTAINER(rfw->window), rfw->table);

	/* Create the add-from entry and label */
	rfw->label_active_id = gtk_label_new("Remove as:");
	gtk_misc_set_alignment(GTK_MISC(rfw->label_active_id), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(rfw->table), rfw->label_active_id, 0, 1, 0, 1,
		GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(rfw->label_active_id);

	rfw->combo_active_id = create_combo_identities(current_user, FALSE);
	gtk_table_attach(GTK_TABLE(rfw->table), rfw->combo_active_id, 1, 2, 0, 1,
		GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
	gtk_widget_show(rfw->combo_active_id);

	/* Create the add-from entry and label */
	rfw->label_id = gtk_label_new("User to Remove:");
	gtk_misc_set_alignment(GTK_MISC(rfw->label_id), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(rfw->table), rfw->label_id, 0, 1, 1, 2,
		GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(rfw->label_id);

	rfw->entry_id = gtk_entry_new_with_max_length(40);
	gtk_table_attach(GTK_TABLE(rfw->table), rfw->entry_id, 1, 2, 1, 2,
		GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
	gtk_widget_show(rfw->entry_id);
	gtk_widget_grab_focus(rfw->entry_id);

	/* Create the add-from entry and label */
	rfw->label_group = gtk_label_new("Group:");
	gtk_misc_set_alignment(GTK_MISC(rfw->label_group), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(rfw->table), rfw->label_group, 0, 1, 2, 3,
		GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(rfw->label_group);

	if (user_selected)
	{
		rfw->combo_group = create_combo_groups(user_selected->group, TRUE);
		gtk_entry_set_text(GTK_ENTRY(rfw->entry_id), user_selected->id);
	}
	else
	{
		rfw->combo_group = create_combo_groups(NULL, TRUE);
	}
	gtk_table_attach(GTK_TABLE(rfw->table), rfw->combo_group, 1, 2, 2, 3,
		GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
	gtk_widget_show(rfw->combo_group);
	gtk_widget_grab_focus(rfw->combo_group);

	/* Create the add-from entry and label */
	rfw->label_msg = gtk_label_new("Message:");
	gtk_misc_set_alignment(GTK_MISC(rfw->label_msg), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(rfw->table), rfw->label_msg, 0, 1, 3, 4,
		GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(rfw->label_msg);

	rfw->entry_msg = gtk_entry_new_with_max_length(100);
	gtk_table_attach(GTK_TABLE(rfw->table), rfw->entry_msg, 1, 2, 3, 4,
		GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
	gtk_widget_show(rfw->entry_msg);
	gtk_widget_grab_focus(rfw->entry_msg);

	/* hbox for cancel/send buttons */
	rfw->hbox = gtk_hbox_new(TRUE, 2);
	gtk_widget_show(rfw->hbox);

	gtk_table_attach(GTK_TABLE(rfw->table), rfw->hbox, 1, 2, 4, 5,
		GTK_FILL, GTK_FILL, 2, 2);

	/* Create the send button */
	rfw->button = gtk_button_new();
	gtk_box_pack_end(GTK_BOX(rfw->hbox), rfw->button, FALSE, TRUE, 2);
	gtk_widget_show(rfw->button);
	gtk_signal_connect(GTK_OBJECT(rfw->button), "clicked",
		GTK_SIGNAL_FUNC(removefriend_callback), (gpointer) rfw);
	gtk_container_add(GTK_CONTAINER(rfw->button),
		xpm_label_box(rfw->window, pixmapdata_send, "Remove"));

	/* Create the send button */
	rfw->button = gtk_button_new();
	gtk_box_pack_end(GTK_BOX(rfw->hbox), rfw->button, FALSE, TRUE, 2);
	gtk_widget_show(rfw->button);
	gtk_signal_connect(GTK_OBJECT(rfw->button), "clicked",
		GTK_SIGNAL_FUNC(callback_cancel_removefriend), (gpointer) rfw);
	gtk_container_add(GTK_CONTAINER(rfw->button),
		xpm_label_box(rfw->window, pixmapdata_cancel, "Cancel"));

	/* Grab focus */
	gtk_widget_show(rfw->window);
	gtk_widget_grab_focus(rfw->entry_id);
}
