/*
 * Copyright (C) 1998 Nathan Neulinger <nneul@umr.edu>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include "gtkyahoo.h"

/* Start a chat session from sendfile window */
void sendfile_callback(GtkWidget * widget, gpointer * data)
{
	char *active_id, *id, *msg, *file;
	struct gtkyahoo_sendfile_window *sfw;

	/* get the window */
	sfw = (struct gtkyahoo_sendfile_window *) data;

	/* get the info from the window */
	active_id =
		strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(sfw->
			combo_active_id)->entry)));
	id = strdup(gtk_entry_get_text(GTK_ENTRY(sfw->entry_id)));
	msg = strdup(gtk_entry_get_text(GTK_ENTRY(sfw->entry_msg)));
	file = strdup(gtk_entry_get_text(GTK_ENTRY(sfw->entry_file)));

	/* get rid of the window since not needed */
	delete_sendfile_window(NULL, NULL, data);

	/* send the message */
	have_user_activity();
	yahoo_cmd_sendfile(context, active_id, id, msg, file);

	/* free the temporary variables */
	free(active_id);
	free(id);
	free(msg);
	free(file);
}

/* Destroy a sendfile window */
void delete_sendfile_window(GtkWidget * widget,
	GdkEvent * event, gpointer * data)
{
	struct gtkyahoo_sendfile_window *sfw;

	sfw = (struct gtkyahoo_sendfile_window *) data;
	gtk_widget_destroy(GTK_WIDGET(sfw->window));
	free(sfw);
}

void callback_cancel_sendfile(GtkWidget * widget, gpointer * data)
{
	delete_sendfile_window(NULL, NULL, data);
}

/* Destroy a browse window */
void callback_sendfile_getfilename(GtkFileSelection * fs, gpointer * data)
{
	struct gtkyahoo_sendfile_window *sfw;
	char *filename;

	sfw = (struct gtkyahoo_sendfile_window *) data;

	filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(sfw->fs));
	if (filename)
	{
		gtk_entry_set_text(GTK_ENTRY(sfw->entry_file), filename);
	}
}

void callback_browse_sendfile(GtkWidget * widget, gpointer * data)
{
	struct gtkyahoo_sendfile_window *sfw =

		(struct gtkyahoo_sendfile_window *) data;

	sfw->fs = gtk_file_selection_new("Select file to send...");

	/* Set as modal */
	gtk_window_set_modal(GTK_WINDOW(sfw->fs), TRUE);

	/* And mark it as a transient dialog */
	gtk_window_set_transient_for(GTK_WINDOW(sfw->fs),
		GTK_WINDOW(sfw->window));

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(sfw->fs)->ok_button),
		"clicked", GTK_SIGNAL_FUNC
		(callback_sendfile_getfilename), (gpointer) sfw);

	gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(sfw->
				fs)->ok_button), "clicked",
		GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(sfw->fs));
	gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(sfw->
				fs)->cancel_button), "clicked",
		GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(sfw->fs));

	/* wait until destroy calls gtk_main_quit */
	gtk_widget_show(sfw->fs);
	gtk_main();

}

/* Create a sendfile window */
void create_sendfile_window(void)
{
	struct gtkyahoo_sendfile_window *sfw;

	/* Allocate local structure */
	sfw = (struct gtkyahoo_sendfile_window *) malloc(sizeof(*sfw));

	/* Create main window */
	sfw->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(sfw->window), "GTKYahoo: Send File");
	gtk_container_border_width(GTK_CONTAINER(sfw->window), 5);
	gtk_widget_realize(sfw->window);

	/* Trap delete_event signal */
	gtk_signal_connect(GTK_OBJECT(sfw->window), "delete_event",
		GTK_SIGNAL_FUNC(delete_sendfile_window), (gpointer) sfw);

	/* Create the table */
	sfw->table = gtk_table_new(5, 2, FALSE);
	gtk_widget_show(sfw->table);
	gtk_container_add(GTK_CONTAINER(sfw->window), sfw->table);

	/* Create the add-from entry and label */
	sfw->label_active_id = gtk_label_new("Send from:");
	gtk_misc_set_alignment(GTK_MISC(sfw->label_active_id), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(sfw->table), sfw->label_active_id, 0, 1, 0, 1,
		GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(sfw->label_active_id);

	sfw->combo_active_id = create_combo_identities(current_user, FALSE);
	gtk_table_attach(GTK_TABLE(sfw->table), sfw->combo_active_id, 1, 2, 0, 1,
		GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
	gtk_widget_show(sfw->combo_active_id);

	/* Create the add-from entry and label */
	sfw->label_id = gtk_label_new("Send to:");
	gtk_misc_set_alignment(GTK_MISC(sfw->label_id), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(sfw->table), sfw->label_id, 0, 1, 1, 2,
		GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(sfw->label_id);

	sfw->entry_id = gtk_entry_new_with_max_length(40);
	gtk_table_attach(GTK_TABLE(sfw->table), sfw->entry_id, 1, 2, 1, 2,
		GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
	gtk_widget_show(sfw->entry_id);

	if (user_selected)
	{
		gtk_entry_set_text(GTK_ENTRY(sfw->entry_id), user_selected->id);
	}
	else
	{
		gtk_widget_grab_focus(sfw->entry_id);
	}

	/* Create the add-from entry and label */
	sfw->label_msg = gtk_label_new("Message:");
	gtk_misc_set_alignment(GTK_MISC(sfw->label_msg), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(sfw->table), sfw->label_msg, 0, 1, 2, 3,
		GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(sfw->label_msg);

	sfw->entry_msg = gtk_entry_new_with_max_length(250);
	gtk_table_attach(GTK_TABLE(sfw->table), sfw->entry_msg, 1, 2, 2, 3,
		GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
	gtk_widget_show(sfw->entry_msg);

	if (user_selected)
	{
		gtk_widget_grab_focus(sfw->entry_msg);
	}
	gtk_signal_connect(GTK_OBJECT(sfw->entry_msg), "activate",
		GTK_SIGNAL_FUNC(sendfile_callback), (gpointer) sfw);

	/* Create the file path entry and label */
	sfw->label_file = gtk_label_new("File:");
	gtk_misc_set_alignment(GTK_MISC(sfw->label_file), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(sfw->table), sfw->label_file, 0, 1, 3, 4,
		GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(sfw->label_file);

	sfw->entry_file = gtk_entry_new_with_max_length(250);
	gtk_table_attach(GTK_TABLE(sfw->table), sfw->entry_file, 1, 2, 3, 4,
		GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
	gtk_widget_show(sfw->entry_file);

	/* Create the hbox for the start/cancel buttons */
	sfw->hbox = gtk_hbox_new(TRUE, 2);
	gtk_widget_show(sfw->hbox);

	gtk_table_attach(GTK_TABLE(sfw->table), sfw->hbox, 1, 2, 4, 5,
		GTK_FILL, GTK_FILL, 2, 2);

	/* Create the start chat button */
	sfw->button_send = gtk_button_new();
	gtk_box_pack_end(GTK_BOX(sfw->hbox), sfw->button_send, FALSE, TRUE, 2);
	gtk_widget_show(sfw->button_send);
	gtk_signal_connect(GTK_OBJECT(sfw->button_send), "clicked",
		GTK_SIGNAL_FUNC(sendfile_callback), (gpointer) sfw);
	gtk_container_add(GTK_CONTAINER(sfw->button_send),
		xpm_label_box(sfw->window, pixmapdata_send, "Send File"));

	/* Create the cancel button */
	sfw->button_send = gtk_button_new();
	gtk_box_pack_end(GTK_BOX(sfw->hbox), sfw->button_send, FALSE, TRUE, 2);
	gtk_widget_show(sfw->button_send);
	gtk_signal_connect(GTK_OBJECT(sfw->button_send), "clicked",
		GTK_SIGNAL_FUNC(callback_cancel_sendfile), (gpointer) sfw);
	gtk_container_add(GTK_CONTAINER(sfw->button_send),
		xpm_label_box(sfw->window, pixmapdata_cancel, "Cancel"));

	/* Create the browse button */
	sfw->button_browse = gtk_button_new();
	gtk_box_pack_end(GTK_BOX(sfw->hbox), sfw->button_browse, FALSE, TRUE, 2);
	gtk_widget_show(sfw->button_browse);
	gtk_signal_connect(GTK_OBJECT(sfw->button_browse), "clicked",
		GTK_SIGNAL_FUNC(callback_browse_sendfile), (gpointer) sfw);
	gtk_container_add(GTK_CONTAINER(sfw->button_browse),
		xpm_label_box(sfw->window, pixmapdata_send, "Browse..."));

	gtk_widget_show(sfw->window);
	return;
}
