/*
 * Copyright (C) 1998 Nathan Neulinger <nneul@umr.edu>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include "gtkyahoo.h"

/* Start a chat session from sendoffline window */
void sendoffline_callback(GtkWidget * widget, gpointer * data)
{
	char *active_id, *id, *msg;
	struct gtkyahoo_sendoffline_window *sow;

	/* get the window */
	sow = (struct gtkyahoo_sendoffline_window *) data;

	/* get the info from the window */
	active_id =
		strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(sow->
			combo_active_id)->entry)));
	id = strdup(gtk_entry_get_text(GTK_ENTRY(sow->entry_id)));
	msg = strdup(gtk_entry_get_text(GTK_ENTRY(sow->entry_msg)));

	/* get rid of the window since not needed */
	delete_sendoffline_window(NULL, NULL, data);

	/* send the message and add it to the window */
	yahoo_cmd_msg_offline(context, active_id, id, msg);

	/* free the temporary variables */
	free(active_id);
	free(id);
	free(msg);
}

/* Destroy a sendoffline window */
void delete_sendoffline_window(GtkWidget * widget,
	GdkEvent * event, gpointer * data)
{
	struct gtkyahoo_sendoffline_window *sow;

	sow = (struct gtkyahoo_sendoffline_window *) data;
	gtk_widget_destroy(GTK_WIDGET(sow->window));
	free(sow);
}

void callback_cancel_sendoffline(GtkWidget * widget, gpointer * data)
{
	delete_sendoffline_window(NULL, NULL, data);
}

/* Create a sendoffline window */
void create_sendoffline_window(char *to, char *from, char *msg)
{
	struct gtkyahoo_sendoffline_window *sow;

	/* Allocate local structure */
	sow = (struct gtkyahoo_sendoffline_window *) malloc(sizeof(*sow));

	/* Create main window */
	sow->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(sow->window),
		"GTKYahoo: Send Offline Message");
	gtk_container_border_width(GTK_CONTAINER(sow->window), 5);
	gtk_widget_realize(sow->window);

	/* Trap delete_event signal */
	gtk_signal_connect(GTK_OBJECT(sow->window), "delete_event",
		GTK_SIGNAL_FUNC(delete_sendoffline_window), (gpointer) sow);

	/* Create the table */
	sow->table = gtk_table_new(4, 2, FALSE);
	gtk_widget_show(sow->table);
	gtk_container_add(GTK_CONTAINER(sow->window), sow->table);

	/* Create the add-from entry and label */
	sow->label_active_id = gtk_label_new("Message from:");
	gtk_misc_set_alignment(GTK_MISC(sow->label_active_id), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(sow->table), sow->label_active_id, 0, 1, 0, 1,
		GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(sow->label_active_id);

	if (from)
	{
		sow->combo_active_id = create_combo_identities(from, FALSE);
	}
	else
	{
		sow->combo_active_id = create_combo_identities(current_user, FALSE);
	}
	gtk_table_attach(GTK_TABLE(sow->table), sow->combo_active_id, 1, 2, 0, 1,
		GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
	gtk_widget_show(sow->combo_active_id);

	/* Create the add-from entry and label */
	sow->label_id = gtk_label_new("Message to:");
	gtk_misc_set_alignment(GTK_MISC(sow->label_id), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(sow->table), sow->label_id, 0, 1, 1, 2,
		GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(sow->label_id);

	sow->entry_id = gtk_entry_new_with_max_length(40);
	gtk_table_attach(GTK_TABLE(sow->table), sow->entry_id, 1, 2, 1, 2,
		GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
	gtk_widget_show(sow->entry_id);

	if (to)
	{
		gtk_entry_set_text(GTK_ENTRY(sow->entry_id), to);
	}
	else if (user_selected && user_selected->id)
	{
		gtk_entry_set_text(GTK_ENTRY(sow->entry_id), user_selected->id);
	}
	else
	{
		gtk_widget_grab_focus(sow->entry_id);
	}

	/* Create the add-from entry and label */
	sow->label_msg = gtk_label_new("Message:");
	gtk_misc_set_alignment(GTK_MISC(sow->label_msg), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(sow->table), sow->label_msg, 0, 1, 2, 3,
		GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(sow->label_msg);

	sow->entry_msg = gtk_entry_new_with_max_length(250);
	gtk_table_attach(GTK_TABLE(sow->table), sow->entry_msg, 1, 2, 2, 3,
		GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
	gtk_widget_show(sow->entry_msg);

	if (user_selected || (to && msg))
	{
		gtk_widget_grab_focus(sow->entry_msg);
	}

	if (msg)
	{
		gtk_entry_set_text(GTK_ENTRY(sow->entry_msg), msg);
	}
	gtk_signal_connect(GTK_OBJECT(sow->entry_msg), "activate",
		GTK_SIGNAL_FUNC(sendoffline_callback), (gpointer) sow);

	/* Create the hbox for the start/cancel buttons */
	sow->hbox = gtk_hbox_new(TRUE, 2);
	gtk_widget_show(sow->hbox);

	gtk_table_attach(GTK_TABLE(sow->table), sow->hbox, 1, 2, 3, 4,
		GTK_FILL, GTK_FILL, 2, 2);

	/* Create the start chat button */
	sow->button = gtk_button_new();
	gtk_box_pack_end(GTK_BOX(sow->hbox), sow->button, FALSE, TRUE, 2);
	gtk_widget_show(sow->button);
	gtk_signal_connect(GTK_OBJECT(sow->button), "clicked",
		GTK_SIGNAL_FUNC(sendoffline_callback), (gpointer) sow);
	gtk_container_add(GTK_CONTAINER(sow->button),
		xpm_label_box(sow->window, pixmapdata_send, "Send Message"));

	/* Create the cancel button */
	sow->button = gtk_button_new();
	gtk_box_pack_end(GTK_BOX(sow->hbox), sow->button, FALSE, TRUE, 2);
	gtk_widget_show(sow->button);
	gtk_signal_connect(GTK_OBJECT(sow->button), "clicked",
		GTK_SIGNAL_FUNC(callback_cancel_sendoffline), (gpointer) sow);
	gtk_container_add(GTK_CONTAINER(sow->button),
		xpm_label_box(sow->window, pixmapdata_cancel, "Cancel"));

	gtk_widget_show(sow->window);
	return;
}
