/* Standard system headers */
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

/* Dependant library headers */
#include <gdk/gdkkeysyms.h>

/* Project headers */
#include "gtkyahoo.h"
#include "window-conference.h"

/* Maybe I should put these in a "private" header file */
static gint find_invitee(gchar * user, GtkCList * invitees);
static void add_invitee(gchar * user, GtkCList * invitees);
static void del_invitee(gchar * user, GtkCList * invitees);
static GtkWidget *create_start_conference(void);
static gboolean on_conference_delete_event(GtkWidget * widget,
	GdkEvent * event, gpointer user_data);
static void on_cancel_clicked(GtkButton * button, gpointer user_data);
static void on_fadd_clicked(GtkButton * button, gpointer user_data);
static void on_fdel_clicked(GtkButton * button, gpointer user_data);
static void on_uadd_clicked(GtkButton * button, gpointer user_data);
static void on_invite_clicked(GtkButton * button, gpointer user_data);
static void on_user_activate(GtkEditable * editable, gpointer user_data);
static void on_uadd_clicked(GtkButton * button, gpointer user_data);
static void on_invite_clicked(GtkButton * button, gpointer user_data);
static void on_invite_clicked(GtkButton * button, gpointer user_data);
static void on_user_activate(GtkEditable * editable, gpointer user_data);
static void on_uadd_clicked(GtkButton * button, gpointer user_data);
static void on_fadd_clicked(GtkButton * button, gpointer user_data);
static void on_fdel_clicked(GtkButton * button, gpointer user_data);
static void on_invitees_select_row(GtkCList * clist, gint row, gint column,
	GdkEvent * event, gpointer user_data);
static void on_invitees_unselect_row(GtkCList * clist, gint row, gint column,
	GdkEvent * event, gpointer user_data);
static gboolean on_friends_button_press_event(GtkWidget * friends,
	GdkEventButton * event, gpointer user_data);
static void on_friends_select_row(GtkCTree * clist, gint row, gint column,
	GdkEvent * event, gpointer user_data);
static void on_friends_unselect_row(GtkCTree * clist, gint row, gint column,
	GdkEvent * event, gpointer user_data);
static gboolean on_invitees_button_press_event(GtkWidget * invitees,
	GdkEventButton * event, gpointer user_data);
static void on_invitees_select_row(GtkCList * clist, gint row, gint column,
	GdkEvent * event, gpointer user_data);
static void on_invitees_unselect_row(GtkCList * clist, gint row, gint column,
	GdkEvent * event, gpointer user_data);

/* static data */
/* These have to go into a hash **real** soon */
static gchar *invitee_selected = NULL;
static gchar *friend_selected = NULL;
static GtkWidget *start_conference_window = NULL;
static size_t invitee_count = 0;

/**********************************************************************************************************************************/
/* Interface (global) functions */
/**********************************************************************************************************************************/

void create_start_conference_window(void)
{
	if (context == NULL)
		return;

	if (!start_conference_window)
	{
		gtk_widget_show(start_conference_window = create_start_conference());
	}
}

void update_start_conference_window(void)
{
	if (start_conference_window)
	{
		GtkCTree *friends =
			GTK_CTREE(gtk_object_get_data(GTK_OBJECT(start_conference_window),
				"friends"));

		if (friends)
			make_friends_ctree(friends, FALSE);
	}
}

/**********************************************************************************************************************************/
/* Implementation (local) functions */
/**********************************************************************************************************************************/

static GtkWidget *create_start_conference(void)
{
	GtkWidget *conference;
	GtkWidget *thirds;
	GtkWidget *top3rdbx;
	GtkWidget *host_bx;
	GtkWidget *host;
	GtkWidget *hosts;
	GtkWidget *hosts_menu;
	GtkWidget *menuitem;
	GtkWidget *intro;
	GtkWidget *middle3rd_bx;
	GtkWidget *friends_scr;
	GtkWidget *friends;
	GtkWidget *friends_lbl;
	GtkWidget *addDel_bx;
	GtkWidget *fadd;
	GtkWidget *fdel;
	GtkWidget *users_bx;
	GtkWidget *invitees_scr;
	GtkWidget *invitees;
	GtkWidget *invitees_lbl;
	GtkWidget *user_bx;
	GtkWidget *user;
	GtkWidget *uadd;
	GtkWidget *lwr3rd_bx;
	GtkWidget *invite_bx;
	GtkWidget *msg;
	GtkWidget *invitation;
	GtkWidget *yesOrNo_bx;
	GtkWidget *invite;
	GtkWidget *cancel;
	GtkAccelGroup *accel_group;
	GtkTooltips *tooltips;

	tooltips = gtk_tooltips_new();

	accel_group = gtk_accel_group_new();

	conference = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data(GTK_OBJECT(conference), "conference", conference);
	gtk_window_set_title(GTK_WINDOW(conference),
		"Invite Friends to a Conference");

	thirds = gtk_vbox_new(FALSE, 0);
	gtk_widget_ref(thirds);
	gtk_object_set_data_full(GTK_OBJECT(conference), "thirds", thirds,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(thirds);
	gtk_container_add(GTK_CONTAINER(conference), thirds);

	top3rdbx = gtk_vbox_new(FALSE, 0);
	gtk_widget_ref(top3rdbx);
	gtk_object_set_data_full(GTK_OBJECT(conference), "top3rdbx", top3rdbx,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(top3rdbx);
	gtk_box_pack_start(GTK_BOX(thirds), top3rdbx, TRUE, TRUE, 0);

	host_bx = gtk_hbox_new(FALSE, 0);
	gtk_widget_ref(host_bx);
	gtk_object_set_data_full(GTK_OBJECT(conference), "host_bx", host_bx,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(host_bx);
	gtk_box_pack_start(GTK_BOX(top3rdbx), host_bx, TRUE, TRUE, 0);
	gtk_widget_set_usize(host_bx, -2, 30);

	host = gtk_label_new("Host:");
	gtk_widget_ref(host);
	gtk_object_set_data_full(GTK_OBJECT(conference), "host", host,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(host);
	gtk_box_pack_start(GTK_BOX(host_bx), host, FALSE, FALSE, 0);
	gtk_label_set_justify(GTK_LABEL(host), GTK_JUSTIFY_LEFT);
	gtk_misc_set_padding(GTK_MISC(host), 23, 0);

	hosts = gtk_option_menu_new();
	gtk_widget_ref(hosts);
	gtk_object_set_data_full(GTK_OBJECT(conference), "hosts", hosts,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(hosts);
	gtk_box_pack_start(GTK_BOX(host_bx), hosts, FALSE, FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hosts), 1);
	gtk_tooltips_set_tip(tooltips, hosts,
		"The Yahoo! ID you'll use to host the Conference", NULL);
	hosts_menu = gtk_menu_new();
	if (context && context->identities)
	{
		int i = 0;
		char *id = NULL;

		while (NULL != (id = (context->identities)[i]))
		{
			menuitem = gtk_menu_item_new_with_label(id);
			gtk_widget_show(menuitem);
			gtk_object_set_data(GTK_OBJECT(menuitem), "id", id);
			gtk_menu_append(GTK_MENU(hosts_menu), menuitem);
			++i;
		}
	}
	gtk_option_menu_set_menu(GTK_OPTION_MENU(hosts), hosts_menu);

	intro =
		gtk_label_new
		("Select friends or groups from the list on the left and double-click or click \"Add\" to invite them to your conference.  To add somebody who is not on the list, type his or her Yahoo! ID in the box and click \"Add\".");
	gtk_widget_ref(intro);
	gtk_object_set_data_full(GTK_OBJECT(conference), "intro", intro,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(intro);
	gtk_box_pack_start(GTK_BOX(top3rdbx), intro, FALSE, FALSE, 0);
	gtk_widget_set_usize(intro, 550, -2);
	gtk_label_set_justify(GTK_LABEL(intro), GTK_JUSTIFY_FILL);
	gtk_label_set_line_wrap(GTK_LABEL(intro), TRUE);

	middle3rd_bx = gtk_hbox_new(TRUE, 0);
	gtk_widget_ref(middle3rd_bx);
	gtk_object_set_data_full(GTK_OBJECT(conference), "middle3rd_bx",
		middle3rd_bx, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(middle3rd_bx);
	gtk_box_pack_start(GTK_BOX(thirds), middle3rd_bx, TRUE, TRUE, 0);

	friends_scr = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_ref(friends_scr);
	gtk_object_set_data_full(GTK_OBJECT(conference), "friends_scr",
		friends_scr, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(friends_scr);
	gtk_box_pack_start(GTK_BOX(middle3rd_bx), friends_scr, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(friends_scr),
		GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

	friends = gtk_ctree_new(1, 0);
	gtk_widget_ref(friends);
	gtk_object_set_data_full(GTK_OBJECT(conference), "friends", friends,
		(GtkDestroyNotify) gtk_widget_unref);
	make_friends_ctree(GTK_CTREE(friends), FALSE);
	gtk_widget_show(friends);
	gtk_container_add(GTK_CONTAINER(friends_scr), friends);
	gtk_clist_set_column_width(GTK_CLIST(friends), 0, 80);
	gtk_clist_column_titles_hide(GTK_CLIST(friends));

	friends_lbl = gtk_label_new("Friends");
	gtk_widget_ref(friends_lbl);
	gtk_object_set_data_full(GTK_OBJECT(conference), "friends_lbl",
		friends_lbl, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(friends_lbl);
	gtk_clist_set_column_widget(GTK_CLIST(friends), 0, friends_lbl);

	addDel_bx = gtk_vbutton_box_new();
	gtk_widget_ref(addDel_bx);
	gtk_object_set_data_full(GTK_OBJECT(conference), "addDel_bx", addDel_bx,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(addDel_bx);
	gtk_box_pack_start(GTK_BOX(middle3rd_bx), addDel_bx, TRUE, TRUE, 0);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(addDel_bx),
		GTK_BUTTONBOX_SPREAD);

	fadd = gtk_button_new_with_label("Add >>");
	gtk_widget_ref(fadd);
	gtk_object_set_data_full(GTK_OBJECT(conference), "fadd", fadd,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(fadd);
	gtk_container_add(GTK_CONTAINER(addDel_bx), fadd);
	GTK_WIDGET_SET_FLAGS(fadd, GTK_CAN_DEFAULT);
	gtk_tooltips_set_tip(tooltips, fadd,
		"Add a selected user or group to the \"invitees\"", NULL);

	fdel = gtk_button_new_with_label("<< Remove");
	gtk_widget_ref(fdel);
	gtk_object_set_data_full(GTK_OBJECT(conference), "fdel", fdel,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(fdel);
	gtk_container_add(GTK_CONTAINER(addDel_bx), fdel);
	GTK_WIDGET_SET_FLAGS(fdel, GTK_CAN_DEFAULT);
	gtk_tooltips_set_tip(tooltips, fdel,
		"Remove a selected user or group from the \"invitees\"\n", NULL);

	users_bx = gtk_vbox_new(FALSE, 0);
	gtk_widget_ref(users_bx);
	gtk_object_set_data_full(GTK_OBJECT(conference), "users_bx", users_bx,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(users_bx);
	gtk_box_pack_start(GTK_BOX(middle3rd_bx), users_bx, TRUE, TRUE, 0);

	invitees_scr = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_ref(invitees_scr);
	gtk_object_set_data_full(GTK_OBJECT(conference), "invitees_scr",
		invitees_scr, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(invitees_scr);
	gtk_box_pack_start(GTK_BOX(users_bx), invitees_scr, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(invitees_scr),
		GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

	invitees = gtk_clist_new(1);
	gtk_widget_ref(invitees);
	gtk_object_set_data_full(GTK_OBJECT(conference), "invitees", invitees,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(invitees);
	gtk_container_add(GTK_CONTAINER(invitees_scr), invitees);
	gtk_tooltips_set_tip(tooltips, invitees,
		"These are the users and user groups you'll be inviting to the Conference",
		NULL);
	gtk_clist_set_column_width(GTK_CLIST(invitees), 0, 80);
	gtk_clist_column_titles_hide(GTK_CLIST(invitees));

	invitees_lbl = gtk_label_new("Invitees");
	gtk_widget_ref(invitees_lbl);
	gtk_object_set_data_full(GTK_OBJECT(conference), "invitees_lbl",
		invitees_lbl, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(invitees_lbl);
	gtk_clist_set_column_widget(GTK_CLIST(invitees), 0, invitees_lbl);

	user_bx = gtk_hbox_new(FALSE, 0);
	gtk_widget_ref(user_bx);
	gtk_object_set_data_full(GTK_OBJECT(conference), "user_bx", user_bx,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(user_bx);
	gtk_box_pack_start(GTK_BOX(users_bx), user_bx, TRUE, TRUE, 0);

	user = gtk_entry_new();
	gtk_widget_ref(user);
	gtk_object_set_data_full(GTK_OBJECT(conference), "user", user,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(user);
	gtk_box_pack_start(GTK_BOX(user_bx), user, TRUE, TRUE, 0);
	gtk_tooltips_set_tip(tooltips, user,
		"Enter a user or group to be invited and then click \"Add\" on the right",
		NULL);

	uadd = gtk_button_new_with_label("Add");
	gtk_widget_ref(uadd);
	gtk_object_set_data_full(GTK_OBJECT(conference), "uadd", uadd,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(uadd);
	gtk_box_pack_start(GTK_BOX(user_bx), uadd, FALSE, FALSE, 6);
	gtk_tooltips_set_tip(tooltips, uadd,
		"Add the entered user or group (from the left) to the invitees above",
		NULL);

	lwr3rd_bx = gtk_vbox_new(FALSE, 0);
	gtk_widget_ref(lwr3rd_bx);
	gtk_object_set_data_full(GTK_OBJECT(conference), "lwr3rd_bx", lwr3rd_bx,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(lwr3rd_bx);
	gtk_box_pack_start(GTK_BOX(thirds), lwr3rd_bx, TRUE, TRUE, 0);

	invite_bx = gtk_hbox_new(FALSE, 0);
	gtk_widget_ref(invite_bx);
	gtk_object_set_data_full(GTK_OBJECT(conference), "invite_bx", invite_bx,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(invite_bx);
	gtk_box_pack_start(GTK_BOX(lwr3rd_bx), invite_bx, TRUE, TRUE, 0);

	msg = gtk_label_new("Message:");
	gtk_widget_ref(msg);
	gtk_object_set_data_full(GTK_OBJECT(conference), "msg", msg,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(msg);
	gtk_box_pack_start(GTK_BOX(invite_bx), msg, FALSE, FALSE, 11);

	invitation = gtk_entry_new();
	gtk_widget_ref(invitation);
	gtk_object_set_data_full(GTK_OBJECT(conference), "invitation", invitation,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(invitation);
	gtk_box_pack_start(GTK_BOX(invite_bx), invitation, TRUE, TRUE, 4);
	gtk_tooltips_set_tip(tooltips, invitation,
		"The message you'll use as your invitation to this Conference", NULL);
	gtk_entry_set_text(GTK_ENTRY(invitation), "Join my Conference...");

	yesOrNo_bx = gtk_hbutton_box_new();
	gtk_widget_ref(yesOrNo_bx);
	gtk_object_set_data_full(GTK_OBJECT(conference), "yesOrNo_bx", yesOrNo_bx,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(yesOrNo_bx);
	gtk_box_pack_start(GTK_BOX(lwr3rd_bx), yesOrNo_bx, TRUE, TRUE, 0);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(yesOrNo_bx),
		GTK_BUTTONBOX_SPREAD);

	invite = gtk_button_new_with_label("Invite");
	gtk_widget_ref(invite);
	gtk_object_set_data_full(GTK_OBJECT(conference), "invite", invite,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(invite);
	gtk_container_add(GTK_CONTAINER(yesOrNo_bx), invite);
	GTK_WIDGET_SET_FLAGS(invite, GTK_CAN_DEFAULT);
	gtk_tooltips_set_tip(tooltips, invite, "Start the Conference", NULL);

	cancel = gtk_button_new_with_label("Cancel");
	gtk_widget_ref(cancel);
	gtk_object_set_data_full(GTK_OBJECT(conference), "cancel", cancel,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(cancel);
	gtk_container_add(GTK_CONTAINER(yesOrNo_bx), cancel);
	GTK_WIDGET_SET_FLAGS(cancel, GTK_CAN_DEFAULT);
	gtk_tooltips_set_tip(tooltips, cancel, "Do not start a Conference", NULL);
	gtk_widget_add_accelerator(cancel, "clicked", accel_group,
		GDK_Escape, 0, GTK_ACCEL_VISIBLE);

	gtk_signal_connect(GTK_OBJECT(conference), "delete_event",
		GTK_SIGNAL_FUNC(on_conference_delete_event), NULL);
	gtk_signal_connect(GTK_OBJECT(friends), "button_press_event",
		GTK_SIGNAL_FUNC(on_friends_button_press_event), NULL);
	gtk_signal_connect(GTK_OBJECT(friends), "select_row",
		GTK_SIGNAL_FUNC(on_friends_select_row), NULL);
	gtk_signal_connect(GTK_OBJECT(friends), "unselect_row",
		GTK_SIGNAL_FUNC(on_friends_unselect_row), NULL);
	gtk_signal_connect(GTK_OBJECT(fadd), "clicked",
		GTK_SIGNAL_FUNC(on_fadd_clicked), conference);
	gtk_signal_connect(GTK_OBJECT(fdel), "clicked",
		GTK_SIGNAL_FUNC(on_fdel_clicked), conference);
	gtk_signal_connect(GTK_OBJECT(invitees), "button_press_event",
		GTK_SIGNAL_FUNC(on_invitees_button_press_event), NULL);
	gtk_signal_connect(GTK_OBJECT(invitees), "select_row",
		GTK_SIGNAL_FUNC(on_invitees_select_row), NULL);
	gtk_signal_connect(GTK_OBJECT(invitees), "unselect_row",
		GTK_SIGNAL_FUNC(on_invitees_unselect_row), NULL);
	gtk_signal_connect(GTK_OBJECT(user), "activate",
		GTK_SIGNAL_FUNC(on_user_activate), invitees);
	gtk_signal_connect(GTK_OBJECT(uadd), "clicked",
		GTK_SIGNAL_FUNC(on_uadd_clicked), conference);
	gtk_signal_connect(GTK_OBJECT(invite), "clicked",
		GTK_SIGNAL_FUNC(on_invite_clicked), conference);
	gtk_signal_connect(GTK_OBJECT(cancel), "clicked",
		GTK_SIGNAL_FUNC(on_cancel_clicked), NULL);

	gtk_object_set_data(GTK_OBJECT(conference), "tooltips", tooltips);

	gtk_window_add_accel_group(GTK_WINDOW(conference), accel_group);

	return conference;
}

static gboolean on_conference_delete_event(GtkWidget * widget,
	GdkEvent * event, gpointer user_data)
{
	gtk_widget_destroy(GTK_WIDGET(start_conference_window));
	start_conference_window = NULL;
	return FALSE;
}

static void on_cancel_clicked(GtkButton * button, gpointer user_data)
{
	gtk_widget_destroy(GTK_WIDGET(start_conference_window));
	start_conference_window = NULL;
}

static void on_fadd_clicked(GtkButton * button, gpointer user_data)
{
	GtkCList *invitees =
		GTK_CLIST(gtk_object_get_data(GTK_OBJECT(start_conference_window),
			"invitees"));

	add_invitee(friend_selected, invitees);
}

static void on_fdel_clicked(GtkButton * button, gpointer user_data)
{
	if (button && user_data && invitee_selected)
	{
		GtkWindow *conference = GTK_WINDOW(user_data);

		if (conference)
		{
			GtkCList *invitees = NULL;

			invitees =
				GTK_CLIST(gtk_object_get_data(GTK_OBJECT(conference),
			 "invitees"));

			del_invitee(invitee_selected, invitees);
		}
	}
}

static void on_uadd_clicked(GtkButton * button, gpointer user_data)
{
	if (button && user_data)
	{
		GtkWindow *conference = GTK_WINDOW(user_data);

		if (conference)
		{
			GtkCList *invitees = NULL;
			GtkEntry *user = NULL;

			invitees =
				GTK_CLIST(gtk_object_get_data(GTK_OBJECT(conference),
			 "invitees"));
			user =
				GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(conference),
				 "user"));

			add_invitee(gtk_entry_get_text(user), invitees);

			if (user)
				gtk_entry_set_text(user, "");
		}
	}
}

static void on_invite_clicked(GtkButton * button, gpointer user_data)
{
	if (0 == invitee_count)
	{
		char *msgs[] =
			{ "You have not invited anyone to join your conference!!!!",

			NULL
		};

		create_alert_window("Conference Error", msgs, "Oops!", TRUE);
	}
	else if (button && user_data)
	{
		GtkOptionMenu *hosts =
			GTK_OPTION_MENU(gtk_object_get_data(GTK_OBJECT
(start_conference_window), "hosts"));

		if (hosts)
		{
			GtkMenu *host_menu = GTK_MENU(gtk_option_menu_get_menu(hosts));

			if (host_menu)
			{
				GtkMenuItem *selected = NULL;
				GtkEntry *invitation = NULL;
				gchar *text = NULL;
				char *hosted_by = NULL, **invited = NULL, *message = NULL;
				gint row = 0;
				GtkCList *invitees = NULL;

				invited = calloc(1 + invitee_count, sizeof(char *));

				selected =
					GTK_MENU_ITEM(gtk_menu_get_active(GTK_MENU(host_menu)));
				hosted_by =
					strdup(gtk_object_get_data(GTK_OBJECT(selected), "id"));
				invitees =
					GTK_CLIST(gtk_object_get_data(GTK_OBJECT
				 (start_conference_window), "invitees"));

				for (; 0 != gtk_clist_get_text(invitees, row, 0, &text);
					++row)
				{
					if (0 == row)
						DBG_Print("conference",
							"Starting Conference hosted by \"%s\"\tand the invitees are:",
							hosted_by);

					DBG_Print("conference", "\t\"%s\"", text);
					invited[row] = strdup(text);
				}

				invited[row] = NULL;

				invitation =
					GTK_ENTRY(gtk_object_get_data(GTK_OBJECT
			   (start_conference_window), "invitation"));
				message = strdup(gtk_entry_get_text(invitation));

				gtk_widget_destroy(GTK_WIDGET(start_conference_window));
				start_conference_window = NULL;

				{
					int title_length = 0;
					char *title = NULL;

#ifdef ENABLE_DEBUG
					srandom(0);
#endif /* def ENABLE_DEBUG */
					title = (gchar *) malloc(title_length =
						(strlen(hosted_by) + 5));
					snprintf(title, title_length, "%s-%d", hosted_by,
						(int) (random() % 10000));

					(void) create_conference(title, hosted_by, invited, message);
					free(hosted_by);

					yahoo_cmd_start_conf(context, title, invited, message,
						YAHOO_CONF_LEVEL_0);
					DBG_Print("conference", "Called yahoo_cmd_start_conf");
				}
			}
		}
	}
}

static void on_user_activate(GtkEditable * editable, gpointer user_data)
{
	if (editable && user_data)
	{
		GtkCList *invitees = GTK_CLIST(user_data);

		add_invitee(gtk_editable_get_chars(editable, 0, -1), invitees);
		gtk_editable_delete_text(editable, 0, -1);
	}
}

static gint find_invitee(gchar * user, GtkCList * invitees)
{
	if (user && *user && invitees)
	{
		gint row = 0;
		gchar *text = NULL;

		for (; 0 != gtk_clist_get_text(invitees, row, 0, &text); ++row)
		{
			if (0 == strcmp(user, text))
				return row;
		}

		return -1;
	}

	return -1;
}

static void del_invitee(gchar * user, GtkCList * invitees)
{
	gint row = -1;

	if (user && *user && -1 != (row = find_invitee(user, invitees)))
	{
		gchar *text = NULL;

		gtk_clist_freeze(GTK_CLIST(invitees));
		--invitee_count;
		gtk_clist_remove(GTK_CLIST(invitees), row);
		if (0 != gtk_clist_get_text(invitees, row, 0, &text))
		{
			gtk_clist_select_row(invitees, row, 0);
			invitee_selected = text;
		}
		else
		{
			invitee_selected = NULL;
		}
		gtk_clist_thaw(GTK_CLIST(invitees));
	}
}

static void add_invitee(gchar * user, GtkCList * invitees)
{
	if (user && *user && -1 == find_invitee(user, invitees))
	{
		gchar *newrow[] = { user, NULL };

		gtk_clist_freeze(GTK_CLIST(invitees));
		gtk_clist_append(invitees, newrow);
		++invitee_count;
		gtk_clist_thaw(GTK_CLIST(invitees));
	}
}

static gboolean
on_invitees_button_press_event(GtkWidget * invitees,
GdkEventButton * event, gpointer user_data)
{
	if (1 == event->button)
	{
		gint row, column;

		if (!gtk_clist_get_selection_info(GTK_CLIST(invitees),
				(gint) event->x, (gint) event->y, &row, &column))
			return FALSE;

		switch (event->type)
		{
			case GDK_BUTTON_PRESS:
				if (!invitee_selected)
					gtk_clist_get_text(GTK_CLIST(invitees), row, column,
						&invitee_selected);
				else
					invitee_selected = NULL;
				break;

			case GDK_2BUTTON_PRESS:
				gtk_clist_get_text(GTK_CLIST(invitees), row, column,
					&invitee_selected);
				del_invitee(invitee_selected, GTK_CLIST(invitees));
				break;

			default:
				break;
		}
	}

	return FALSE;
}

static void
on_invitees_select_row(GtkCList * clist,
gint row, gint column, GdkEvent * event, gpointer user_data)
{
	gtk_clist_get_text(clist, row, column, &invitee_selected);
}

static void
on_invitees_unselect_row(GtkCList * clist,
gint row, gint column, GdkEvent * event, gpointer user_data)
{
	invitee_selected = NULL;
}

static gboolean
on_friends_button_press_event(GtkWidget * friends,
GdkEventButton * event, gpointer user_data)
{
	if (1 == event->button)
	{
		gint row = 0, column = 0;

		if (!gtk_clist_get_selection_info(GTK_CLIST(friends), (gint) event->x,
				(gint) event->y, &row, &column))
			return FALSE;

		switch (event->type)
		{
			case GDK_2BUTTON_PRESS:
				{
					GtkCTreeNode *ctn = NULL;

					if (NULL != (ctn =
							gtk_ctree_node_nth(GTK_CTREE(friends), row)))
					{
						struct yahoo_buddy *buddy_selected =
							gtk_ctree_node_get_row_data(GTK_CTREE(friends),

							ctn);

						if (NULL != buddy_selected)
						{
							GtkCList *invitees =
								GTK_CLIST(gtk_object_get_data(GTK_OBJECT
									(start_conference_window), "invitees"));

							add_invitee(friend_selected =
								buddy_selected->id, invitees);
						}
					}
				}
				break;

			default:
				break;
		}
	}

	return FALSE;
}

static void
on_friends_select_row(GtkCTree * friends,
gint row, gint column, GdkEvent * event, gpointer user_data)
{
	GtkCTreeNode *ctn = NULL;

	if (NULL != (ctn = gtk_ctree_node_nth(GTK_CTREE(friends), row)))
	{
		struct yahoo_buddy *buddy_selected =
			gtk_ctree_node_get_row_data(GTK_CTREE(friends), ctn);

		if (NULL != buddy_selected)
			friend_selected = buddy_selected->id;
	}
}

static void
on_friends_unselect_row(GtkCTree * friends,
gint row, gint column, GdkEvent * event, gpointer user_data)
{
	friend_selected = NULL;
}
