/*
 * Copyright (C) 1998 Nathan Neulinger <nneul@umr.edu>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include "gtkyahoo.h"

/* Start a chat session from startchat window */
void startchat_callback(GtkWidget * widget, gpointer * data)
{
	char *active_id, *id, *msg;
	struct gtkyahoo_startchat_window *scw;
	struct gtkyahoo_chat_window *cw;

	/* get the window */
	scw = (struct gtkyahoo_startchat_window *) data;

	/* get the info from the window */
	active_id =
		strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(scw->
			combo_active_id)->entry)));
	id = strdup(gtk_entry_get_text(GTK_ENTRY(scw->entry_id)));
	msg = strdup(gtk_entry_get_text(GTK_ENTRY(scw->entry_msg)));

	/* get rid of the window since not needed */
	delete_startchat_window(NULL, NULL, data);

	/* send the message */
	cw = get_chat_window(active_id, id);
	gdk_window_raise(cw->window->window);

	/* send the message and add it to the window */
	if (msg[0] != 0)
	{
		have_user_activity();
		yahoo_cmd_msg(context, active_id, id, msg);
		append_chat_msg(cw, active_id, msg);
	}

	/* Grab focus */
	gtk_widget_grab_focus(cw->entry);

	/* free the temporary variables */
	free(active_id);
	free(id);
	free(msg);
}

/* Destroy a startchat window */
void delete_startchat_window(GtkWidget * widget,
	GdkEvent * event, gpointer * data)
{
	struct gtkyahoo_startchat_window *scw;

	scw = (struct gtkyahoo_startchat_window *) data;
	gtk_widget_destroy(GTK_WIDGET(scw->window));
	free(scw);
}

void callback_cancel_startchat(GtkWidget * widget, gpointer * data)
{
	delete_startchat_window(NULL, NULL, data);
}

/* Create a startchat window */
void create_startchat_window(void)
{
	GtkAccelGroup *accel_group;
	struct gtkyahoo_startchat_window *scw;

	/* Allocate local structure */
	scw = (struct gtkyahoo_startchat_window *) malloc(sizeof(*scw));

	/* Create main window */
	scw->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(scw->window), "GTKYahoo: Start Chat");
	gtk_container_border_width(GTK_CONTAINER(scw->window), 5);
	gtk_widget_realize(scw->window);

	/* Trap delete_event signal */
	gtk_signal_connect(GTK_OBJECT(scw->window), "delete_event",
		GTK_SIGNAL_FUNC(delete_startchat_window), (gpointer) scw);

	/* Create the table */
	scw->table = gtk_table_new(4, 2, FALSE);
	gtk_widget_show(scw->table);
	gtk_container_add(GTK_CONTAINER(scw->window), scw->table);

	/* Create the add-from entry and label */
	scw->label_active_id = gtk_label_new("Chat as:");
	gtk_misc_set_alignment(GTK_MISC(scw->label_active_id), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(scw->table), scw->label_active_id, 0, 1, 0, 1,
		GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(scw->label_active_id);

	scw->combo_active_id = create_combo_identities(current_user, FALSE);
	gtk_table_attach(GTK_TABLE(scw->table), scw->combo_active_id, 1, 2, 0, 1,
		GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
	gtk_widget_show(scw->combo_active_id);

	/* Create the add-from entry and label */
	scw->label_id = gtk_label_new("Chat with:");
	gtk_misc_set_alignment(GTK_MISC(scw->label_id), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(scw->table), scw->label_id, 0, 1, 1, 2,
		GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(scw->label_id);

	scw->entry_id = gtk_entry_new_with_max_length(40);
	gtk_table_attach(GTK_TABLE(scw->table), scw->entry_id, 1, 2, 1, 2,
		GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
	gtk_widget_show(scw->entry_id);

	if (user_selected)
	{
		gtk_entry_set_text(GTK_ENTRY(scw->entry_id), user_selected->id);
	}
	else
	{
		gtk_widget_grab_focus(scw->entry_id);
	}

	/* Create the add-from entry and label */
	scw->label_msg = gtk_label_new("Message:");
	gtk_misc_set_alignment(GTK_MISC(scw->label_msg), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(scw->table), scw->label_msg, 0, 1, 2, 3,
		GTK_FILL, GTK_FILL, 2, 2);
	gtk_widget_show(scw->label_msg);

	scw->entry_msg = gtk_entry_new_with_max_length(250);
	gtk_table_attach(GTK_TABLE(scw->table), scw->entry_msg, 1, 2, 2, 3,
		GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
	gtk_widget_show(scw->entry_msg);

	if (user_selected)
	{
		gtk_widget_grab_focus(scw->entry_msg);
	}
	gtk_signal_connect(GTK_OBJECT(scw->entry_msg), "activate",
		GTK_SIGNAL_FUNC(startchat_callback), (gpointer) scw);

	/* Create the hbox for the start/cancel buttons */
	scw->hbox = gtk_hbox_new(TRUE, 2);
	gtk_widget_show(scw->hbox);

	gtk_table_attach(GTK_TABLE(scw->table), scw->hbox, 1, 2, 3, 4,
		GTK_FILL, GTK_FILL, 2, 2);

	/* Create the start chat button */
	scw->button = gtk_button_new();
	gtk_box_pack_end(GTK_BOX(scw->hbox), scw->button, FALSE, TRUE, 2);
	gtk_widget_show(scw->button);
	gtk_signal_connect(GTK_OBJECT(scw->button), "clicked",
		GTK_SIGNAL_FUNC(startchat_callback), (gpointer) scw);
	gtk_container_add(GTK_CONTAINER(scw->button),
		xpm_label_box(scw->window, pixmapdata_send, "Start Chat"));

	/* Create the cancel button */
	scw->button = gtk_button_new();
	gtk_box_pack_end(GTK_BOX(scw->hbox), scw->button, FALSE, TRUE, 2);
	gtk_widget_show(scw->button);
	gtk_signal_connect(GTK_OBJECT(scw->button), "clicked",
		GTK_SIGNAL_FUNC(callback_cancel_startchat), (gpointer) scw);
	gtk_container_add(GTK_CONTAINER(scw->button),
		xpm_label_box(scw->window, pixmapdata_cancel, "Cancel"));

	accel_group = gtk_accel_group_new();
	gtk_widget_add_accelerator(scw->button, "clicked", accel_group,
		GDK_Escape, 0, GTK_ACCEL_VISIBLE);
	gtk_window_add_accel_group(GTK_WINDOW(scw->window), accel_group);

	gtk_widget_show(scw->window);
	return;
}
