#! /usr/bin/env python

import sys
import pygtk; pygtk.require("2.0")
import gtk

try:
	import gnomeapplet
except:
	import gnome.applet as gnomeapplet

from gtstarter_lib import *
import string

class gtstarter_applet:
	def __init__(self, applet, iid):
		self.applet = applet
		self.iid = iid
		self.__gts = gt_starter()
		self.__gts.init_applet_data()
		self.__context_menu = None #self.__gts.applet_menu_from_profiles(self.__terminal_starter)
		self.propxml="""
			<popup name="button3">
			<menuitem name="Item 1" verb="Run GTStarter" label="Run GTStarter..." pixtype="stock" pixname="gtk-execute"/>
			<menuitem name="Item 2" verb="About" label="_About..." pixtype="stock" pixname="gnome-stock-about"/>
			</popup>
			"""
		verbs = [ ("Run GTStarter",self.__start_app), ("About",self.__show_about) ]
		
		# if not starting as applet setup_menu fails:
		try:
			self.applet.setup_menu(self.propxml,verbs,None)
		except:
			pass
		
		self.__run_applet()
				
	def __start_app(self, *argv):
		self.__gts.applet_start_self()
		
	def __show_about(self, *argv):
		#override this two variables imported from gtstarter_lib
		SCRIPT_NAME = "GTStarter " + SCRIPT_VERSION + " / Applet"
		
		APPLET_VERSION = "0.1"
		
		pixbuf = gtk.gdk.pixbuf_new_from_file(GTS_ABOUT_PIX)
		gnome_about = gnome.ui.About(SCRIPT_NAME, APPLET_VERSION, SCRIPT_COPYRIGHT,
						SCRIPT_DESCR, SCRIPT_AUTHORS, SCRIPT_DOCU, SCRIPT_TRANS, pixbuf)
		gnome_about.set_icon(gtk.gdk.pixbuf_new_from_file(GTS_ICON))
		gnome_about.show()
		
	def __run_applet(self):
		self.__ev_box = gtk.EventBox()
		self.__ev_box.connect("button-press-event", self.__profiles_popup_menu)
		self.__text = gtk.Label("GTS")
		self.__icon = gtk.Image()
		panel_size = self.applet.get_size()

		self.__icon.set_from_pixbuf(gtk.gdk.pixbuf_new_from_file(GTS_ABOUT_PIX).scale_simple(panel_size,panel_size, gtk.gdk.INTERP_BILINEAR))
		self.__ev_box.add(self.__icon)
		
		'''
		fd = open("/home/klammer/debug1.txt", "w")
		check = dir(self.applet)
		for xx in check:
			fd.write(xx+", ")
			
		fd.write(str(panel_size))
		fd.write(str(self.applet.parent.parent))
		#fd.write(str(y))
		fd.close()
		'''
		
		self.applet.add(self.__ev_box)
		self.applet.show_all()


	def __profiles_popup_menu(self, ev_box_obj, gdk_event_object):
		if gdk_event_object.button == 1:
			#TODO: that's very dirty ... or??? :-)
			del self.__context_menu
			self.__context_menu = self.__gts.applet_menu_from_profiles(self.__terminal_starter)
			self.__context_menu.popup(None,None,None,gdk_event_object.button,gdk_event_object.time)
 

	def __terminal_starter(self,menu_item, menu_number):
		self.__gts.start_from_applet(menu_number)

	
def gts_factory(applet, iid):
	gtstarter_applet(applet, iid)
	return gtk.TRUE

if __name__ == "__main__":
	if len(sys.argv) == 2 and sys.argv[1] == "nopanel":
		dw = gtk.Window()
		gts_factory(dw, False)
		gtk.main()
	else:
		gnomeapplet.bonobo_factory("OAFIID:GTStarterApplet_Factory",
				gnomeapplet.Applet.__gtype__,
				"gtstarter_applet", "0", gts_factory)

"""
class MyApplet:
   def __init__(self,applet):
     verbs = [ ( "Properies", self.properties), ("About",self.about) ]
     applet.setup_menu("xml here",verbs,None)
   def properties(self):
     pass # and display properties
   def about(self):
     pass # and display about box.

"""

