import pygtk; pygtk.require("2.0")
import gtk
import gconf
import gnome.ui
try:
	import gnomevfs
except:
	import gnome.vfs as gnomevfs


GNOME_APP_ID = "gtstarter"
SCRIPT_VERSION = "0.4.6"
SCRIPT_NAME = "GTStarter"

SCRIPT_COPYRIGHT = "(c) 2005 Franz Klammer"
SCRIPT_DESCR = "Start the gnome-terminal from a list of configured profiles"
SCRIPT_AUTHORS = ["Franz Klammer <klammer@webonaut.com>"]
SCRIPT_DOCU = []
SCRIPT_TRANS = "TODO..."

PREFIX = "/usr/X11R6/"
ICON_DEF_PATH = PREFIX + "share/gnome/pixmaps/"
GTS_ICON = ICON_DEF_PATH + "nohost.png"
GTS_ABOUT_PIX = ICON_DEF_PATH + "nohost.png"

"""
TODO (or not todo):
	* add startup-paths to context-menu		(maybe)
	* settings-menue -> configuration dialog	(maybe)
	* preset config - don't load non existing values
	* try to make it run on Linux:			(HELP NEEDED! - don't have Linux)
		- where did i find/install the icon?
		- binary/lib installation path?
		- install script or Makefile?
		- which dependecies?
	* create a logo/icon for gtstarter		(later)
	* highlight icon on mouseover			(maybe)
	* translation?
"""

ui_string = """<ui>
  <menubar name='Menubar'>
    <menu action='FileMenu'>
      <menuitem action='Quit'/>
    </menu>
    <menu action='ViewMenu'>
      <menuitem action='Refresh'/>
      <separator/>
      <menuitem action='HideToolBar'/>
    </menu>
    <menu action='SettingsMenu'>
      <menuitem action='dblClick'/>
      <menuitem action='keepOpen'/>
      <menuitem action='remWinSize'/>
      <separator/>
      <menu action='remWinPosMenu'>
        <menuitem action='centerWindow'/>
        <menuitem action='remWinPos'/>
        <menuitem action='noDefWinPos'/>
      </menu>
    </menu>
    <menu action='helpMenu'>
      <menuitem action='helpAbout'/>
    </menu>
  </menubar>
  <toolbar name='Toolbar'>
    <toolitem action='Quit'/>
    <toolitem action='Refresh'/>
  </toolbar>
</ui>"""

class gt_starter(gnome.ui.App):
	
	def __init__(self):
		#gnome.program_init(GNOME_APP_ID, SCRIPT_VERSION)
		#gnome.ui.App.__init__(self, GNOME_APP_ID, SCRIPT_NAME)

		self.__gt_gconf_globals = "/apps/gnome-terminal/global/profile_list"
		self.__gconf_client = gconf.client_get_default()
		
		self.__start_double_click = False
		self.__keep_open = False			# don't close app after terminal start?
		self.__remember_wsize = False
		self.__win_startup_pos = 0			# 0=center window, 1=restore pos, 2=no window position
		self.__hide_toolbar = False
		self.__do_not_center_window = False		# if true == don't center window on startup? TODO: give variable a correct name!

		self.__my_conf_path = "/apps/"+GNOME_APP_ID
		self.__gconf_client.add_dir(self.__my_conf_path, gconf.CLIENT_PRELOAD_NONE)

		self.__cursor = "out"
		
		self.__active_profile = 0
		
		self.__context_menu = None
		
		self.__win_width = 420	
		self.__win_height = 320
		
		self.__winpos_x = 0
		self.__winpos_y = 0

		self.__iconlist = None

		self.__window_is_there = False	

		
	def __get_window_size_pos(self, *argv):
		if self.__window_is_there:
			self.__win_width, self.__win_height = self.get_size()
			self.__winpos_x, self.__winpos_y = self.get_position()
		


	def __quit_gtstarter(self, *argv):
		# always remember these values - even not used on next startup
		if self.__window_is_there:
			self.__gconf_client.set_int(self.__my_conf_path+"/window_width", self.__win_width)
			self.__gconf_client.set_int(self.__my_conf_path+"/window_height", self.__win_height)
			self.__gconf_client.set_int(self.__my_conf_path+"/window_x", self.__winpos_x)
			self.__gconf_client.set_int(self.__my_conf_path+"/window_y", self.__winpos_y)
		
		gtk.main_quit()
		
		
	def __load_profile_data(self):
		self.__profile_list = self.__gconf_client.get_list(self.__gt_gconf_globals, gconf.VALUE_STRING)
		self.__default_terminal_profile = self.__gconf_client.get_string("/apps/gnome-terminal/global/default_profile")

		self.__profiles_visible_names = []
		

	def __load_config(self):
		self.__start_double_click = self.__gconf_client.get_bool(self.__my_conf_path+"/double_click")
		self.__double_click_menu_item.set_active(self.__start_double_click)

		self.__keep_open = self.__gconf_client.get_bool(self.__my_conf_path+"/keep_open")
		self.__keep_open_menu_item.set_active(self.__keep_open)

		self.__remember_wsize = self.__gconf_client.get_bool(self.__my_conf_path+"/remember_wsize")
		self.__remember_wsize_menu_item.set_active(self.__remember_wsize)

		self.__win_startup_pos = self.__gconf_client.get_int(self.__my_conf_path+"/window_startup_position")
		self.__win_startup_pos_menu_item[self.__win_startup_pos].set_active(True)

		if self.__win_startup_pos == 0:
			self.set_position(gtk.WIN_POS_CENTER)
		elif self.__win_startup_pos == 1:			# restore last window position
			self.__winpos_x = self.__gconf_client.get_int(self.__my_conf_path+"/window_x")
			self.__winpos_y = self.__gconf_client.get_int(self.__my_conf_path+"/window_y")
			self.move(self.__winpos_x, self.__winpos_y)
		elif self.__win_startup_pos == 2:			# set no position just4info here
			pass  

		if self.__remember_wsize:
			self.__win_width = self.__gconf_client.get_int(self.__my_conf_path+"/window_width")
			self.__win_height = self.__gconf_client.get_int(self.__my_conf_path+"/window_height")
			self.set_default_size(self.__win_width, self.__win_height)
		else:
			self.set_default_size(self.__win_width, self.__win_height)

		self.__hide_toolbar = self.__gconf_client.get_bool(self.__my_conf_path+"/hide_toolbar")
		self.__hide_toolbar_menu_item.set_active(self.__hide_toolbar)

			
	def __set_click_behaviour(self, gtk_action_obj):
		self.__start_double_click = gtk_action_obj.get_active()
		self.__gconf_client.set_bool(self.__my_conf_path+"/double_click", self.__start_double_click)


	def __set_quit_behaviour(self, gtk_action_obj):
		self.__keep_open = gtk_action_obj.get_active()
		self.__gconf_client.set_bool(self.__my_conf_path+"/keep_open", self.__keep_open)
				
		
	def __set_rem_wsize(self, gtk_action_obj):
		self.__remember_wsize = gtk_action_obj.get_active()
		self.__gconf_client.set_bool(self.__my_conf_path+"/remember_wsize", self.__remember_wsize)
		self.__get_window_size_pos()
		

	def __set_hide_toolbar(self, gtk_action_obj):
		print dir(gtk_action_obj)
		print gtk_action_obj.get_active()
		self.__hide_toolbar = gtk_action_obj.get_active()
		self.__gconf_client.set_bool(self.__my_conf_path+"/hide_toolbar", self.__hide_toolbar)
		self.__toggle_toolbar()


	def __set_window_position(self, gtk_action_obj, gtk_radion_action_obj):
		self.__win_startup_pos = gtk_radion_action_obj.get_current_value()
		self.__gconf_client.set_int(self.__my_conf_path+"/window_startup_position", self.__win_startup_pos)
		self.__get_window_size_pos()


	def dummy(self, *argv):
		pass


	def __toggle_toolbar(self):
		if self.__hide_toolbar:
			self.get_dock_item_by_name("Toolbar").hide()
		else:
			self.get_dock_item_by_name("Toolbar").show()


	def __create_menu_and_toolbar(self):
		ag = gtk.ActionGroup('WindowActions')
		my_actions = [
			('FileMenu', None, 		'_File'),
			( "Quit",    gtk.STOCK_QUIT,	'_Quit', '<control>Q', 'Quit application', self.__quit_gtstarter ),

			('ViewMenu', None, '_View'),
			( "Refresh",	gtk.STOCK_REFRESH,	'_Refresh',	 '<control>R', 'Refresh', self.__build_iconlist ),

			('SettingsMenu', None, '_Settings'),
			('remWinPosMenu', None, 'window position'),
			('helpMenu', None, '_Help'),
			( "helpAbout",	gtk.STOCK_ABOUT,	'_About',	 None, None, self.show_about )
			]
		my_toggle_actions = [
			( "remWinSize",  None,			'remember window size', None,        None,      self.__set_rem_wsize, False),
			( "HideToolBar", None,			'hide toolbar',   None,        None,      self.__set_hide_toolbar, False),
			( "dblClick",    None,			'_double click',  None,        None,      self.__set_click_behaviour, False),
			( "keepOpen",    None,			'_keep open',     None,        None,      self.__set_quit_behaviour, False)
			]

		my_radio_actions = [
			('centerWindow', None, 'center window', None, None, 0),
			('remWinPos', None, 'remember window position', None, None, 1),
			('noDefWinPos', None, ' no default window postition', None, None, 2)
			]

		ag.add_actions(my_actions)
		ag.add_toggle_actions(my_toggle_actions)
		ag.add_radio_actions(my_radio_actions, 0, self.__set_window_position)
		self.ui.insert_action_group(ag, 0)
		self.add_accel_group(self.ui.get_accel_group())

		menu = self.ui.get_widget('/Menubar')
		self.set_menus(menu)

		self.__toolbar = self.ui.get_widget('/Toolbar')
		self.set_toolbar(self.__toolbar)

		self.__double_click_menu_item = self.ui.get_action("ui/Menubar/SettingsMenu/dblClick")
		self.__keep_open_menu_item = self.ui.get_action("ui/Menubar/SettingsMenu/keepOpen")
		self.__remember_wsize_menu_item = self.ui.get_action("ui/Menubar/SettingsMenu/remWinSize")
		self.__win_startup_pos_menu_item = []
		self.__win_startup_pos_menu_item.append(self.ui.get_action("ui/Menubar/SettingsMenu/remWinPosMenu/centerWindow"))
		self.__win_startup_pos_menu_item.append(self.ui.get_action("ui/Menubar/SettingsMenu/remWinPosMenu/remWinPos"))
		self.__win_startup_pos_menu_item.append(self.ui.get_action("ui/Menubar/SettingsMenu/remWinPosMenu/noDefWinPos"))

		self.__hide_toolbar_menu_item = self.ui.get_action("ui/Menubar/ViewMenu/HideToolBar")


	def __build_gui(self):
		gnome.program_init(GNOME_APP_ID, SCRIPT_VERSION)
		gnome.ui.App.__init__(self, GNOME_APP_ID, SCRIPT_NAME)

		self.ui = gtk.UIManager()
		self.ui.add_ui_from_string(ui_string)

		self.__create_menu_and_toolbar()

		self.connect('destroy', self.__quit_gtstarter)

		self.set_icon(gtk.gdk.pixbuf_new_from_file(GTS_ICON))
		self.__statusbar = gtk.Statusbar()
		self.__statusbar.set_has_resize_grip(True)
		self.__statusbar.show()
		self.set_statusbar(self.__statusbar)

		self.__scrolledwin = gtk.ScrolledWindow()
		self.__scrolledwin.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)

		__iconlist_adjustment = gtk.Adjustment()
		self.__iconlist = gnome.ui.IconList(100, __iconlist_adjustment, 0)
		self.__iconlist.connect("select_icon", self.__select_handler)
		self.__iconlist.connect("motion-notify-event", self.__mouse_motion_handler)
		self.__iconlist.show()
		self.__build_iconlist()

		self.__scrolledwin.add(self.__iconlist)
		self.__scrolledwin.show()

		self.set_contents(self.__scrolledwin)
		
		self.__load_config()

		self.show()
		self.__window_is_there = True
		self.connect('configure-event', self.__get_window_size_pos)
		
		self.__toggle_toolbar()


		gtk.main()
	

	def __rebuild_iconlist(self, *argv):
		self.__build_iconlist()
		self.__set_statusbar_text("terminal profiles reloaded")		


	def __build_iconlist(self, *argv):

		self.__load_profile_data()
		self.__iconlist.clear()

		for profile_name in self.__profile_list:
			profile_icon_name, visible_name = self.__get_data_from_profile(profile_name)
			profile_icon = gtk.gdk.pixbuf_new_from_file(profile_icon_name)

			if profile_name == self.__default_terminal_profile:
				visible_name = "["+visible_name+"]"

			new_ico = self.__iconlist.append_pixbuf(profile_icon, visible_name, visible_name)


	def __select_handler(self, iconlist_obj, icon_idx, gdk_event_object):

		if gdk_event_object:
			#print gdk_event_object.type, gdk_event_object.button

			if  self.__start_double_click:
				if gdk_event_object.type == 5 and gdk_event_object.button == 1:
					self.__starter()
			else:
				if gdk_event_object.type == 4 and gdk_event_object.button == 1:
					self.__starter()

			if gdk_event_object.type == 4 and gdk_event_object.button == 3:
				self.__right_click_menue(icon_idx, gdk_event_object)


	def __right_click_menue(self, icon_idx, gdk_event_object):
		
		if not self.__context_menu:
			items = [('set-gt-def', 'set as gnome-terminal default profile', 0, 0, None)]
			aliases = [('set-gt-def', gtk.STOCK_PROPERTIES)]
			gtk.stock_add(items)
			factory = gtk.IconFactory()
			factory.add_default()
			
			for new_stock, alias in aliases:
				icon_set = gtk.icon_factory_lookup_default(alias)
				factory.add(new_stock, icon_set)
			
			entries = [
				(gtk.STOCK_OPEN, self.__start_with_window, 1),
				("---", None, 0),
				("set-gt-def", self.__set_terminal_default_profile, 1)
			]
	
			self.__context_menu = gtk.Menu()
			for stock_id,callback,sensitivity in entries:
				if stock_id == "---":
					item = gtk.SeparatorMenuItem()
				else:
					item = gtk.ImageMenuItem(stock_id)
					item.connect("activate",callback)
					item.set_sensitive(sensitivity)
					
				item.show()
				self.__context_menu.append(item)
				
		self.__context_menu.popup(None,None,None,gdk_event_object.button,gdk_event_object.time)
 
		
	def __set_terminal_default_profile(self, menu_item = None):
		self.__gconf_client.set_string("/apps/gnome-terminal/global/default_profile", self.__profile_list[self.__active_profile])
		profile_icon_name, visible_name = self.__get_data_from_profile(self.__profile_list[self.__active_profile])
		self.__set_statusbar_text('set default terminal profile: "' + visible_name + '"')
		self.__build_iconlist()
		self.__iconlist.select_icon(self.__active_profile)
		
		
	def __mouse_motion_handler(self, iconlist_obj, gdk_event_obj):
		icon_under_mouse = self.__iconlist.get_icon_at(int(gdk_event_obj.x), int(gdk_event_obj.y))
		
		if not icon_under_mouse == -1: 
			self.__active_profile = icon_under_mouse
			
		if not self.__start_double_click:
			if icon_under_mouse >= 0 and self.__cursor == "out":
				new_cursor = gtk.gdk.Cursor(gtk.gdk.HAND2)
				gdk_event_obj.window.set_cursor(new_cursor)
				self.__cursor = "over"
			elif icon_under_mouse == -1 and self.__cursor == "over":
				new_cursor = gtk.gdk.Cursor(gtk.gdk.LEFT_PTR)
				gdk_event_obj.window.set_cursor(new_cursor)
				self.__cursor = "out"

		
	def __get_data_from_profile(self, profile_name):
		profile_icon = self.__gconf_client.get_string("/apps/gnome-terminal/profiles/"+profile_name+"/icon")
		visible_name = self.__gconf_client.get_string("/apps/gnome-terminal/profiles/"+profile_name+"/visible_name")

		if profile_icon[0] != "/":
			profile_icon = ICON_DEF_PATH + profile_icon

		return profile_icon, visible_name


	def __starter(self):
		self.__start_with_window()

		
	def __start_with_window(self, menu_item = None):
		profile_icon_name, visible_name = self.__get_data_from_profile(self.__profile_list[self.__active_profile])

		#workURI = gnomevfs.URI("file:///home/klammer/Desktop/screen2/%3F%3F%3F%3F%3F")
		#print workURI.path
		#cmd = "gnome-terminal --window-with-profile=\"" + visible_name + "\" --working-directory="+workURI.path

		cmd = "gnome-terminal --window-with-profile=\"" + visible_name + "\"" 

		pid = gnome.execute_shell(".", cmd)

		if not self.__keep_open:
			self.__quit_gtstarter()
		else:
			if self.__statusbar:
				context_id = self.__statusbar.get_context_id("profile_started")
				cur_status_id = self.__statusbar.push(context_id, 'start terminal using profile "' + visible_name + '"')


	def __set_statusbar_text(self, sb_text):
		context_id = self.__statusbar.get_context_id("sb_text")
		cur_status_id = self.__statusbar.push(context_id, sb_text)

		
	def applet_start_self(self):
		#TODO - really start python again ...????
		pid = gnome.execute_shell(".", "gtstarter")

		
	def applet_menu_get_profile_icon(self, profile_icon_name):
			profile_icon = gtk.gdk.pixbuf_new_from_file(profile_icon_name)
			profile_icon = profile_icon.scale_simple(24,24, gtk.gdk.INTERP_BILINEAR)
			img = gtk.Image()
			img.set_from_pixbuf(profile_icon)
			img.show()
			
			return img
		
		
	def applet_menu_from_profiles(self, callback_func):

		self.__load_profile_data()
		items = []
		entries = []
		aliases = []
		pf_icons = []
		for profile_name in self.__profile_list:
			profile_icon_name, visible_name = self.__get_data_from_profile(profile_name)
			img = self.applet_menu_get_profile_icon(profile_icon_name)
			pf_icons.append(img)

			if profile_name == self.__default_terminal_profile:
				visible_name = "["+visible_name+"]"

			items.append((profile_name, visible_name, 0, 0, None))
			entries.append((profile_name, callback_func, 1))
			aliases.append((profile_name, gtk.STOCK_PROPERTIES))

		gtk.stock_add(items)
		factory = gtk.IconFactory()
		factory.add_default()
		
		for new_stock, alias in aliases:
			icon_set = gtk.icon_factory_lookup_default(alias)
			factory.add(new_stock, icon_set)
				
		number = 0
		menu = gtk.Menu()
		for stock_id,callback,sensitivity in entries:
			if stock_id == "---":
				item = gtk.SeparatorMenuItem()
			else:
				item = gtk.ImageMenuItem(stock_id)
				item.connect("activate",callback, number)
				item.set_sensitive(sensitivity)
				item.set_image(pf_icons[number])
				
			item.show()
			menu.append(item)
			number = number +1
		
		return menu
			

	# do some init stuff normaly done by some functions in tje gui-version 
	def init_applet_data(self):
		pass
		# - will be done in applet_menu_from_profiles - self.__load_profile_data()

	def start_from_applet(self, menu_nr):
		self.__keep_open = True
		self.__statusbar = None
		self.__active_profile = menu_nr
		self.__starter()

	def gtstarter_run(self):
		self.__build_gui()
		
	def show_about(self, gtk_action_obj):
		pixbuf = gtk.gdk.pixbuf_new_from_file(GTS_ABOUT_PIX)
		gnome_about = gnome.ui.About(SCRIPT_NAME, SCRIPT_VERSION, SCRIPT_COPYRIGHT,
						SCRIPT_DESCR, SCRIPT_AUTHORS, SCRIPT_DOCU, SCRIPT_TRANS, pixbuf)
		gnome_about.set_icon(gtk.gdk.pixbuf_new_from_file(GTS_ICON))
		gnome_about.show()


