/*
  Guifications - The end all, be all, toaster popup plugin
  Copyright (C) 2003-2004 Gary Kramlich

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#ifndef GF_ITEM_OFFSET_H
#define GF_ITEM_OFFSET_H

#include <xmlnode.h>

#include "gf_item.h"

typedef struct _GfItemOffset GfItemOffset;

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

GfItemOffset *gf_item_offset_new(GfItem *item);
GfItemOffset *gf_item_offset_new_from_xmlnode(GfItem *item, xmlnode *node);
GfItemOffset *gf_item_offset_copy(GfItemOffset *offset);
void gf_item_offset_destroy(GfItemOffset *offset);

void gf_item_offset_set_value(GfItemOffset *offset, gint value);
gint gf_item_offset_get_value(GfItemOffset *offset);

void gf_item_offset_set_is_percentage(GfItemOffset *offset, gboolean is_offset);
gboolean gf_item_offset_get_is_percentage(GfItemOffset *offset);

GfItem *gf_item_offset_get_item(GfItemOffset *offset);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* GF_ITEM_OFFSET_H */
