/*
  Guifications - The end all, be all, toaster popup plugin
  Copyright (C) 2003-2004 Gary Kramlich

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#ifndef GF_ITEM_TEXT_H
#define GF_ITEM_TEXT_H

#include <glib.h>
#include <gdk/gdk.h>

#include <xmlnode.h>

typedef enum _GfItemTextClipping {
	GF_ITEM_TEXT_CLIPPING_TRUNCATE = 0,
	GF_ITEM_TEXT_CLIPPING_ELLIPSIS_START,
	GF_ITEM_TEXT_CLIPPING_ELLIPSIS_MIDDLE,
	GF_ITEM_TEXT_CLIPPING_ELLIPSIS_END,
	GF_ITEM_TEXT_CLIPPING_UNKNOWN
} GfItemTextClipping;

#define GF_ITEM_TEXT(obj)	((GfItemText *)(obj))

typedef struct _GfItemText GfItemText;

#include "gf_item.h"
#include "gf_event_info.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

void gf_item_text_init();
void gf_item_text_uninit();

GfItemText *gf_item_text_new(GfItem *item);
GfItemText *gf_item_text_new_from_xmlnode(GfItem *item, xmlnode *node);
GfItemText *gf_item_text_copy(GfItemText *text);
xmlnode *gf_item_text_to_xmlnode(GfItemText *text);
void gf_item_text_destroy(GfItemText *item_text);

void gf_item_text_set_format(GfItemText *item_text, const gchar *format);
const gchar *gf_item_text_get_format(GfItemText *item_text);
void gf_item_text_set_font(GfItemText *item_text, const gchar *font);
const gchar *gf_item_text_get_font(GfItemText *item_text);
void gf_item_text_set_color(GfItemText *item_text, const gchar *color);
const gchar *gf_item_text_get_color(GfItemText *item_text);
void gf_item_text_set_clipping(GfItemText *item_text, GfItemTextClipping clipping);
GfItemTextClipping gf_item_text_get_clipping(GfItemText *item_text);
void gf_item_text_set_width(GfItemText *item_text, gint width);
gint gf_item_text_get_width(GfItemText *item_text);
void gf_item_text_set_item(GfItemText *item_text, GfItem *item);
GfItem *gf_item_text_get_item(GfItemText *item_text);

void gf_item_text_render(GfItemText *item_text, GdkPixbuf *pixbuf, GfEventInfo *info);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* GF_ITEM_TEXT_H */
