/*
  Guifications - The end all, be all, toaster popup plugin
  Copyright (C) 2003-2004 Gary Kramlich

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#ifndef GF_MENU_H
#define GF_MENU_H

#include <gtk/gtk.h>

typedef GtkWidget *(*GfMenuItemBuilder)(GtkWidget *menu, gint num);

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

GtkWidget *gf_menu_build(GfMenuItemBuilder builder);

GtkWidget *gf_menu_position(GtkWidget *menu, gint item);
GtkWidget *gf_menu_zoom(GtkWidget *menu, gint item);
GtkWidget *gf_menu_mouse(GtkWidget *menu, gint item);
GtkWidget *gf_menu_event(GtkWidget *menu, gint item);
GtkWidget *gf_menu_item_position(GtkWidget *menu, gint item);
GtkWidget *gf_menu_item_type(GtkWidget *menu, gint item);
GtkWidget *gf_menu_item_icon_type(GtkWidget *menu, gint item);
GtkWidget *gf_menu_item_icon_size(GtkWidget *menu, gint item);
GtkWidget *gf_menu_item_text_clipping(GtkWidget *menu, gint item);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
